/* **************************************************************** */
/*                                                                  */
/* **************************************************************** */
/*        IBM VisualAge for COBOL, IBM COBOL Set for AIX            */
/*        IBM COBOL for OS/390 & VM, IBM COBOL for MVS & VM         */
/* **************************************************************** */
/*                     OCO SOURCE MATERIALS                         */
/*                                                                  */
/*  IBM Confidential                                                */
/*                                                                  */
/*  OCO Source Materials                                            */
/*                                                                  */
/*  5639-I44, 5639-B92, 5765-548, 5648-A25, 5688-197                */
/*  (C) Copyright IBM Corp. 1983, 2000                              */
/*  All rights reserved                                             */
/*                                                                  */
/*  The source code for this program is not published or otherwise  */
/*  divested of its trade secrets, irrespective of what has been    */
/*  deposited with the U.S. Copyright Office.                       */
/* **************************************************************** */
/*                                                                  */
/*  Module Name: FTTFDBKW                                           */
/*                                                                  */
/*  Function Description:                                           */
/*    This module is written as a SYSADATA user-exit.  It collects  */
/*    information from ADATA records, builds and then writes out    */
/*    error messages in the format required by workstation develop- */
/*    ment tools such as CDE (AIX) and WorkFrame (OS/2).            */
/*                                                                  */
/*  Input:                                                          */
/*    Address of the user-exit arguments area containing all of     */
/*    the arguments passed to user-exit modules, including the      */
/*    ADATA record (when applicable).                               */
/*                                                                  */
/*  Output:                                                         */
/*    This module does not return a value.  Formatted error         */
/*    messages are written to stderr.                               */
/*                                                                  */
/*  Change Activity:                                                */
/*  Mo/Yr Description                                     APAR No   */
/*                                                                  */
/* **************************************************************** */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#ifdef _AIX
#define _POSIX_SOURCE
#include <limits.h>
#define MAX_FULL_PATH  PATH_MAX
#undef _POSIX_SOURCE
#else
#define MAX_FULL_PATH  _MAX_PATH
#endif

/********************************************************************
 * Constant definitions
 ********************************************************************/
#define SYSADATA          4     /* SYSADATA exit id                 */

#define TUXOPEN           0     /* OPEN opcode                      */
#define TUXCLOSE          1     /* CLOSE opcode                     */
#define TUXPUT            3     /* PUT opcode                       */

#define TUXBAD            1     /* Failed return code               */

#define JOB_ID       0x0000     /* job identification record        */
#define SRC_ERR      0x0032     /* source error record              */
#define SRC          0x0038     /* source record                    */
#define LIB_REC      0x0060     /* library record                   */
#define STAT         0x0090     /* statistics record                */
#define MAX_REC_LEN     700     /* maximum SYSADATA record length   */

#define FLAG_I            0     /* flag(I)                          */
#define FLAG_W            4     /* flag(W)                          */
#define FLAG_E            8     /* flag(E)                          */
#define FLAG_S           12     /* flag(S)                          */
#define FLAG_U           16     /* flag(U)                          */
#define FLAG_NONE       255     /* noflag                           */

#define MAX_ERR          50     /* used when allocating recarr      */

/********************************************************************
 * Typedefs for the user-exit arguments area
 ********************************************************************/
typedef struct {
   short strlen;                /* length of the argument string    */
   char  strtxt[64];            /* argument string                  */
} uxargs;

typedef struct {
   short type;                  /* user-exit type identifier        */
   short opcode;                /* operation code                   */
   long rc;                     /* return code                      */
   long bufferlen;              /* length of data buffer            */
   char *buffer;                /* address of data buffer           */
   long workarea[4];            /* user-exit work areas             */
   char *memname;               /* COPY member name                 */
   uxargs *argstr;              /* address of user-exit arg string  */
} uxparm;

/********************************************************************
 * Typedefs for ADATA records
 ********************************************************************/
#if defined(__OS2__) || defined(__WINDOWS__)
#pragma pack(1)
#else
#pragma options ALIGN=packed
#endif

/********************************************************************
 * ADATA common header
 ********************************************************************/
typedef struct {
   unsigned char  langcode;     /* language code                    */
   unsigned short type;         /* record type                      */
   unsigned char  level;        /* SYSADATA level                   */
   unsigned char  flags;        /* flags                            */
   unsigned char  edition;      /* edition number                   */
   unsigned char  reserved1[4]; /* reserved                         */
   signed   short length;       /* record length                    */
} adata_hdr;

#if defined(__OS2__) || defined(__WINDOWS__)
#pragma pack()
#else
#pragma options ALIGN=reset
#endif

/********************************************************************
 * File information structure for ADATA job identification record
 ********************************************************************/
typedef struct {
   short seqnum;                /* sequence number of file          */
   short filenamelen;           /* length of file name              */
   short volnamelen;            /* length of volume name            */
   short memnamelen;            /* length of member name            */
   char filename[1];            /* file name                        */
} file_info;

/********************************************************************
 * ADATA job identification record - type 0x0000
 ********************************************************************/
typedef struct {
   adata_hdr header;            /* ADATA header                     */
   char date[8];                /* date of compile                  */
   char time[4];                /* time of compile                  */
   char prodnum[8];             /* COBOL product number             */
   char prodver[8];             /* COBOL product version            */
   char ptf[8];                 /* COBOL PTF level number           */
   char sysid[24];              /* system id                        */
   char jobname[8];             /* jobname producing SYSADATA       */
   char stepname[8];            /* MVS stepname                     */
   char procstep[8];            /* MVS procedure stepname           */
   short numoffiles;            /* number of input files            */
   file_info filearr[1];        /* array of input file structures   */
} job_id_rec;

/********************************************************************
 * ADATA source error record - type 0x0032
 ********************************************************************/
typedef struct {
   adata_hdr header;            /* ADATA header                     */
   long stmtnum;                /* error source statement number    */
   char msgid[16];              /* error message identifier         */
   short severity;              /* error severity                   */
   short msgtxtlen;             /* error message text length        */
   unsigned char colnum;        /* column number (FIPS message)     */
   char reserved2[7];           /* reserved                         */
   char msgtxt[1];              /* error message text               */
} src_err_rec;

/********************************************************************
 * ADATA source record - type 0x0038
 ********************************************************************/
typedef struct {
   adata_hdr header;            /* ADATA header                     */
   long stmtnum;                /* listing line number              */
   long src_recno;              /* primary input source record#     */
   short primary_file_number;   /* primary input file number, 0 if  */
                                /* from a COPY or BASIS statement   */
   short library_file_number;   /* library file number if from COPY */
                                /* or BASIS statement, 0 if from a  */
                                /* primary input file               */
   char reserved2[8];           /* reserved                         */
   long prnt_recnum;            /* parent record number             */
   short prnt_primary_file_num; /* parent file sequence number      */
   short prnt_library_file_num; /* parent library file number       */
   char reserved3[8];           /* reserved                         */
   short srctxtlen;             /* source text length               */
   char reserved4[10];          /* reserved                         */
   char srcdata[1];             /* source record text data          */
} src_rec;

/********************************************************************
 * ADATA library record - type 0x0060
 ********************************************************************/
typedef struct {
   adata_hdr header;            /* ADATA header                     */
   short num_of_members;        /* number of COPY members described */
   short library_name_len;      /* length of library name           */
   short library_volume_len;    /* length of library volume ID.     */
   char  concatenation_num[2];  /* concatenation number of library  */
   short library_DDNAME_len;    /* length of library DDNAME         */
   char  reserved2[4];          /* reserved                         */
   short library_name[1];       /* library name                     */
} lib_rec;

/********************************************************************
 * ADATA library record file name area, this area is variably located
 * after the library_name string in the lib_rec.  To locate it:
 *
 *    ((char *)&(lr.library_name[0]) + lr.library_name_len +
 *      + lr.library_volume_len + lr.library_DDNAME_len)
 *
 ********************************************************************/
typedef struct {
   short copy_file_id;          /* number of COPY/BASIS file        */
   short copy_file_name_len;    /* length of COPY/BASIS file name   */
   short copy_file_name[1];     /* COPY/BASIS file name             */
} copy_file_rec;

/********************************************************************
 * Typedef for error record descriptor
 ********************************************************************/
typedef struct {
   long stmtnum;                /* statement number of error record */
   long fpos;                   /* file position of error record    */
   long reclen;                 /* length of error record           */
} recdesc;

/********************************************************************
 * Static globals and functions
 ********************************************************************/
static FILE *fp1, *fp2;
static char sidefile1[MAX_FULL_PATH+1];
static char sidefile2[MAX_FULL_PATH+1];
static char infilename[MAX_FULL_PATH+2];
static long pgmlines;
static long firstline=0;
static jmp_buf beginning;

void change_itoa(int n, char passed_cx[]);
void provideXMLEntityRefs(char passed_cx[], char returned_cx[]);
void process_sidefiles(void);
int compare(const void *, const void *);
void error_exit(long);

/********************************************************************
 * Static global storage for copy file names.
 ********************************************************************/
static  char **cpyfnarray=0;
static  int    cpyfnmaxidx=0;

/********************************************************************
 * FTTFDBKW
 ********************************************************************/
#if defined(__OS2__)
#pragma linkage (FTTFDBKW, system)
#endif

void
#if defined(__WINDOWS__)
_Export _stdcall
#endif
FTTFDBKW(uxparm *parm)
{
 job_id_rec    *jrec;
 lib_rec       *lr;
 copy_file_rec *cf;
 char **oldcpyfnarray;
 int  oldcpyfnmaxidx;
 char *cpyfile;
 int i;

 char pbresource_message_buffer[MAX_REC_LEN*2+1];
 char newxmlResourceLine[MAX_REC_LEN*2+1];
 /********************************************************/
 /*Defect 32466 - Error messages don't appear in the *****/
 /*  tasklist for Host codepage 930 - Has nothing to do  */
 /* with this workstation userexit, but fttfdbkw.c       */
 /*uses the same parsing routine that elaxmgux.c, the    */
 /*host user exit.  ErrMsgs.java needed to be changed so */
 /*it only had uppercase tags.                           */
 /********************************************************/
 /********************************************************/
 /*char CBLResourceTag[sizeof("<CBLResource>")] = "<CBLResource>";     */
 /*char CBLEndResourceTag[sizeof("</CBLResource>")] = "</CBLResource>";*/
 char CBLResourceTag[sizeof("<CBLResource>")] = "<CBLRESOURCE>";
 char CBLEndResourceTag[sizeof("</CBLResource>")] = "</CBLRESOURCE>";
 int  pbnumwritten;
 int  currentEndPos;
 /*****************************************************************
  * Mark the beginning of the user exit with setjmp.  If the
  * return value is 99, then execution has reached here due to a
  * longjmp(beginning,99) called in the error routine when
  * processing the side files.
  *****************************************************************/
 if (setjmp(beginning)==99)
    return;

 else {

   if (parm->type==SYSADATA) {
      switch(parm->opcode) {

         /***********************************************************
          * For an OPEN opcode, open the temporary sidefiles for
          * output and set the status of the OPEN request for the
          * compiler to check.
          ***********************************************************/
         case TUXOPEN:
            tmpnam(sidefile1);
            fp1 = fopen(sidefile1, "wb");
            tmpnam(sidefile2);
            fp2 = fopen(sidefile2, "wb");
            if (fp1==NULL || fp2==NULL) parm->rc = TUXBAD;
            break;

         /***********************************************************
          * For a PUT opcode, an action will be taken only if the
          * ADATA record is a job identification, source, source
          * error or statistics record.
          ***********************************************************/
         case TUXPUT:
            if (parm->bufferlen) {
               switch(((adata_hdr *)parm->buffer)->type) {

                  /**************************************************
                   * For a source record, save the line number from
                   * the source file so that when a statistics record
                   * is hit, the total number of lines in the program
                   * (and any previous programs) will be known.  This
                   * number will be used when there is a batch compile
                   * (i.e. multiple outer-most programs are contained
                   * in the input file specified to the compiler)
                   * because error records from later programs may
                   * have a statement number that is zero (e.g.
                   * invalid option is specified in a CBL statement).
                   * Since there will not be a matching source record
                   * to map the statement number to, the total number
                   * of lines from the previous program(s) will be
                   * used.  Write the record to sidefile2.
                   **************************************************/
                  case SRC:
                     pgmlines = ((src_rec *)parm->buffer)->src_recno;
                     if (fwrite(parm->buffer,
                                1,
                                parm->bufferlen,
                                fp2) != parm->bufferlen)
                        parm->rc = TUXBAD;
                     break;

                  /**************************************************
                   * For a source error record, write the record
                   * to sidefile1.
                   **************************************************/
                  case SRC_ERR:
                     if (fwrite(parm->buffer,
                                1,
                                parm->bufferlen,
                                fp1) != parm->bufferlen)
                        parm->rc = TUXBAD;
                     break;

                  /**************************************************
                   * For a job identification record, save the name
                   * of the input file specified to the compiler.
                   * The information for this file is kept in the
                   * first element of the file array in the job
                   * identification record.  Null terminate the name.
                   **************************************************/
                  case JOB_ID:
                     jrec = (job_id_rec *)parm->buffer;
                     if (jrec->numoffiles>0) {
                       memcpy(infilename,
                              jrec->filearr[0].filename,
                              jrec->filearr[0].filenamelen);
                       infilename[jrec->filearr[0].filenamelen] = '\0';

                       /************************************************************/
                       /* fix entity refs, and then use new buffer                 */
                       /************************************************************/

                         memset(newxmlResourceLine ,'\0',sizeof(newxmlResourceLine ));
                         provideXMLEntityRefs(infilename, newxmlResourceLine);
                       /****************************************/
                         memset(pbresource_message_buffer,'\0'
                                             ,sizeof(pbresource_message_buffer));
                         currentEndPos = 0;
                         memcpy(pbresource_message_buffer,
                                CBLResourceTag,
                                strlen(CBLResourceTag));
                         currentEndPos += strlen(CBLResourceTag);
                         memcpy(pbresource_message_buffer + currentEndPos,
                                              newxmlResourceLine,
                                              strlen(newxmlResourceLine));
                         currentEndPos += strlen(newxmlResourceLine);
                         memcpy(pbresource_message_buffer + currentEndPos,
                                              CBLEndResourceTag,
                                              strlen(CBLEndResourceTag));
                         currentEndPos += strlen(CBLEndResourceTag);
                         pbresource_message_buffer[currentEndPos] = '\n';
                         /*      pbresource_message_buffer[strlen(infilename)] = '\n';*/
                       /*rintf ("%s %s\n","PBResource = ",pbresource_message_buffer);*/
                       /*  pbnumwritten = fwrite (pbresource_message_buffer,
                            strlen(pbresource_message_buffer),
                             1,
                             error_message_stream); */

                         fprintf(stderr,pbresource_message_buffer);


                     }
                     break;

                  /**************************************************
                   * For a library record extract the copy file name.
                   * On the workstation only one COPY/BASIS file is
                   * inserted in each library record.
                   **************************************************/
                  case LIB_REC:

                    /************************************************
                     * Establish addressing to the library record and
                     * to the variably located copy file name.
                     ************************************************/
                     lr = (lib_rec *)parm->buffer;
                     cf = (copy_file_rec *)((char *)&(lr->library_name[0]) +
                                              lr->library_name_len +
                                              lr->library_volume_len +
                                              lr->library_DDNAME_len);

                    /************************************************
                     * The copy file name array contains pointers to
                     * the copy file path and name.  The array is
                     * indexed by the copy file number.  If the
                     * current copy file name array is not large
                     * enough for this copy file then allocate a
                     * larger array, copy the old array over, and
                     * free the original array.
                     ************************************************/
                     if (cf->copy_file_id >= cpyfnmaxidx) {
                       oldcpyfnmaxidx = cpyfnmaxidx;
                       cpyfnmaxidx = cf->copy_file_id + 10;
                       oldcpyfnarray = cpyfnarray;
                       cpyfnarray =
                               (char **)malloc(cpyfnmaxidx*sizeof(int));
                       memcpy(cpyfnarray,
                              oldcpyfnarray,
                              oldcpyfnmaxidx*sizeof(int));
                       if (oldcpyfnmaxidx)
                         free(oldcpyfnarray);
                       }

                    /************************************************
                     * Allocate a buffer large enough for the library
                     * name and store the address of the buffer in
                     * the array at the appropriate entry.  The
                     * library name is used because it contains the
                     * path and file name of the copy file, the copy
                     * file name only contains the file name.
                     ************************************************/
                     cpyfile = (char *)malloc(lr->library_name_len+1);
                     cpyfnarray[cf->copy_file_id] = cpyfile;

                    /************************************************
                     * Copy the copy file name to the buffer and
                     * terminate with a null character.
                     ************************************************/
                     memcpy(cpyfile, lr->library_name,
                                     lr->library_name_len);
                     cpyfile[lr->library_name_len] = '\0';
                     /*******************************************/

                       /************************************************************/
                       /* fix entity refs, and then overlay what was in infilename */
                       /************************************************************/

                         memset(newxmlResourceLine ,'\0',sizeof(newxmlResourceLine ));
                         provideXMLEntityRefs(cpyfile, newxmlResourceLine);
                       /****************************************/

                      memset(pbresource_message_buffer,'\0'
                                 ,sizeof(pbresource_message_buffer));
                      currentEndPos = 0;
                      memcpy(pbresource_message_buffer,
                             CBLResourceTag,
                             strlen(CBLResourceTag));
                      currentEndPos += strlen(CBLResourceTag);
                      memcpy(pbresource_message_buffer + currentEndPos,
                                  newxmlResourceLine,
                                  strlen(newxmlResourceLine));
                      currentEndPos += strlen(newxmlResourceLine);
                      memcpy(pbresource_message_buffer + currentEndPos,
                                           CBLEndResourceTag,
                                           strlen(CBLEndResourceTag));
                      currentEndPos += strlen(CBLEndResourceTag);
                      pbresource_message_buffer[ currentEndPos] = '\n';
          /*printf ("%s %s\n","PBResource = ",pbresource_message_buffer);  */
           /*  pbnumwritten = fwrite (pbresource_message_buffer,
                                   strlen(pbresource_message_buffer),
                                   1,
                                   error_message_stream);  */
                         fprintf(stderr,pbresource_message_buffer);




                     break;

                  /**************************************************
                   * For a statistics record, process the sidefiles.
                   * Since this may be a batch compile, the sidefiles
                   * will be reset for writing and the existing data
                   * discarded in preparation for storing the ADATA
                   * records from the next program.
                   **************************************************/
                  case STAT:

                     /***********************************************
                      * Open the sidefiles for reading.
                      ***********************************************/
                     fclose(fp1);
                     fclose(fp2);
                     fp1 = fopen(sidefile1, "rb");
                     fp2 = fopen(sidefile2, "rb");
                     if (fp1==NULL || fp2==NULL) parm->rc = TUXBAD;

                     /***********************************************
                      * Process the sidefiles.
                      ***********************************************/
                     process_sidefiles();

                     /***********************************************
                      * Open the sidefiles for writing and discard
                      * previous contents.
                      ***********************************************/
                     firstline = pgmlines+1;
                     fclose(fp1);
                     fclose(fp2);
                     fp1 = fopen(sidefile1, "wb");
                     fp2 = fopen(sidefile2, "wb");
                     if (fp1==NULL || fp2==NULL) parm->rc = TUXBAD;
                     break;

                  default:
                     break;
               }
            }
            break;

         /***********************************************************
          * For a CLOSE opcode, close and delete the sidefiles.
          ***********************************************************/
         case TUXCLOSE:
            fclose(fp1);
            fclose(fp2);
            remove(sidefile1);
            remove(sidefile2);
            break;

         /***********************************************************
          * Ignore any other opcode.
          ***********************************************************/
         default:
            break;
      }
   }
 }
}

/********************************************************************
 *               Static Function: process_sidefiles
 *
 * This function reads the sidefiles created by FTTFDBKW which
 * contain ADATA source records and source error records.  It
 * collects information from both files, builds, and then writes
 * out error messages in a format similar to C error messages.
 ********************************************************************/
static void process_sidefiles()
{
   long reclen, msgidlen, linenum;
   long i, nrecs, nstrucs;
   char buffer1[MAX_REC_LEN+1];
   char buffer2[MAX_REC_LEN*2+1];
   char *bptr, *p, sev_code;
   char *filename;
   src_err_rec *errrec;
   src_rec *srcrec;
   recdesc *recarr;
   adata_hdr *padh;
 /********************************/

   /******************************/
   /*message info for error file */
   /******************************/
   int linenum_length;
   int filename_length;
   int column_length;
   int msgtext_length;
   int end_of_buffer = 0;
   char error_message_buffer[MAX_REC_LEN*2+1];
   char colnum_str[20];
   char linenum_str[20];
   int numwritten;
   int currentEndPos;
   /*************************************/
   /*xml tags for error feedback        */
   /*************************************/
 /********************************************************/
 /*Defect 32466 - Error messages don't appear in the *****/
 /*  tasklist for Host codepage 930 - Has nothing to do  */
 /* with this workstation userexit, but fttfdbkw.c       */
 /*uses the same parsing routine that elaxmgux.c, the    */
 /*host user exit.  ErrMsgs.java needed to be changed so */
 /*it only had uppercase tags.                           */
 /********************************************************/
 /*char CBLMessageTag[sizeof("<CBLMessage>")] = "<CBLMessage>";         */
 /*char CBLEndMessageTag[sizeof("</CBLMessage>")] = "</CBLMessage>";    */
 /*char CBLFilenameTag[sizeof("<CBLFilename>")] = "<CBLFilename>";      */
 /*char CBLEndFilenameTag[sizeof("</CBLFilename>")] = "</CBLFilename>"; */
 /*char CBLLinenumberTag[sizeof("<CBLLinenumber>")] = "<CBLLinenumber>";*/
 /*char CBLEndLinenumberTag[sizeof("</CBLLinenumber>")] =               */
 /*                                                  "</CBLLinenumber>";*/
 /*char CBLColumnnumberTag[sizeof("<CBLColumnnumber>")] =               */
 /*                                                 "<CBLColumnnumber>";*/
 /*char CBLEndColumnnumberTag[sizeof("</CBLColumnnumber>")] =           */
 /*                                                "</CBLColumnnumber>";*/
 /*char CBLMsgIDTag[sizeof("<CBLMsgID>")] = "<CBLMsgID>";               */
 /*char CBLEndMsgIDTag[sizeof("</CBLMsgID>")] = "</CBLMsgID>";          */
 /*char CBLMsgtxtTag[sizeof("<CBLMsgtxt>")] = "<CBLMsgtxt>";            */
 /*char CBLEndMsgtxtTag[sizeof("</CBLMsgtxt>")] = "</CBLMsgtxt>";       */
 char CBLMessageTag[sizeof("<CBLMessage>")] = "<CBLMESSAGE>";
 char CBLEndMessageTag[sizeof("</CBLMessage>")] = "</CBLMESSAGE>";
 char CBLFilenameTag[sizeof("<CBLFilename>")] = "<CBLFILENAME>";
 char CBLEndFilenameTag[sizeof("</CBLFilename>")] = "</CBLFILENAME>";
 char CBLLinenumberTag[sizeof("<CBLLinenumber>")] = "<CBLLINENUMBER>";
 char CBLEndLinenumberTag[sizeof("</CBLLinenumber>")] =
                                                   "</CBLLINENUMBER>";
 char CBLColumnnumberTag[sizeof("<CBLColumnnumber>")] =
                                                  "<CBLCOLUMNNUMBER>";
 char CBLEndColumnnumberTag[sizeof("</CBLColumnnumber>")] =
                                                 "</CBLCOLUMNNUMBER>";
 char CBLMsgIDTag[sizeof("<CBLMsgID>")] = "<CBLMSGID>";
 char CBLEndMsgIDTag[sizeof("</CBLMsgID>")] = "</CBLMSGID>";
 char CBLMsgtxtTag[sizeof("<CBLMsgtxt>")] = "<CBLMSGTXT>";
 char CBLEndMsgtxtTag[sizeof("</CBLMsgtxt>")] = "</CBLMSGTXT>";
 char xmlFileLine[MAX_REC_LEN*2+1];
 char xmlLinenumberLine[MAX_REC_LEN*2+1];
 char xmlColumnnumberLine[MAX_REC_LEN*2+1];
 char xmlMsgIDLine[MAX_REC_LEN*2+1];
 char xmlMsgtxtLine[MAX_REC_LEN*2+1];
 char newxmlFileLine[MAX_REC_LEN*2+1];
 char newxmlLinenumberLine[MAX_REC_LEN*2+1];
 char newxmlColumnnumberLine[MAX_REC_LEN*2+1];
 char newxmlMsgIDLine[MAX_REC_LEN*2+1];
 char newxmlMsgtxtLine[MAX_REC_LEN*2+1];
 char xmlNewLine[sizeof(" \n")] = " \n";
   /*************************************/




#if defined(__OS2__) || defined(__WINDOWS__)
   char msgfmt[]="%s(%d:%d) : %s: %s\n";
#else
   char msgfmt[]="\"%s\", line %d.%d: %s %s\n";
#endif

   /*****************************************************************
    * Check if there are any error records in sidefile1 (the length
    * of the record is stored in the adata header).  If so, continue
    * processing.
    *****************************************************************/
   if (fread(buffer1, sizeof(adata_hdr), 1, fp1)) {

      /**************************************************************
       * Since there is no guarantee that the ADATA error records
       * from sidefile1 will be in ascending statement order
       * (because the compiler groups error records with the same
       * message together), the error records must be sorted first.
       * Allocate recarr, an array of MAX_ERR structures where each
       * structure will contain the statement number, file position
       * and record length of an error record.
       **************************************************************/
      nrecs = -1;
      nstrucs = MAX_ERR;
      recarr = (recdesc *)malloc(nstrucs * sizeof(recdesc));
      if (recarr == NULL)
         error_exit(0);

      /**************************************************************
       * Read in all the error records from sidefile1.
       **************************************************************/
      do {

         /***********************************************************
          * Check if the recarr array has been filled.  If so,
          * realloc a new block of storage to contain an additional
          * MAX_ERR structures.
          ***********************************************************/
         if (++nrecs > nstrucs-1) {
            nstrucs += MAX_ERR;
            recarr = (recdesc *)
            realloc(recarr, nstrucs * sizeof(recdesc));
            if (recarr == NULL)
               error_exit(0);
         }

         /***********************************************************
          * Save the file position of the current record in recarr.
          ***********************************************************/
         recarr[nrecs].fpos = ftell(fp1) - sizeof(adata_hdr);

         padh = (adata_hdr *)buffer1;
         reclen = padh->length;
         if (fread(buffer1+sizeof(adata_hdr),1,reclen,fp1) != reclen)
            error_exit(1);

         errrec = (src_err_rec *)buffer1;

         /***********************************************************
          * Save the statement number and record length.
          ***********************************************************/
         recarr[nrecs].stmtnum = errrec->stmtnum;
         recarr[nrecs].reclen = reclen + sizeof(adata_hdr);

      } while(fread(buffer1, sizeof(adata_hdr), 1, fp1));

      /**************************************************************
       * Sort the recarr array using the C function qsort.
       **************************************************************/
      qsort(recarr, nrecs+1, sizeof(recdesc), compare);

      /**************************************************************
       * Read the first source record from sidefile2.
       **************************************************************/
      bptr = buffer2;
      fread(bptr, sizeof(adata_hdr), 1, fp2);
      padh = (adata_hdr *)bptr;
      reclen = padh->length;
      if (fread(bptr+sizeof(adata_hdr),1,reclen,fp2) != reclen)
         error_exit(2);

      /**************************************************************
       * On Windows force two new lines.
       **************************************************************/
#if defined(__WINDOWS__)
   /*   fprintf(stderr,"\n\n"); */
#endif

      /**************************************************************
       * Read in the error records from sidefile1, this time in
       * ascending statement order.  For each error record, locate
       * the matching source record from sidefile2 by reading in
       * source records until the statement number from both records
       * match.  The source records will be in ascending statement
       * order also.  Then format components of the error messages
       * using information from the ADATA records.
       **************************************************************/
      for (i=0; i<=nrecs; i++) {

         /***********************************************************
          * Read in an error record from sidefile1.
          ***********************************************************/
         fseek(fp1, recarr[i].fpos, SEEK_SET);
         fread(buffer1, 1, recarr[i].reclen, fp1);
         errrec = (src_err_rec *)buffer1;

         /***********************************************************
          * Read source records from sidefile2 until the matching
          * one is found.  Special case when the statement number
          * from the error record is zero because there will not be
          * a matching source record.
          ***********************************************************/
         if (errrec->stmtnum==0) {
             linenum = firstline;
             filename = infilename;
         }
         else {
            while(errrec->stmtnum!=((src_rec *)bptr)->stmtnum) {
               fread(bptr, sizeof(adata_hdr), 1, fp2);
               padh = (adata_hdr *)bptr;
               reclen = padh->length;
               if (fread(bptr+sizeof(adata_hdr),1,reclen,fp2) != reclen)
                  error_exit(2);
            }
            srcrec = (src_rec *)bptr;
            linenum = srcrec->src_recno;

            /********************************************************
             * Locate the name of the source file where the error
             * was found.  The source file name may be either the
             * name of the input file specified to the compiler or
             * the name of a macro/copy member.  If the length of
             * the copy member is not zero, then the source file
             * must be a copy member.  Null terminate the name.
             ********************************************************/
            if (srcrec->library_file_number) {
               filename = cpyfnarray[srcrec->library_file_number];
            }
            else
               filename = infilename;
         }

         /***********************************************************
          * Format the message identifier (e.g. IGYPS2010-E) by
          * translating the severity to its corresponding letter
          * code, and appending a dash and the code at the end of
          * the message id (IGY+phase id+message#).
          ***********************************************************/
         switch(errrec->severity) {
            case FLAG_I: sev_code = 'I'; break;
            case FLAG_W: sev_code = 'W'; break;
            case FLAG_E: sev_code = 'E'; break;
            case FLAG_S: sev_code = 'S'; break;
            case FLAG_U: sev_code = 'U'; break;
            default:     sev_code = 'R'; break;
         }
         msgidlen = 11;
         errrec->msgid[msgidlen] = '\0';
         errrec->msgid[msgidlen-1] = sev_code;
         errrec->msgid[msgidlen-2] = '-';

         /***********************************************************
          * If the message is FIPS (message number range is
          * 8000-8999), the column number is saved in the ADATA
          * error record.  Convert the column number to a string.
          * Otherwise, the column number is not saved so search for
          * a column number in the message text since it may be
          * included.  If a column number is not present, specify
          * column 8 (start of area "A") unless the statement number
          * is zero.
          ***********************************************************/
         errrec->msgtxt[errrec->msgtxtlen] = '\0';
         if (errrec->msgid[5]!='8' && errrec->stmtnum!=0) {
            if ((p=strstr(errrec->msgtxt, "column ")) != NULL) {
               p += 7;
               while (*p>='0' && *p<='9') {
                  errrec->colnum = errrec->colnum*10 + *p - '0';
                  p++;
               }
            }
            else errrec->colnum = 8;
         }

         /***********************************************************
          * If the column number is zero, set it to one.  If the
          * line number is zero, set it to one.
          ***********************************************************/
         if (errrec->colnum==0) errrec->colnum = 1;
         if (linenum==0) linenum = 1;

         /***********************************************************
          * Write the formatted message to stderr.
          ***********************************************************/
         /**************************************/


        /**********construct error message line *********************/
        /*****use the strpbrk builtin                               */
        memset(error_message_buffer,'\0',sizeof(error_message_buffer));
        memset(linenum_str,'\0',sizeof(linenum_str));
        memset(colnum_str,'\0',sizeof(colnum_str));
        memset(xmlFileLine         ,'\0',sizeof(xmlFileLine        ));
        memset(xmlLinenumberLine   ,'\0',sizeof(xmlLinenumberLine  ));
        memset(xmlColumnnumberLine ,'\0',sizeof(xmlColumnnumberLine));
        memset(xmlMsgIDLine        ,'\0',sizeof(xmlMsgIDLine       ));
        memset(xmlMsgtxtLine       ,'\0',sizeof(xmlMsgtxtLine      ));
        memset(newxmlFileLine         ,'\0',sizeof(newxmlFileLine        ));
        memset(newxmlLinenumberLine   ,'\0',sizeof(newxmlLinenumberLine  ));
        memset(newxmlColumnnumberLine ,'\0',sizeof(newxmlColumnnumberLine));
        memset(newxmlMsgIDLine        ,'\0',sizeof(newxmlMsgIDLine       ));
        memset(newxmlMsgtxtLine       ,'\0',sizeof(newxmlMsgtxtLine      ));

        memcpy (xmlFileLine,filename,strlen(filename));
        provideXMLEntityRefs(xmlFileLine, newxmlFileLine);
        change_itoa(linenum,linenum_str);
        memcpy(xmlLinenumberLine,linenum_str, strlen(linenum_str));
        provideXMLEntityRefs(xmlLinenumberLine, newxmlLinenumberLine);
        change_itoa(errrec->colnum,colnum_str);
        memcpy(xmlColumnnumberLine,colnum_str,strlen(colnum_str));
        provideXMLEntityRefs(xmlColumnnumberLine, newxmlColumnnumberLine);
        memcpy(xmlMsgIDLine,errrec->msgid, strlen(errrec->msgid));
        provideXMLEntityRefs(xmlMsgIDLine, newxmlMsgIDLine);
        memcpy(xmlMsgtxtLine,errrec->msgtxt,strlen(errrec->msgtxt));
        provideXMLEntityRefs(xmlMsgtxtLine, newxmlMsgtxtLine);


        /*******************************************/
        /*Dump messages out like this              */
        /* <CBLMessage>                            */
        /* <CBLFilename>                           */
        /* filename characters                     */
        /* </CBLFilename>                          */
        /* <CBLLinenumber>                         */
        /* linenumber characters                   */
        /* </CBLLinenumber>                        */
        /* <CBLColumnnumber>                       */
        /* columnnumber characters                 */
        /* </CBLColumnnumber>                      */
        /* <CBLMsgID>                              */
        /* msg id characters                       */
        /* </CBLMsgID>                             */
        /* <CBLMsgtxt>                             */
        /* msg txt characters                      */
        /* </CBLMsgtxt>                            */
        /* </CBLMessage>                           */
        /*******************************************/
         fprintf (stderr,CBLMessageTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLFilenameTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,newxmlFileLine);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndFilenameTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLLinenumberTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,newxmlLinenumberLine);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndLinenumberTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLColumnnumberTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,newxmlColumnnumberLine);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndColumnnumberTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLMsgIDTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,newxmlMsgIDLine);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndMsgIDTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLMsgtxtTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,newxmlMsgtxtLine);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndMsgtxtTag);
         fprintf (stderr,xmlNewLine);
         fprintf (stderr,CBLEndMessageTag);
         fprintf (stderr,xmlNewLine);






     /*
         fprintf(stderr,
                 msgfmt,
                 filename,
                 linenum,
                 errrec->colnum,
                 errrec->msgid,
                 errrec->msgtxt);
      */
      }


      /**************************************************************
       * On Windows force a new line.
       **************************************************************/
#if defined(__WINDOWS__)
   /*   fprintf(stderr,"\n");*/
#endif
      /**************************************************************
       * Free storage allocated for recarr.
       **************************************************************/
      free(recarr);
   }
}

/********************************************************************
 *                  Static Function: compare
 *
 * This function compares the statement numbers and file positions
 * of two records.
 ********************************************************************/
static int compare(const void *p1, const void *p2) {
   if (((recdesc *)p1)->stmtnum > ((recdesc *)p2)->stmtnum)
     return (1);
   if (((recdesc *)p1)->stmtnum < ((recdesc *)p2)->stmtnum)
     return (-1);
   if (((recdesc *)p1)->fpos > ((recdesc *)p2)->fpos)
     return (1);
   if (((recdesc *)p1)->fpos < ((recdesc *)p2)->fpos)
     return (-1);
   return (0);
}


/*********************************************************************
*                     change_itoa
*
*     This function generates a character from an integer, used in
*     displaying line numbers and column numbers for error messages
**********************************************************************/
void change_itoa(int n, char passed_cx[])
{
   int i,j, sign;
   char r[20];
   char s[20];
   if ((sign = n) < 0)
      n = -n;
   i = 0;
   j = 0;
   do {
      s[i++] = n % 10 + '0';
      } while ((n /= 10) > 0);
   if (sign < 0)
      s[i++] = '-';
   s[i] = '\0';
   r[i] = '\0';
   i--;
   /*  reverse(s); */
   do{
      r[j++] = s[i--];
      }while(i>=0);
  /* printf("%s",r);*/
   memcpy (passed_cx,r,sizeof(r));
}
/*********************************************************************
*                     provideXMLEntityRefs
*
*     This function generates XML Entity Refs for the special XML Chars
*     replacing them in the XML Output string
**********************************************************************/
void provideXMLEntityRefs(char passed_cx[], char returned_cx[])
{
   char amp = '&';
   char apos = '\'';
   char quot = '\"';
   char gt = '>';
   char lt = '<';
   int inPos = 0;
   int outPos = 0;
 /********************************************************/
 /*Defect 32466 - Error messages don't appear in the *****/
 /*  tasklist for Host codepage 930 - Has nothing to do  */
 /* with this workstation userexit, but fttfdbkw.c       */
 /*uses the same parsing routine that elaxmgux.c, the    */
 /*host user exit.  ErrMsgs.java needed to be changed so */
 /*it only had uppercase tags.                           */
 /*Entity refs need to change to use numerics instead    */
 /********************************************************/
 /*  char ampRef[sizeof("&amp;")] = "&amp;";             */
 /*  char aposRef[sizeof("&apos;")] = "&apos;";          */
 /*  char quotRef[sizeof("&quot;")] = "&quot;";          */
 /*  char gtRef[sizeof("&gt;")] = "&gt;";                */
 /*  char ltRef[sizeof("&lt;")] = "&lt;";                */

   char ampRef[sizeof("&#38;")] = "&#38;";
   char aposRef[sizeof("&#39;")] = "&#39;";
   char quotRef[sizeof("&#34;")] = "&#34;";
   char gtRef[sizeof("&#62;")] = "&#62;";
   char ltRef[sizeof("&#60;")] = "&#60;";


   char * substring = "&\'\"><";
   int eRefLoc;
   eRefLoc = strcspn(passed_cx,substring);
   if (eRefLoc == strlen(passed_cx))
      {

        memcpy(returned_cx,
               passed_cx,
               strlen(passed_cx));

      }
   else
      {

       for (inPos=0;inPos<strlen(passed_cx);inPos++)
          {
         if (passed_cx[inPos] == amp)
            {
                 memcpy(returned_cx + outPos,
                        ampRef,
                        strlen(ampRef));
                 outPos += strlen(ampRef);
             }
          else if (passed_cx[inPos] == apos)
             {
                 memcpy(returned_cx + outPos,
                        aposRef,
                        strlen(aposRef));
                 outPos += strlen(aposRef);
             }
          else if (passed_cx[inPos] == quot)
             {
                 memcpy(returned_cx + outPos,
                        quotRef,
                        strlen(quotRef));
                 outPos += strlen(quotRef);
             }
          else if (passed_cx[inPos] == gt)
             {
                 memcpy(returned_cx + outPos,
                        gtRef,
                        strlen(gtRef));
                 outPos += strlen(gtRef);
              }
           else if(passed_cx[inPos] == lt)
              {
                 memcpy(returned_cx + outPos,
                        ltRef,
                        strlen(ltRef));
                 outPos += strlen(ltRef);
               }
            else
               {
               returned_cx[outPos] = passed_cx[inPos];
               outPos++;
               }   /*last else on a string of else ifs */


          } /* for loop*/


      }  /*if special char found */

}    /*provideEntityRefs */
/********************************************************************
 *                  Static Function: error_exit
 *
 *        This function generates an error message and exits.
 ********************************************************************/
static void error_exit(long msgno) {
   char *msgs[] = {
      "FTTFDBKW: Insufficient storage\n",
      "FTTFDBKW: An error occurred while reading sidefile1.\n",
      "FTTFDBKW: An error occurred while reading sidefile2.\n"
   };

   /* fprintf(stderr, msgs[msgno]); */
   longjmp(beginning,99);
}
