/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbUtil;
import com.ibm.dmh.util.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DbColumn {
    private String name = null;
    private int type = -1;
    private boolean allowNull = false;
    private long size = -1L;
    private Object defaultValue = null;
    private boolean optional;

    public DbColumn(String string, String string2, String string3, String string4, boolean bl) {
        this(string, DbUtil.getSqlType(string2), DbUtil.getSqlSize(string2), string3, string4, bl);
    }

    public DbColumn(String string, int n, long l, String string2, String string3, boolean bl) {
        this.name = string;
        this.type = n == -1 ? 12 : n;
        this.size = DbUtil.sqlTypeHasSize(n) ? l : 0L;
        this.allowNull = string3 != null && StringUtils.getBoolean((String)string3);
        if (string2 == null || string2.equalsIgnoreCase("NULL")) {
            this.defaultValue = null;
            return;
        }
        this.optional = bl;
        try {
            switch (n) {
                case 4: {
                    this.defaultValue = Integer.decode(StringUtils.isNumeric((String)string2) ? string2 : "0");
                    break;
                }
                case 5: {
                    this.defaultValue = Short.decode(StringUtils.isNumeric((String)string2) ? string2 : "0");
                    break;
                }
                case 6: {
                    this.defaultValue = new Float(string2);
                    break;
                }
                case 91: {
                    this.defaultValue = string2;
                    break;
                }
                case 93: {
                    this.defaultValue = string2;
                    break;
                }
                case 92: {
                    this.defaultValue = string2;
                    break;
                }
                case 1: {
                    if (string2.length() > 1) {
                        this.defaultValue = string2.substring(1, string2.length() - 1);
                        break;
                    }
                    this.defaultValue = string2;
                    break;
                }
                case 8: {
                    this.defaultValue = new Double(string2);
                    break;
                }
                case -1: 
                case 12: {
                    if (string2.length() > 2) {
                        this.defaultValue = string2.substring(1, string2.length() - 1);
                        break;
                    }
                    this.defaultValue = string2;
                    break;
                }
                default: {
                    this.defaultValue = string2;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.defaultValue = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public long getSize() {
        return this.size;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getGeneratedDefaultValue() {
        switch (this.type) {
            case 5: {
                return new Short(0);
            }
            case 4: {
                return new Integer(0);
            }
            case 6: {
                return new Float(0.0f);
            }
            case 93: {
                return new Timestamp(new Date().getTime());
            }
            case 91: {
                return new java.sql.Date(new Date().getTime());
            }
            case 92: {
                return new Time(new Date().getTime());
            }
            case 1: {
                return "_";
            }
            case 8: {
                return new Double(0.0);
            }
            case -1: 
            case 12: {
                return "";
            }
        }
        return null;
    }

    public String toString() {
        return "Field \"" + this.name + "\" [" + this.type + "] - " + " {" + (this.allowNull ? "Nullable" : "Not Nullable") + ", " + "}";
    }
}

