/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbColumn;
import com.ibm.dmh.db.DbIndex;
import com.ibm.dmh.db.DbTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTable {
    private String name = null;
    private char type;
    private boolean optional;
    protected String pkColumns = "";
    protected Map<String, DbColumn> columns = new TreeMap<String, DbColumn>();
    protected Map<String, DbIndex> indexes = new TreeMap<String, DbIndex>();
    protected Map<String, DbTrigger> triggers = new TreeMap<String, DbTrigger>();
    protected List<DbColumn> columnsList = new ArrayList<DbColumn>();
    protected String[] columnNames = null;

    public DbTable(String string, char c, boolean bl) {
        this.name = string;
        this.type = c;
        this.optional = bl;
    }

    public String getName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    void addColumn(DbColumn dbColumn) {
        this.columns.put(dbColumn.getName(), dbColumn);
        this.columnsList.add(dbColumn);
    }

    void addIndex(DbIndex dbIndex) {
        this.indexes.put(dbIndex.getName(), dbIndex);
    }

    void addTrigger(DbTrigger dbTrigger) {
        this.triggers.put(dbTrigger.getName(), dbTrigger);
    }

    public DbColumn getColumn(String string) {
        return this.columns.get(string);
    }

    public DbColumn getColumn(int n) {
        return this.columnsList.get(n - 1);
    }

    public DbIndex getIndex(String string) {
        return this.indexes.get(string);
    }

    public DbTrigger getTrigger(String string) {
        return this.triggers.get(string);
    }

    public String getPkColumns() {
        return this.pkColumns;
    }

    public int getNumColumns() {
        return this.columnsList.size();
    }

    public List<DbColumn> getColumns() {
        return this.columnsList;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new String[this.columnsList.size()];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = this.columnsList.get(i).getName();
            }
        }
        return this.columnNames;
    }

    public String toString() {
        return this.name + "[" + this.columnsList.size() + "]";
    }
}

