/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.dmh.util.StringUtils;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;

public class Sql
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        taskBody = taskBody.replaceAll("\n\\s*\n", "\n");
        taskBody = taskBody.replaceAll("([^\\\\];)", "$1\n");
        taskBody = Pattern.compile("[\\s]*$", 8).matcher(taskBody).replaceAll("");
        return taskBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        String[] commands = Sql.breakUpCommands(taskBody);
        boolean doAutoCommit = attrs.getNamedItem("autocommit").getNodeValue().equals("true");
        Object st = null;
        try {
            for (int i = 0; i < commands.length; ++i) {
                String sql = commands[i].trim();
                if (sql.trim().equals("")) continue;
                sql = sql.replaceAll("\n        ", "\n");
                sql = sql.replaceAll("\n\t\t", "\n");
                Main.executeSql(sql, true, true, false);
                if (!doAutoCommit) continue;
                Main.executeSql("COMMIT", true, true, false);
            }
            if (!doAutoCommit) {
                Main.executeSql("COMMIT", true, true, false);
            }
        }
        catch (Exception e) {
            int n;
            try {
                Main.logException(e);
                n = 2;
            }
            catch (Throwable throwable) {
                DbAdmin.close((Object[])new Object[]{st});
                throw throwable;
            }
            DbAdmin.close((Object[])new Object[]{st});
            return n;
        }
        DbAdmin.close((Object[])new Object[]{st});
        return 0;
    }

    private static String[] breakUpCommands(String commands) {
        commands = commands + "\n";
        commands = commands.replaceAll("\n\\s*--[^\n]*", "\n");
        return StringUtils.split((String)commands, (char)';', (boolean)true);
    }
}

