/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.msg;

import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.msg.WsaaException;
import com.ibm.dmh.msg.WsaaHardCodedMessages;
import com.ibm.dmh.msg.WsaaMessage;
import com.ibm.dmh.msg.WsaaMessageGeneric;
import com.ibm.dmh.msg.WsaaRuntimeException;
import com.ibm.dmh.util.FileContents;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgMgrTable {
    private static Map<Integer, WsaaMessageGeneric> messages = new HashMap<Integer, WsaaMessageGeneric>();
    private static boolean isInitialized = false;
    protected static Logger logger = LoggerManager.getMainLogger();
    protected static boolean debug = logger.isLoggable(Level.FINE);

    public static synchronized void loadMessages(String string) throws WsaaException {
        try {
            MsgMgrTable.parseXML(string, messages);
        }
        catch (Throwable throwable) {
            WsaaMessage wsaaMessage = new WsaaMessage(WsaaHardCodedMessages.getInstance().getBadLoadMessage(), new String[]{"xmlfile"}, new String[]{MsgMgrTable.class.getPackage().getName() + "." + MsgMgrTable.getXmlMessageFileName()});
            throw new WsaaException(wsaaMessage, throwable);
        }
    }

    public static synchronized void init() throws WsaaException {
        if (!isInitialized) {
            String[] stringArray = MsgMgrTable.getAllXmlFileNames();
            for (int i = stringArray.length - 1; i >= 0; --i) {
                MsgMgrTable.loadMessages(MsgMgrTable.getXmlMessageFileContents(stringArray[i]));
            }
            isInitialized = true;
        }
    }

    private static String getXmlMessageFileContents(String string) throws WsaaException {
        FileContents fileContents = new FileContents();
        try {
            InputStream inputStream = MsgMgrTable.class.getResourceAsStream(string);
            fileContents.readFile(inputStream, "UTF-8");
        }
        catch (IOException iOException) {
            WsaaMessage wsaaMessage = new WsaaMessage(WsaaHardCodedMessages.getInstance().getBadLoadMessage(), new String[]{"xmlfile"}, new String[]{MsgMgrTable.class.getPackage().getName() + "." + string});
            throw new WsaaException(wsaaMessage, (Throwable)iOException);
        }
        return fileContents.getContents().replaceAll("[\r\n\t]", "");
    }

    public static String getXmlMessageFileName() {
        String string = Locale.getDefault().toString();
        while (!string.equals("")) {
            if (MsgMgrTable.class.getResource("messages_" + string + ".xml") != null) {
                return "messages_" + string + ".xml";
            }
            if (string.lastIndexOf("_") != -1) {
                string = string.substring(0, string.lastIndexOf("_"));
                continue;
            }
            string = "";
        }
        return "messages.xml";
    }

    static String[] getAllXmlFileNames() throws WsaaException {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = Locale.getDefault().toString();
        while (!string.equals("")) {
            if (MsgMgrTable.class.getResource("messages_" + string + ".xml") != null) {
                linkedList.add("messages_" + string + ".xml");
            }
            if (string.lastIndexOf("_") != -1) {
                string = string.substring(0, string.lastIndexOf("_"));
                continue;
            }
            string = "";
        }
        if (MsgMgrTable.class.getResource("messages.xml") != null) {
            linkedList.add("messages.xml");
        }
        if (linkedList.size() == 0) {
            WsaaMessage wsaaMessage = new WsaaMessage(WsaaHardCodedMessages.getInstance().getBadLoadMessage(), new String[]{"xmlfile"}, new String[]{MsgMgrTable.class.getPackage().getName() + "." + "messages" + ".xml"});
            throw new WsaaException(wsaaMessage);
        }
        return linkedList.toArray(new String[0]);
    }

    public static WsaaMessageGeneric getMessage(Integer n) {
        if (!isInitialized) {
            try {
                MsgMgrTable.init();
            }
            catch (WsaaException wsaaException) {
                logger.log(Level.WARNING, wsaaException.getLocalizedMessage(), wsaaException);
            }
        }
        if (!messages.containsKey(n)) {
            return WsaaHardCodedMessages.getInstance().getUnknownMessage(n.toString());
        }
        return messages.get(n);
    }

    public static boolean messageExists(Integer n) {
        return messages.containsKey(n);
    }

    public static void main(String[] stringArray) {
        System.out.println(new File(MsgMgrTable.class.getResource("messages.xml").getFile()));
        System.out.println(Locale.getDefault());
    }

    static void parseXML(String string, Map<Integer, WsaaMessageGeneric> map) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Element element = documentBuilder.parse(new InputSource(new StringReader(string))).getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals("msg")) continue;
                Node node = nodeList.item(i);
                WsaaMessageGeneric wsaaMessageGeneric = MsgMgrTable.parseMsg(node);
                map.put(new Integer(wsaaMessageGeneric.getMessageNumber()), wsaaMessageGeneric);
            }
        }
        catch (Throwable throwable) {
            throw new WsaaRuntimeException(throwable);
        }
    }

    static WsaaMessageGeneric parseMsg(Node node) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            String string7 = MsgMgrTable.getChildText(node2).trim();
            if (node2.getNodeName().equals("msgtext")) {
                string2 = string7;
                continue;
            }
            if (node2.getNodeName().equals("msgnum")) {
                string = string7;
                continue;
            }
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem("class");
            String string8 = node3.getNodeValue();
            if (string8.equals("module")) {
                string3 = string7;
                continue;
            }
            if (string8.equals("xpl")) {
                string4 = string7;
                continue;
            }
            if (string8.equals("sysact")) {
                string5 = string7;
                continue;
            }
            string6 = string7;
        }
        return new WsaaMessageGeneric(string, string2, string3, string4, string5, string6);
    }

    static String getChildText(Node node) {
        String string = "";
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            string = string + MsgMgrTable.getChildTextHelper(nodeList.item(i));
        }
        return string;
    }

    private static String getChildTextHelper(Node node) {
        String string = "";
        switch (node.getNodeType()) {
            case 1: {
                string = string + "<" + node.getNodeName();
                string = string + MsgMgrTable.getAttributeText(node);
                if (!node.hasChildNodes()) {
                    string = string + "/>";
                    break;
                }
                string = string + ">";
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    string = string + MsgMgrTable.getChildTextHelper(nodeList.item(i));
                }
                string = string + "</" + node.getNodeName() + ">";
                break;
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(node.getNodeValue());
                block11: for (int i = 0; i < stringBuffer.length(); ++i) {
                    switch (stringBuffer.charAt(i)) {
                        case '<': {
                            stringBuffer.replace(i, i + 1, "&lt;");
                            continue block11;
                        }
                        case '>': {
                            stringBuffer.replace(i, i + 1, "&gt;");
                        }
                    }
                }
                string = string + stringBuffer.toString();
                break;
            }
            default: {
                WsaaMessage wsaaMessage = new WsaaMessage(WsaaHardCodedMessages.getInstance().getUnknownMessage("5354"), new String[]{"node type", "parent string"}, new String[]{String.valueOf(node.getNodeType()), node.toString()});
                try {
                    if (!debug) break;
                    logger.log(Level.FINE, wsaaMessage.toString());
                    break;
                }
                catch (Throwable throwable) {
                    System.err.println(wsaaMessage);
                }
            }
        }
        return string;
    }

    private static String getAttributeText(Node node) {
        String string = "";
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            string = string + " " + attr.getName() + "=\"" + attr.getValue() + "\"";
        }
        return string;
    }

    public static synchronized void reset() {
        isInitialized = false;
        messages = new HashMap<Integer, WsaaMessageGeneric>();
    }

    public static Map<Integer, WsaaMessageGeneric> getAllMessages() {
        return messages;
    }

    static void setMessages(Map<Integer, WsaaMessageGeneric> map) {
        messages = map;
    }

    public static String getMsgListSchemaUrl() {
        return MsgMgrTable.class.getResource("msglist.xsd").toString();
    }
}

