/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.msg.MsgMgr;
import com.ibm.dmh.msg.WsaaException;
import com.ibm.dmh.qp.AbstractWork;
import com.ibm.dmh.qp.AsynchBeanWorkManager;
import com.ibm.dmh.qp.BackupWorkManager;
import com.ibm.dmh.qp.DupAction;
import com.ibm.dmh.qp.IWorkManager;
import com.ibm.dmh.qp.PersistRestartAction;
import com.ibm.dmh.qp.WorkException;
import com.ibm.dmh.qp.WorkFlag;
import com.ibm.dmh.qp.WorkListener;
import com.ibm.dmh.qp.WorkRules;
import com.ibm.dmh.qp.WorkStatus;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkProcessor {
    private static boolean useAsynchBeansIfPresent;
    private static String shutdownPersistFile;
    protected static Logger logger;
    public static Map<String, IWorkManager> workManagers;
    private static Map<String, WorkRules> workRulesMap;
    private static SortedMap<Integer, AbstractWork> workMap;
    private static int cleanUpAfterNCalls;
    private static boolean shutdownCalled;
    private static int nextWorkUID;

    public static synchronized void init(boolean bl, String string, Logger logger) {
        try {
            Class.forName("com.ibm.jjson.JsonMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        useAsynchBeansIfPresent = bl;
        shutdownPersistFile = string;
        if (logger == null) {
            try {
                logger = Logger.getLogger("WorkProcessor");
                FileHandler fileHandler = new FileHandler("WorkProcessor%g.log", 500000, 3);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (Exception exception) {
                logger = Logger.global;
            }
        }
        WorkProcessor.logger = logger;
        logger.info("WorkProcessor.initialize() called.");
    }

    public static synchronized void awaitTermination() {
        for (IWorkManager iWorkManager : workManagers.values()) {
            iWorkManager.awaitTermination();
        }
    }

    public static void addWorkManager(String string, String string2, int n, int n2, int n3) {
        if (workManagers.containsKey(string)) {
            return;
        }
        if (useAsynchBeansIfPresent && string2 != null) {
            try {
                Class.forName("com.ibm.websphere.asynchbeans.WorkManager");
                workManagers.put(string, new AsynchBeanWorkManager(string2));
                logger.fine("Created asynch bean threadpool manager for work manager '" + string + "'");
            }
            catch (Throwable throwable) {
                logger.info("WARNING:  AsynchBean work manager lookup failed for wm=[" + string + "].  Backup work manager will be used.");
            }
        }
        if (!workManagers.containsKey(string)) {
            logger.fine("Creating backup threadpool manager for work manager '" + string + "'");
            workManagers.put(string, new BackupWorkManager(n, n2, n3));
        }
    }

    public static void clearWorkRules() {
        workRulesMap.clear();
    }

    public static void addWorkRules(String string, WorkRules workRules) {
        workRulesMap.put(string, workRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup() {
        logger.fine("Loading any persisted work items from a previous shutdown.");
        int n = 0;
        File file = new File(shutdownPersistFile);
        ObjectInputStream objectInputStream = null;
        if (file.exists()) {
            try {
                AbstractWork abstractWork;
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                nextWorkUID = (Integer)objectInputStream.readObject();
                while ((abstractWork = (AbstractWork)objectInputStream.readObject()) != null) {
                    abstractWork.workRules = workRulesMap.get(abstractWork.workName);
                    if (abstractWork.status == WorkStatus.STARTED) {
                        abstractWork.status = abstractWork.workRules.persistRestartAction == PersistRestartAction.REQUEUE ? WorkStatus.ACCEPTED : WorkStatus.INDETERMINATE;
                    }
                    nextWorkUID = Math.max(nextWorkUID, abstractWork.workId + 1);
                    ++n;
                    WorkProcessor.addWork(abstractWork);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error occurred while trying to reload persisted work objects in [" + shutdownPersistFile + "]", exception);
            }
            finally {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
            file.delete();
        }
        logger.info("Read [" + n + "] work entries from [" + shutdownPersistFile + "].");
    }

    public static int addWork(String string, AbstractWork abstractWork, String string2, String string3) throws WsaaException {
        return WorkProcessor.addWork(string, abstractWork, string2, string3, null);
    }

    public static int addWork(String string, AbstractWork abstractWork, String string2, String string3, WorkListener workListener) throws WsaaException {
        WorkRules workRules = workRulesMap.get(string);
        if (workRules == null) {
            throw new WsaaException(MsgMgr.dmh7901e(string));
        }
        return WorkProcessor.addWork(string, abstractWork, string2, string3, workRules, workListener);
    }

    private static int addWork(String string, AbstractWork abstractWork, String string2, String string3, WorkRules workRules, WorkListener workListener) {
        abstractWork.setWorkManagerFields(string, string2, string3, workRules, WorkStatus.UNKNOWN, false, workListener);
        return WorkProcessor.addWork(abstractWork);
    }

    public static AbstractWork peekWorkItem(int n) {
        return (AbstractWork)workMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AbstractWork> peekWorkItems(String ... stringArray) {
        WorkProcessor.cleanUpMaps();
        SortedMap<Integer, AbstractWork> sortedMap = workMap;
        synchronized (sortedMap) {
            if (stringArray.length == 0) {
                return workMap.values();
            }
            LinkedList<AbstractWork> linkedList = new LinkedList<AbstractWork>();
            for (AbstractWork abstractWork : workMap.values()) {
                for (String string : stringArray) {
                    if (!abstractWork.workRules.workManager.equals(string)) continue;
                    linkedList.add(abstractWork);
                }
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AbstractWork> peekWorkItemsByName(String ... stringArray) {
        WorkProcessor.cleanUpMaps();
        SortedMap<Integer, AbstractWork> sortedMap = workMap;
        synchronized (sortedMap) {
            LinkedList<AbstractWork> linkedList = new LinkedList<AbstractWork>();
            for (AbstractWork abstractWork : workMap.values()) {
                for (String string : stringArray) {
                    if (!abstractWork.workName.equals(string)) continue;
                    linkedList.add(abstractWork);
                }
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() throws Exception {
        File file;
        if (shutdownCalled) {
            return;
        }
        shutdownCalled = true;
        if (shutdownPersistFile == null) {
            return;
        }
        File file2 = new File(shutdownPersistFile);
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = file2.getParentFile()) != null && !file.exists()) {
            file.mkdirs();
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        objectOutputStream.writeObject(nextWorkUID);
        int n = 0;
        Object object = workMap;
        synchronized (object) {
            for (AbstractWork abstractWork : workMap.values()) {
                WorkRules workRules = abstractWork.workRules;
                if (!workRules.persistOnShutdown || !abstractWork.isInState(workRules.persistIfStateIn)) continue;
                AbstractWork abstractWork2 = (AbstractWork)abstractWork.clone();
                if (workRules.cancelOnShutdown && abstractWork.status == WorkStatus.STARTED) {
                    abstractWork.cancelFlag.set(true);
                }
                try {
                    objectOutputStream.writeObject(abstractWork2);
                    ++n;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Could not persist work object [" + abstractWork.workName + "]", exception);
                }
            }
        }
        try {
            objectOutputStream.close();
            logger.info("Wrote [" + n + "] work entries to [" + shutdownPersistFile + "].");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Could not persist work object list.", exception);
        }
        finally {
            objectOutputStream.close();
        }
        logger.info("Shutting down work managers.");
        object = workManagers.values().iterator();
        while (object.hasNext()) {
            ((IWorkManager)object.next()).shutdown();
        }
        workManagers.clear();
    }

    public static boolean cancelWorkItem(int n) {
        AbstractWork abstractWork = WorkProcessor.peekWorkItem(n);
        if (abstractWork == null) {
            return false;
        }
        WorkRules workRules = abstractWork.workRules;
        if (abstractWork.isInState(WorkStatus.ACCEPTED, WorkStatus.STARTED) && !abstractWork.cancelFlag.isSet()) {
            abstractWork.cancelFlag.set(true);
            workManagers.get(workRules.workManager).remove(abstractWork);
            if (workRules.deleteIfCancelled) {
                WorkProcessor.deleteWorkItem(n);
            }
            return true;
        }
        return false;
    }

    public static boolean deleteWorkItem(int n) {
        logger.fine("Deleting work from queue: [" + n + "].");
        AbstractWork abstractWork = WorkProcessor.popWorkItem(n);
        if (abstractWork == null) {
            return false;
        }
        abstractWork.delete();
        return true;
    }

    public static AbstractWork popWorkItem(int n) {
        AbstractWork abstractWork = (AbstractWork)workMap.get(n);
        if (abstractWork == null || abstractWork.isInState(WorkStatus.ACCEPTED, WorkStatus.STARTED)) {
            return null;
        }
        return (AbstractWork)workMap.remove(n);
    }

    public static void setFlag(int n, String string) {
        WorkFlag workFlag;
        AbstractWork abstractWork = (AbstractWork)workMap.get(n);
        if (abstractWork != null && (workFlag = abstractWork.getFlag(string)) != null) {
            workFlag.set(true);
        }
    }

    private static int addWork(AbstractWork abstractWork) {
        if (abstractWork.workId != 0) {
            if (abstractWork.status.isInState(WorkStatus.ACCEPTED, WorkStatus.STARTED)) {
                logger.info("The same work item is already on the queue and in the accepted or started state.  It cannot be requeued at this time.  Name=[" + abstractWork.workName + "], ID=[" + abstractWork.workId + "]");
                return abstractWork.workId;
            }
        } else {
            abstractWork.workId = WorkProcessor.getWorkUID();
        }
        logger.info("Adding work to queue:  id=[" + abstractWork.workId + "], name=[" + abstractWork.workName + "], submitUser=[" + abstractWork.submitUser + "].");
        WorkRules workRules = abstractWork.workRules;
        IWorkManager iWorkManager = workManagers.get(workRules.workManager);
        if (iWorkManager == null) {
            logger.warning("WorkManager for queue [" + workRules.workManager + "] not found.  Work item will be rejected.");
            abstractWork.addException(new WorkException("WorkManager for queue [" + workRules.workManager + "] not found."));
            abstractWork.changeStatus(WorkStatus.REJECTED);
            return abstractWork.workId;
        }
        if (abstractWork.workId % cleanUpAfterNCalls == 0) {
            WorkProcessor.cleanUpMaps();
        }
        boolean bl = true;
        if (abstractWork.workName != null && (workRules.dupAction == DupAction.REJECT || workRules.dupAction == DupAction.REQUEUE)) {
            for (AbstractWork abstractWork2 : workMap.values()) {
                if (!abstractWork2.workName.equals(abstractWork.workName) || !abstractWork2.isInState(WorkStatus.ACCEPTED, WorkStatus.STARTED) || abstractWork2.cancelFlag.isSet()) continue;
                if (workRules.dupAction == DupAction.REJECT) {
                    bl = WorkStatus.REJECTED.isInState(workRules.deleteIfStateIn);
                    abstractWork.changeStatus(WorkStatus.REJECTED);
                    logger.info("Work object with same name is already on the queue and in the accepted state, and dupFlag was set to [DUP_REJECT].  Name=[" + abstractWork2.workName + "], ID=[" + abstractWork2.workId + "]");
                    abstractWork.addMessage("Work object with same name is already on the queue and in the accepted state, and dupFlag was set to [DUP_REJECT].  Name=[" + abstractWork2.workName + "], ID=[" + abstractWork2.workId + "]");
                    continue;
                }
                if (workRules.dupAction != DupAction.REQUEUE) continue;
                abstractWork2.cancelFlag.set(true);
                logger.info("Work object with same name was readded to queue with dupFlag set to [DUP_REQUEUE].  Name=[" + abstractWork2.workName + "], Old ID=[" + abstractWork2.workId + "], New ID=[" + abstractWork.workId + "]");
                abstractWork2.addMessage("Work object with same name was readded to queue with dupFlag set to [DUP_REQUEUE].  Name=[" + abstractWork2.workName + "], Old ID=[" + abstractWork2.workId + "], New ID=[" + abstractWork.workId + "]");
            }
        }
        if (bl) {
            workMap.put(abstractWork.workId, abstractWork);
            try {
                if (abstractWork.isInState(WorkStatus.UNKNOWN)) {
                    abstractWork.changeStatus(WorkStatus.ACCEPTED);
                }
                if (abstractWork.isInState(WorkStatus.ACCEPTED)) {
                    iWorkManager.startWork(abstractWork);
                }
            }
            catch (WorkException workException) {
                logger.warning("Exception caught trying to add work item to queue:  " + workException + ".  Status changed to REJECTED.");
                abstractWork.changeStatus(WorkStatus.REJECTED);
                abstractWork.addException(workException);
            }
        }
        return abstractWork.workId;
    }

    private static synchronized int getWorkUID() {
        return nextWorkUID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpMaps() {
        long l = new Date().getTime();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        SortedMap<Integer, AbstractWork> sortedMap = workMap;
        synchronized (sortedMap) {
            for (AbstractWork abstractWork : workMap.values()) {
                Date date = abstractWork.deleteAfter();
                if (date == null || date.getTime() >= l) continue;
                linkedList.add(abstractWork.workId);
            }
        }
        workMap.keySet().removeAll(linkedList);
    }

    static {
        workManagers = new HashMap<String, IWorkManager>();
        workRulesMap = new HashMap<String, WorkRules>();
        workMap = Collections.synchronizedSortedMap(new TreeMap());
        cleanUpAfterNCalls = 100;
        shutdownCalled = false;
        nextWorkUID = 1;
    }
}

