/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.msg.MsgMgr;
import com.ibm.dmh.msg.WsaaException;
import com.ibm.dmh.util.StringUtils;
import com.ibm.dmh.util.XPath;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathAPI {
    public static HashMap<String, XPath> preCompiledXPaths = new HashMap();

    public static NodeList selectNodeList(Element element, String string) throws TransformerException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        XPath xPath = preCompiledXPaths.get(string);
        if (xPath == null) {
            xPath = new XPath(string);
            preCompiledXPaths.put(string, xPath);
        }
        for (int i = 0; i < xPath.singlePaths.length; ++i) {
            XPath.SinglePath singlePath = xPath.singlePaths[i];
            LinkedList<Object> linkedList2 = new LinkedList();
            LinkedList<Node> linkedList3 = new LinkedList<Node>();
            LinkedList<Node> linkedList4 = null;
            if (singlePath.spType == XPath.SinglePath.ABSOLUTE) {
                linkedList3.add(element);
            } else if (singlePath.spType == XPath.SinglePath.RELATIVE) {
                if (singlePath.tokens[0].type == 2) {
                    XPathAPI.addToList(linkedList, element.getAttributeNode(singlePath.tokens[0].name));
                } else {
                    XPathAPI.addToList(linkedList3, element.getChildNodes());
                }
            } else if (singlePath.spType == XPath.SinglePath.ALL) {
                linkedList3.add(element);
                XPathAPI.addToList(linkedList3, element.getElementsByTagName(singlePath.tokens[0].name));
            }
            for (int j = 0; j < singlePath.tokens.length; ++j) {
                XPath.Token token = singlePath.tokens[j];
                for (Node node : linkedList3) {
                    boolean bl;
                    short s = node.getNodeType();
                    if (token.type != s) continue;
                    if (token.type == 3) {
                        linkedList.add(node);
                        continue;
                    }
                    if (token.type != 1) continue;
                    Element element2 = (Element)node;
                    boolean bl2 = token.name == null || element2.getNodeName().equals(token.name);
                    boolean bl3 = bl = token.attrMatchName == null || element2.getAttribute(token.attrMatchName).equals(token.attrMatchVal);
                    if (!bl2 || !bl) continue;
                    if (j + 1 == singlePath.tokens.length) {
                        linkedList.add(element2);
                        continue;
                    }
                    if (singlePath.tokens[j + 1].type == 2) {
                        XPathAPI.addToList(linkedList, element2.getAttributeNode(singlePath.tokens[j + 1].name));
                        continue;
                    }
                    XPathAPI.addToList(linkedList2, node.getChildNodes());
                }
                linkedList4 = linkedList3;
                linkedList3 = linkedList2;
                linkedList2 = linkedList4;
                linkedList2.clear();
            }
        }
        return new NodeListImpl(linkedList);
    }

    private static void addToList(List<Node> list, NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            list.add(nodeList.item(i));
        }
    }

    private static void addToList(List<Node> list, Node node) {
        if (node != null) {
            list.add(node);
        }
    }

    public static Node selectSingleNode(Element element, String string) throws TransformerException {
        NodeList nodeList = XPathAPI.selectNodeList(element, string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static String printNode(Node node) {
        if (node.getNodeType() == 1) {
            StringBuffer stringBuffer = new StringBuffer("<" + node.getNodeName());
            NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                stringBuffer.append(" " + namedNodeMap.item(i).getNodeName() + "='" + namedNodeMap.item(i).getNodeValue() + "'");
            }
            return stringBuffer.append("/>").toString();
        }
        if (node.getNodeType() == 2) {
            return "@" + node.getNodeName() + "=" + node.getNodeValue();
        }
        if (node.getNodeType() == 3) {
            return "'" + node.getNodeValue() + "'";
        }
        return null;
    }

    public static String printNodeList(NodeList nodeList) {
        Object[] objectArray = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            objectArray[i] = XPathAPI.printNode(nodeList.item(i));
        }
        Arrays.sort(objectArray);
        return StringUtils.join(objectArray, ",");
    }

    public static Element[] getChildren(Element element, String string) throws WsaaException {
        try {
            NodeList nodeList = XPathAPI.selectNodeList(element, string);
            int n = nodeList.getLength();
            Element[] elementArray = new Element[n];
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType()) {
                    throw new WsaaException(MsgMgr.dmh7560e(string), null);
                }
                elementArray[i] = (Element)node;
            }
            return elementArray;
        }
        catch (TransformerException transformerException) {
            throw new WsaaException(MsgMgr.dmh7561e(string), (Throwable)transformerException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeListImpl
    implements NodeList {
        private final Node[] list;

        NodeListImpl(List<Node> list) {
            this.list = list.toArray(new Node[list.size()]);
        }

        @Override
        public int getLength() {
            return this.list.length;
        }

        @Override
        public Node item(int n) {
            return this.list[n];
        }
    }
}

