/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbInfo {
    public int version;
    public String os;
    public boolean isDistEnabled;
    public static int SUPPORT_GET_GENERATED_KEYS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbInfo(Connection c, String tableSchema) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        DbMetaData dmd = new DbMetaData(c, tableSchema, "n/a");
        this.isDistEnabled = dmd.getTable("DMH_BYTECODE_CLASS") != null || dmd.getTable("BYTECODE") != null;
        rs = c.getMetaData().getTables(null, "SYSIBM", "SYSDATABASE", null);
        this.os = rs.next() ? "zOS" : "UDB";
        rs.close();
        System.out.println("Database os detected as [" + this.os + "]");
        this.version = 0;
        try {
            st = c.createStatement();
            rs = st.executeQuery("select SYS_INT_ATTR from " + tableSchema + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=500");
            if (rs.next()) {
                this.version = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.err.println("Could not query " + tableSchema + ".DMH_SYSTEM_ATTR");
        }
        finally {
            DbAdmin.close(st, rs);
        }
        if (this.version != 0) {
            return;
        }
        this.version = dmd.getTable("DMH_SITE") == null ? 0 : (dmd.getTable("DMH_CHAR_PROPERTY") == null && dmd.getTable("DMH_DB2_PROC") == null && dmd.getTable("DMH_SQL_PROC") == null ? 220 : (dmd.getIndex("DMH_COMPILE_UNIT", "RDICOU3") == null && dmd.getTrigger("DMH_DATA_ELMT_ALAS", "DMHTRDE1") == null && dmd.getTrigger("DMH_DB2_COLUMN", "DMHTRCO1") == null && dmd.getTrigger("DMH_ENTRY_POINT", "DMHTREP1") == null ? 310 : (this.isDistEnabled && dmd.getTable("DMH_CL_DPL_EAR") == null && dmd.getTable("DMH_CL_DPL_EJB_M") == null && dmd.getTable("DMH_CL_DPL_WEB_M") == null && dmd.getTable("DMH_CL_W4AAPPSVR") == null && dmd.getColumn("DMH_DPL_EAR", "FILE_LOCATION") != null && dmd.getColumn("DMH_DPL_EAR", "NODE") != null ? 311 : (dmd.getTable("DMH_BOOKMARK") == null && dmd.getColumn("DMH_CMPNT_TYPE", "NAME") == null && dmd.getColumn("DMH_CMPNT_TYPE", "MAIN_TABLE") == null && dmd.getTable("DMH_CQ_COLUMN") == null && dmd.getTable("DMH_CUSTOM_QUERY") == null && dmd.getTable("DMH_ELMT_CHAR_ATTR") != null && dmd.getTable("DMH_ELMT_NUM_ATTR") != null ? 312 : (dmd.getTable("DMH_BOOKMARK") != null && dmd.getColumn("DMH_CMPNT_TYPE", "NAME") != null && dmd.getColumn("DMH_CMPNT_TYPE", "MAIN_TABLE") != null && dmd.getTable("DMH_CQ_COLUMN") != null && dmd.getTable("DMH_CUSTOM_QUERY") != null && dmd.getTable("DMH_ELMT_CHAR_ATTR") == null && dmd.getTable("DMH_ELMT_NUM_ATTR") == null ? 410 : 0)))));
    }

    public static boolean checkSupportFor(Connection c, int support) throws SQLException {
        if (support == SUPPORT_GET_GENERATED_KEYS) {
            DatabaseMetaData dmd = c.getMetaData();
            try {
                dmd.getClass().getMethod("supportsGetGeneratedKeys", null);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return false;
            }
            return dmd.supportsGetGeneratedKeys();
        }
        return false;
    }
}

