/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import java.util.HashMap;
import java.util.Map;

public class SqlUtils {
    private static Map colNameToIntMap = new HashMap();
    private static Map colIntToNameMap = new HashMap();

    public static String getSqlTypeString(int sqlType) {
        String s = (String)colIntToNameMap.get(new Integer(sqlType));
        return s == null ? "UNKNOWN" : s;
    }

    public static int getSqlTypeInt(String sqlType) {
        Integer i;
        if (sqlType.indexOf(40) != -1) {
            sqlType = sqlType.substring(0, sqlType.indexOf(40));
        }
        return (i = (Integer)colNameToIntMap.get(sqlType)) == null ? 0 : i;
    }

    public static long getSqlSize(String sqlTypeAndSize) {
        int i1 = sqlTypeAndSize.indexOf(40);
        int i2 = sqlTypeAndSize.indexOf(41);
        if (i1 == -1) {
            return 0L;
        }
        return Long.parseLong(sqlTypeAndSize.substring(i1 + 1, i2));
    }

    public static String getSqlTypeAndSizeString(int type, long size) {
        return SqlUtils.getSqlTypeString(type) + (SqlUtils.sqlTypeHasSize(type) ? "(" + size + ")" : "");
    }

    public static boolean sqlTypeHasSize(int type) {
        return type == -2 || type == 2004 || type == 1 || type == 2005 || type == -4 || type == -1 || type == -3 || type == 12;
    }

    public static String getDefaultForColumnType(int colType) {
        switch (colType) {
            case -5: 
            case 4: 
            case 5: {
                return "0";
            }
            case 1: 
            case 12: 
            case 2005: {
                return "";
            }
            case 93: {
                return "CURRENT TIMESTAMP";
            }
            case 92: {
                return "CURRENT TIME";
            }
            case 91: {
                return "CURRENT DATE";
            }
        }
        return "UNKNOWN";
    }

    public static void main(String[] args) {
        System.err.println(SqlUtils.getSqlTypeInt("VARCHAR"));
    }

    static {
        colNameToIntMap.put("BIGINT", new Integer(-5));
        colNameToIntMap.put("BINARY", new Integer(-2));
        colNameToIntMap.put("CHAR", new Integer(1));
        colNameToIntMap.put("CLOB", new Integer(2005));
        colNameToIntMap.put("DATE", new Integer(91));
        colNameToIntMap.put("DECIMAL", new Integer(3));
        colNameToIntMap.put("DOUBLE", new Integer(8));
        colNameToIntMap.put("FLOAT", new Integer(6));
        colNameToIntMap.put("INTEGER", new Integer(4));
        colNameToIntMap.put("LONGVARBINARY", new Integer(-4));
        colNameToIntMap.put("LONGVARG", new Integer(-4));
        colNameToIntMap.put("LONGVARCHAR", new Integer(-1));
        colNameToIntMap.put("LONGVAR", new Integer(-1));
        colNameToIntMap.put("REAL", new Integer(7));
        colNameToIntMap.put("SMALLINT", new Integer(5));
        colNameToIntMap.put("TIME", new Integer(92));
        colNameToIntMap.put("TIMESTAMP", new Integer(93));
        colNameToIntMap.put("TIMESTMP", new Integer(93));
        colNameToIntMap.put("TINYINT", new Integer(-6));
        colNameToIntMap.put("VARBINARY", new Integer(-3));
        colNameToIntMap.put("VARCHAR", new Integer(12));
        colNameToIntMap.put("ROWID", new Integer(10001));
        colIntToNameMap.put(new Integer(-5), "BIGINT");
        colIntToNameMap.put(new Integer(-2), "BINARY");
        colIntToNameMap.put(new Integer(1), "CHAR");
        colIntToNameMap.put(new Integer(2005), "CLOB");
        colIntToNameMap.put(new Integer(91), "DATE");
        colIntToNameMap.put(new Integer(3), "DECIMAL");
        colIntToNameMap.put(new Integer(8), "DOUBLE");
        colIntToNameMap.put(new Integer(6), "FLOAT");
        colIntToNameMap.put(new Integer(4), "INTEGER");
        colIntToNameMap.put(new Integer(-4), "LONGVARBINARY");
        colIntToNameMap.put(new Integer(-1), "LONGVARCHAR");
        colIntToNameMap.put(new Integer(7), "REAL");
        colIntToNameMap.put(new Integer(5), "SMALLINT");
        colIntToNameMap.put(new Integer(92), "TIME");
        colIntToNameMap.put(new Integer(93), "TIMESTAMP");
        colIntToNameMap.put(new Integer(-6), "TINYINT");
        colIntToNameMap.put(new Integer(-3), "VARBINARY");
        colIntToNameMap.put(new Integer(12), "VARCHAR");
        colIntToNameMap.put(new Integer(10001), "ROWID");
    }
}

