/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonParseException;
import com.ibm.jjson.JsonUtils;
import com.ibm.jjson.XmlParser;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JsonSerializer {
    public static int FORMAT_CONDENSED = 1;
    public static int FORMAT_NORMAL = 2;
    public static int FORMAT_PRETTY = 3;
    public static int NOT_STRICT = 0;
    public static int STRICT = 1;

    public static String serialize(Object object, int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        if (object instanceof Collection) {
            JsonSerializer.serializeCollection((Collection)object, stringWriter, n == STRICT, n2, 0);
        } else if (object instanceof Map) {
            JsonSerializer.serializeMap((Map)object, stringWriter, n == STRICT, n2, 0);
        } else {
            if (object instanceof Number || object instanceof Boolean) {
                return object.toString();
            }
            if (object == null) {
                return "null";
            }
            return '\"' + JsonUtils.toJsonString(object.toString()) + '\"';
        }
        return stringWriter.toString();
    }

    public static String serializeFromXml(String string, int n, int n2) throws JsonParseException, ParserConfigurationException, SAXException, IOException {
        return JsonSerializer.serialize(XmlParser.parse(string), n, n2);
    }

    private static void serializeMap(Map map, StringWriter stringWriter, boolean bl, int n, int n2) {
        stringWriter.write(123);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (n == FORMAT_PRETTY) {
                JsonSerializer.indent(stringWriter, n2 + 1);
            }
            String string = (String)iterator.next();
            stringWriter.write(JsonSerializer.toJsonAttr(string, bl));
            stringWriter.write(58);
            Object v = map.get(string);
            if (v instanceof Collection) {
                JsonSerializer.serializeCollection((Collection)v, stringWriter, bl, n, n2 + 1);
            } else if (v instanceof Map) {
                JsonSerializer.serializeMap((Map)v, stringWriter, bl, n, n2 + 1);
            } else if (v == null) {
                stringWriter.write("null");
            } else if (v instanceof Number || v instanceof Boolean) {
                String string2 = v.toString();
                if (bl) {
                    stringWriter.write(34);
                }
                stringWriter.write(string2);
                if (bl) {
                    stringWriter.write(34);
                }
            } else {
                stringWriter.write(34);
                stringWriter.write(JsonUtils.toJsonString(v.toString()));
                stringWriter.write(34);
            }
            if (!iterator.hasNext()) continue;
            stringWriter.write(44);
            if (n == FORMAT_CONDENSED) continue;
            stringWriter.write(32);
        }
        if (n == FORMAT_PRETTY) {
            JsonSerializer.indent(stringWriter, n2);
        }
        stringWriter.write(125);
    }

    private static void serializeCollection(Collection collection, StringWriter stringWriter, boolean bl, int n, int n2) {
        stringWriter.write(91);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e;
            if (n == FORMAT_PRETTY) {
                JsonSerializer.indent(stringWriter, n2 + 1);
            }
            if ((e = iterator.next()) instanceof Collection) {
                JsonSerializer.serializeCollection((Collection)e, stringWriter, bl, n, n2 + 1);
            } else if (e instanceof Map) {
                JsonSerializer.serializeMap((Map)e, stringWriter, bl, n, n2 + 1);
            } else if (e == null) {
                stringWriter.write("null");
            } else if (e instanceof Number || e instanceof Boolean) {
                String string = e.toString();
                if (bl) {
                    stringWriter.write(34);
                }
                stringWriter.write(string);
                if (bl) {
                    stringWriter.write(34);
                }
            } else {
                stringWriter.write(34);
                stringWriter.write(JsonUtils.toJsonString(e.toString()));
                stringWriter.write(34);
            }
            if (!iterator.hasNext()) continue;
            stringWriter.write(44);
            if (n == FORMAT_CONDENSED) continue;
            stringWriter.write(32);
        }
        if (n == FORMAT_PRETTY) {
            JsonSerializer.indent(stringWriter, n2);
        }
        stringWriter.write(93);
    }

    static String toJsonAttr(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        boolean bl2 = bl;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n') {
                stringBuffer.append('\\').append('n');
            } else if (c == '\t') {
                stringBuffer.append('\\').append('t');
            } else if (c == '\'') {
                stringBuffer.append('\\').append('\'');
            } else if (c == '\"') {
                stringBuffer.append('\\').append('\"');
            } else if (c != '\r') {
                stringBuffer.append(c);
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            bl2 = true;
        }
        stringBuffer.append('\"');
        return bl2 ? stringBuffer.toString() : stringBuffer.substring(1, stringBuffer.length() - 1);
    }

    private static void indent(StringWriter stringWriter, int n) {
        stringWriter.write(10);
        for (int i = 0; i < n; ++i) {
            stringWriter.write(9);
        }
    }
}

