/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.FileContents;
import com.ibm.wsaa.util.LocaleMgr;
import com.ibm.wsaa.util.StringUtils;
import com.ibm.wsaa.util.vars.ConfigVar;
import com.ibm.wsaa.util.vars.ResourceBundleVar;
import com.ibm.wsaa.util.vars.VarResolver;
import com.ibm.wsaa.util.vars.VarTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XmlLoader {
    public Document doc;

    public XmlLoader(String string, String[] stringArray, String string2, VarResolver varResolver) throws Exception {
        this(string, stringArray, string2, varResolver, true);
    }

    public XmlLoader(String string, String[] stringArray, String string2, VarResolver varResolver, boolean bl) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n] + '/' + string;
            if (new File(string3).exists()) {
                this.init(string3, string2, varResolver, bl);
                return;
            }
            ++n;
        }
        throw new FileNotFoundException("XmlLoader could not find file [" + string + "] in search path [" + StringUtils.join(stringArray, ",") + "]");
    }

    public XmlLoader(String string, String string2, VarResolver varResolver) throws Exception {
        this.init(string, string2, varResolver, false);
    }

    private void init(String string, String string2, VarResolver varResolver, boolean bl) throws Exception {
        FileContents fileContents = new FileContents();
        fileContents.readFile(string, string2 == null ? LocaleMgr.getExternalDefaultEncoding() : string2);
        ResourceBundle resourceBundle = LocaleMgr.getResourceBundle(string, null);
        if (varResolver == null) {
            varResolver = new VarResolver();
        }
        if (resourceBundle != null) {
            varResolver.addVar("L", new ResourceBundleVar(resourceBundle), new VarTracker(bl, true));
        }
        varResolver.addVar("C", new ConfigVar(), new VarTracker(false, true));
        fileContents.insertVars(varResolver);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(fileContents.getContents()));
        inputSource.setSystemId(new File(".").toURL().toString());
        this.doc = documentBuilder.parse(inputSource);
    }

    public Element getRootElement() {
        return this.doc.getDocumentElement();
    }

    public Document getDocument() {
        return this.doc;
    }
}

