	TITLE	KEYMAP CONFIGURATION PROGRAM
	PAGE	,132
;	KEYCON - CONFIGURATION PROGRAM FOR KEYMAP
;
;	THIS PROGRAM CONFIGURES THE KEYMAP PROGRAM, ALLOWING THE
;	USER TO INSERT HIS/HER DESIRED OUTPUTS FOR EACH MAPPED KEY.
;
;	BY P. SWAYNE, HUG  27-JAN-84
;	COPYRIGHT (C) 1884 BY HEATH USERS' GROUP

;	DEFINITIONS

M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LST OUTPUT
DCIN	EQU	7			;DIRECT CONSOLE INPUT
TYPEF	EQU	9			;TYPE STRING
LINPUT	EQU	10			;LINE INPUT
OPENF	EQU	15			;OPEN FILE
CLOSEF	EQU	16			;CLOSE FILE
DELETF	EQU	19			;DELETE FILE
READF	EQU	20			;READ FILE (SEQUENTIAL)
WRITEF	EQU	21			;WRITE FILE (SEQ)
MAKEF	EQU	22			;MAKE FILE
SETDMA	EQU	26			;SET DMA ADDRESS

CONF	SEGMENT
	ASSUME	CS:CONF,DS:CONF,ES:CONF,SS:CONF
	ORG	100H

;	START BY GETTING NAME OF KEYMAP FILE TO WORK ON

CONFIG:	MOV	AX,CS
	MOV	DS,AX			;SET UP SEGMENT REGISTERS
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,Offset STACK		;SET STACK
	MOV	DX,(Offset CONMSG)	;PRINT CONFIG MESSAGE
	CLD				;CLEAR DIRECTION FLAG
	CALL	PMSG
	MOV	AH,15			;ALLOW 14 CHARACTERS
	CALL	RDCON			;READ FILE NAME
	JNZ	GOTNAM
	JMP	EXIT			;GUESS HE DON'T WANT TO DO IT

;	READ IN THE KEYMAP FILE

GOTNAM:	MOV	SI,DX			;POINT TO INPUT FILE NAME
	MOV	DI,Offset CFCB		;PUT IT HERE
	MOV	AH,29H
	MOV	AL,1000B		;USE DEFAULT EXTENSION
	INT	21H			;PARSE FILE NAME
	MOV	DX,(Offset CBUF)	;POINT TO CONFIG BUFFER
	MOV	AH,SETDMA
	INT	21H			;SET DMA THERE
	MOV	DX,(Offset CFCB)	;POINT TO KEYMAP FILE NAME
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN KEYMAP.COM
	INC	AL
	OR	AL,AL
	JNZ	OPENED			;OPENED OK
	MOV	DX,(Offset OPMSG)
	CALL	PMSG			;PRINT "CAN'T FIND KEYMAP"
	JMP	EXIT			;EXIT TO Z-DOS
OPENED:	MOV	DX,(Offset CFCB)
	MOV	BX,DX
	MOV	AX,16[BX]		;GET FILE SIZE
	MOV	14[BX],AX		;USE AS RECORD SIZE
	MOV	RECSIZ,AX		;ALSO, SAVE SIZE
	MOV	AH,READF
	INT	21H			;READ THE FILE
	OR	AL,AL			;TEST READ OPERATION
	JZ	GDREAD			;OK
	MOV	DX,Offset BADRD
	CALL	PMSG			;ELSE, SAY "BAD READ"
	JMP	EXIT			;AND EXIT

;	ASK FOR STATUS LINE MESSAGE

GDREAD:	MOV	DX,(Offset BLINEM)
	CALL	PMSG			;ASK FOR BOTTOM LINE
	MOV	AL,5
	CALL	RDCON			;GET REPLY
	JZ	NOSTLN			;NO STATUS LINE
	MOV	SI,DX
	MOV	AL,[SI]
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'			;YES?
	JZ	STATLN
NOSTLN:	MOV	BX,(Offset CBUF)+(Offset BLMSG)
	MOV	M,1AH			;CLEAR STATUS LINE MESSAGE
	JMP	NBLINE			;NO BOTTOM LINE

;	GET STATUS LINE MESSAGE

STATLN:	MOV	DX,(Offset PRMSG)
	CALL	PMSG			;PROMPT FOR ENTRIES
	MOV	BX,(Offset CBUF)+(Offset BLMSG)
	MOV	Word Ptr OUTPTR,BX	;SET UP OUTPUT POINTER
	MOV	DX,(Offset INTRO)	;GET INTRO STRING
	MOV	CH,9
	CALL	MOVE			;MOVE IT INTO OUTPUT BUFFER
	MOV	Word Ptr OUTPTR,BX	;UPDATE POINTER
	MOV	CL,0			;CLEAR A COUNTER
GELP:	MOV	DX,(Offset ENMSG)
	CALL	PMSG			;PRINT "ENTER"
	MOV	AL,CL
	CMP	AL,10			;COUNT LESS THAN 10?
	JB	LT10			;YES
	MOV	DL,'1'
	MOV	AH,CONOUT
	INT	21H			;ELSE PRINT "1"
	MOV	AL,CL
	SUB	AL,10
LT10:	MOV	DL,AL
	ADD	DL,'0'			;ADD ASCII TO COUNT
	MOV	AH,CONOUT
	INT	21H			;PRINT COUNT
	MOV	DX,Offset ENMSG1
	CALL	PMSG			;PRINT COLON PROMPT
	MOV	AL,7
	CALL	RDCON			;GET REPLY
	PUSHF				;SAVE FLAGS FROM ENTRY
	MOV	BX,Word Ptr OUTPTR
	PUSH	DX			;SAVE ENTRY ADDRESS
	MOV	DX,(Offset ISTR)
	MOV	CH,2
	CALL	MOVE			;INSERT REVERSE VIDEO
	MOV	AL,CL			;GET THE COUNT
	CMP	AL,10			;UNDER 10?
	JB	LT10A			;YES
	MOV	M,'1'			;ELSE, INSERT A "1"
	INC	BX
	SUB	AL,10
LT10A:	ADD	AL,'0'			;ADD ASCII TO COUNT
	MOV	M,AL			;PUT IT IN
	INC	BX
	MOV	DX,Offset ISTR1
	MOV	CH,2
	CALL	MOVE			;MOVE IN NORMAL VIDEO
	POP	DX			;GET ENTRY ADDRESS
	POPF				;GET FLAGS FROM ENTRY
	JNZ	NOTNUL			;NOT NUL ENTRY
	ADD	BX,6			;ELSE, SKIP ENTRY
	JMP	SHORT SKIP
NOTNUL:	MOV	CH,6
	CALL	MOVE			;MOVE ENTRY INTO BUFFER
SKIP:	MOV	Word Ptr OUTPTR,BX
	INC	CL
	CMP	CL,13			;DONE?
	JNZ	GELP			;IF NOT, LOOP
	MOV	DX,(Offset OUTRO)
	MOV	CH,3
	CALL	MOVE			;MOVE IN CLOSING STUFF
	MOV	BX,(Offset CBUF)+(Offset BLMSG)
PMSGS:	MOV	DL,M			;GET CHARACTER
	INC	BX			;INCREMENT POINTER
	CMP	DL,1AH			;END OF MESSAGE?
	JZ	MSGEND
	MOV	AH,CONOUT
	INT	21H			;ELSE, PRINT CHARACTER
	JMP	SHORT PMSGS
MSGEND:	MOV	DX,(Offset OKM)
	CALL	PMSG			;ASK FOR OK
	MOV	AL,5
	CALL	RDCON			;GET REPLY
	JZ	OK			;IT'S OK
	PUSH	DX
	MOV	DX,(Offset ERAM)
	CALL	PMSG			;ERASE BOTTOM LINE
	POP	DX
	MOV	SI,DX
	MOV	AL,[SI]
	AND	AL,5FH
	CMP	AL,'N'			;NO?
	JNZ	OK	
	JMP	STATLN			;NOT OK
OK:	MOV	DX,Offset ERAM
	CALL	PMSG			;ERASE BOTTOM LINE MESSAGE

;	ASK FOR ALTERNATE SELECT KEY

NBLINE:	CALL	CRLF
GETFSK:	MOV	DX,(Offset ASKEYM)
	CALL	PMSG			;PRINT "ENTER FS KEY"
	MOV	AH,DCIN
	INT	21H			;GET 1ST CHARACTER
	CMP	AL,13			;CR?
	MOV	DL,0			;ASSUME IT IS
	JZ	NGOTFSK			;IT IS, NO ALTERNATE KEY
	CMP	AL,27			;FIRST CHARACTER ESCAPE?
	JNZ	GETFSK			;IF NOT, START OVER
	MOV	DX,Offset ESCMSG	;ELSE, PRINT "ESC"
	CALL	PMSG
	MOV	AH,DCIN
	INT	21H			;GET NEXT CHARACTER
	CMP	AL,'~'			;HELP KEY?
	JZ	GETFSK			;IF SO, DON'T USE
	MOV	DL,AL			;SAVE IT
	MOV	AH,CONOUT
	INT	21H			;PRINT IT
	MOV	AH,DCIN
	INT	21H			;GET 3RD CHARACTER
	CMP	AL,13			;CR?
	JNZ	GETFSK			;IF NOT, START OVER
NGOTFSK:MOV	Byte Ptr ASKEY+CBUF,DL	;SAVE KEY ENTERED
	OR	DL,DL			;TEST KEY
	JZ	NGOTFS1			;SKIP MARKING OF KEY
	MOV	BX,(Offset MAPTBL)+(Offset CBUF)	;POINT TO MAP TABLE
	SUB	DL,'@'			;REMOVE ASCII FROM FUNC. KEY
	ADD	DL,DL			;DOUBLE IT
	MOV	DH,0
	ADD	BX,DX			;BX POINTS TO TABLE ENTRY
	MOV	BX,[BX]			;BX = MAPPED STRING
	MOV	DX,(Offset CBUF)-256
	ADD	BX,DX			;CORRECT FOR LOADED PROGRAM
	OR	M,80H			;SET 8TH BIT (MARK FS KEY)

;	NOW, ENTER THE KEY RESPONSES THEMSELVES

NGOTFS1:MOV	DX,(Offset KEYM)
	CALL	PMSG			;PRINT "ENTER KEYS"
	MOV	BX,(Offset KEYS)
	MOV	Word Ptr KEYMPTR,BX	;SET KEY MESSAGE POINTER
	MOV	BX,(Offset F0)+(Offset CBUF)
	MOV	Word Ptr RESPTR,BX	;SET RESPONSE POINTER
	MOV	Byte Ptr COUNT,36	;SET COUNTER TO 36 KEYS
GETKLP:	CALL	CRLF			;PRINT CRLF
	MOV	BX,Word Ptr KEYMPTR	;GET KEY MESSAGE POINTER
	CALL	PMSG1			;PRINT PROMPT
	MOV	Word Ptr KEYMPTR,BX	;UPDATE POINTER
	CALL	OPPAR			;PRINT OPEN PARENTHESES
	MOV	BX,Word Ptr RESPTR	;GET RESPONSE POINTER
	MOV	AL,M			;GET FIRST CHARACTER
	ADD	AL,AL			;SHIFT LEFT
	JNB	GETKLPA			;NOT ALTERNATE RESP. KEY
	ROR	AL,1			;FIX CHARACTER
	MOV	M,AL			;REPLACE IT
	MOV	DX,(Offset ALRESM)
	CALL	PMSG			;SAY "ALTERNATE KEY"
	JMP	SHORT GETKLPB
GETKLPA:CALL	PMSG1			;PRINT CURRENT KEY RESPONSE
GETKLPB:CALL	CLPAR			;PRINT CLOSING PARENTHESES
	MOV	AL,21			;ALLOW 20 CHARACTERS
	CALL	RDCON			;INPUT RESPONSE
	JZ	NOCHG			;NO CHANGE
	MOV	BX,Word Ptr RESPTR	;PUT RESPONSE HERE
	MOV	CH,21			;MOVE 21 CHARACTERS
	CALL	MOVE
	MOV	Word Ptr RESPTR,BX	;UPDATE POINTER
	JMP	SHORT INRCNT		;INCREMENT COUNT
NOCHG:	ADD	Word Ptr RESPTR,21
INRCNT:	DEC	Byte Ptr COUNT		;DECREMENT COUNT
	JNZ	GETKLP			;NOT DONE, CONTINUE
	MOV	AL,Byte Ptr ASKEY+CBUF	;GET ALTERNATE RESP. KEY
	OR	AL,AL			;WANT ALTERNATE KEYS?
	JZ	ASKPAD			;NO, ASK ABOUT KEYPAD
	MOV	DX,(Offset ALKEYM)
	CALL	PMSG			;PRINT "ENTER FUNCTION KEYS"
	MOV	BX,(Offset KEYS)
	MOV	Word Ptr KEYMPTR,BX	;SET KEY MESSAGE POINTER
	MOV	BX,(Offset F0S)+(Offset CBUF)
	MOV	Word Ptr RESPTR,BX	;SET RESPONSE POINTER
	MOV	Byte Ptr COUNT,36	;SET COUNTER
GETKLP1:CALL	CRLF			;PRINT CRLF
	MOV	BX,Word Ptr KEYMPTR	;GET KEY MESSAGE POINTER
	CALL	PMSG1			;PRINT PROMPT
	MOV	Word Ptr KEYMPTR,BX	;UPDATE POINTER
	CALL	OPPAR			;PRINT OPEN PARENTHESES
	MOV	BX,Word Ptr RESPTR	;GET RESPONSE POINTER
	CALL	PMSG1			;PRINT CURRENT KEY RESPONSE
	CALL	CLPAR			;PRINT CLOSING PARENTHESES
	MOV	AL,21			;ALLOW 20 CHARACTERS
	CALL	RDCON			;INPUT RESPONSE
	JZ	NOCHG1			;NO CHANGE
	MOV	BX,Word Ptr RESPTR	;PUT RESPONSE HERE
	MOV	CH,21			;MOVE 21 CHARACTERS
	CALL	MOVE
	MOV	Word Ptr RESPTR,BX	;UPDATE POINTER
	JMP	SHORT INRCNT1		;INCREMENT COUNT
NOCHG1:	ADD	Word Ptr RESPTR,21
INRCNT1:DEC	Byte Ptr COUNT		;DECREMENT COUNT
	JNZ	GETKLP1			;NOT DONE, CONTINUE

;	ASK IF SHIFTED KEYPAD WANTED

ASKPAD:	MOV	DX,(Offset KPADM)
	CALL	PMSG			;ASK FOR KEYPAD SHIFT
	MOV	AL,4
	CALL	RDCON			;GET ANSWER
	MOV	BX,(Offset SPADM)+(Offset CBUF)	;POINT TO WORK AREA
	JZ	ZRPAD			;DO NOT SHIFT PAD
	MOV	SI,DX			;GET ANSWER
	MOV	AL,[SI]
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'			;NO?
	JZ	SHPAD			;NO, SHIFT IT
ZRPAD:	XOR	AX,AX
	MOV	M,AL			;ZERO SHIFT PAD STRING
	INC	BX
	MOV	[BX],AX
	JMP	SHORT NSHPAD
SHPAD:	MOV	M,27			;INSERT SHIFT MESSAGE
	INC	BX
	MOV	Word Ptr [BX],'6x'

;	GET ON/OFF TOGGLE CODE

NSHPAD:	MOV	DX,(Offset TGLKM)
	CALL	PMSG			;ASK FOR TOGGLE CODE
	MOV	AL,5
	CALL	RDCON			;GET ANSWER
	MOV	AL,'^'-'@'		;ASSUME DEFAULT
	JZ	STGLK			;DEFAULT TOGGLE KEY WANTED
	MOV	SI,DX			;GET ANSWER
	MOV	AL,[SI]
	AND	AL,1FH			;MAKE IT A CONTROL CODE
STGLK:	MOV	Byte Ptr TGLK+CBUF,AL	;STORE TOGGLE CODE

;	ASK IF BOTTOM LINE TO BE LEFT ON

	MOV	DX,Offset LBMSG
	CALL	PMSG			;ASK "WANT BOTTOM LINE LEFT ON?"
	MOV	AL,5
	CALL	RDCON			;GET ANSWER
	MOV	BX,(Offset CBUF)+(Offset ERABL)+3
	JZ	LEAVON			;LEAVE IT ON
	MOV	SI,DX
	MOV	AL,[SI]
	AND	AL,5FH
	CMP	AL,'N'			;NO?
	JZ	KILLBL			;KILL BOTTOM LINE
LEAVON:	MOV	M,27			;INSERT MSG TO ENABLE BOTTOM LINE
	INC	BX
	MOV	Word Ptr [BX],'1x'
	JMP	SHORT GOFFLK
KILLBL:	XOR	AX,AX
	MOV	M,AL			;CLEAR BOTTOM ENABLE MSG
	INC	BX
	MOV	[BX],AX

;	GET OFF LINE TOGGLE CODE

GOFFLK:	MOV	DX,(Offset OFLNKM)
	CALL	PMSG			;ASK FOR OFF LINE CODE
	MOV	AL,5
	CALL	RDCON			;GET ANSWER
	MOV	AL,'\'-'@'		;ASSUME DEFAULT
	JZ	SOFLNK			;DEFAULT OFF LINE KEY WANTED
	MOV	SI,DX			;GET ANSWER
	MOV	AL,[SI]
	AND	AL,1FH			;MAKE IT A CONTROL CODE
SOFLNK:	MOV	Byte Ptr OFFLNK+CBUF,AL	;STORE OFF LINE CODE

;	NOW, WRITE THE PATCHED KEYMAP TO DISK

WRITE:	CALL	CRLF
	MOV	DI,Offset FCBX		;POINT TO FCB AFTER FILE TYPE
	XOR	AL,AL			;CLEAR AL
	MOV	CX,33-12		;CLEAR THIS MUCH
	REP	STOSB			;CLEAR FCB
	MOV	DX,Offset CFCB
	MOV	AH,DELETF
	INT	21H			;DELETE OLD KEYMAP
	MOV	DX,(Offset CFCB)
	MOV	AH,MAKEF
	INT	21H			;MAKE NEW ENTRY
;	MOV	DX,Offset CFCB
;	MOV	AH,OPENF
;	INT	21H			;OPEN KEYMAP FILE
	MOV	BX,DX			;BX = FCB
	MOV	AX,RECSIZ
	MOV	Word Ptr 14[BX],AX	;PUT RECORD SIZE IN FCB
	MOV	AH,WRITEF
	MOV	DX,(Offset CFCB)
	INT	21H			;WRITE A SECTOR
	MOV	AH,CLOSEF
	MOV	DX,(Offset CFCB)
	INT	21H			;CLOSE FILE
	MOV	DX,(Offset DONEMSG)
	CALL	PMSG			;PRINT "DONE"
EXIT:	MOV	AH,0
	INT	21H			;RETURN TO Z-DOS

;	SUBROUTINES

;	MESSAGE PRINTERS

CRLF:	MOV	DX,(Offset CRLFM)
	JMP	SHORT PMSG
OPPAR:	MOV	DX,(Offset OPPARM)
	JMP	SHORT PMSG
CLPAR:	MOV	DX,(Offset CLPARM)
PMSG:	MOV	AH,TYPEF
	INT	21H			;PRINT MESSAGE
	RET

;	PRINT MESSAGE AT (BX) UNTIL 0 FOUND.  EXPAND CONTROL
;	CHARACTERS TO "^"+CHAR.

PMSG1:	MOV	AL,M			;GET CHARACTER
	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;END OF MESSAGE?
	JNZ	PMSG2	
	RET				;YES
PMSG2:	CMP	AL,' '			;LESS THAN SPACE?
	JNB	PABLE			;NO, PRINTABLE
	CMP	AL,27			;ESCAPE?
	JNZ	NOTESCP			;NO
	MOV	DX,Offset ESCMSG	;ELSE, PRINT "ESC"
	CALL	PMSG
	JMP	SHORT PMSG1		;PRINT NEXT CHARACTER
NOTESCP:PUSH	AX			;ELSE, SAVE CHARACTER
	MOV	DL,'^'
	MOV	AH,CONOUT
	INT	21H			;PRINT "^"
	POP	AX			;RESTORE CHARACTER
	ADD	AL,'@'			;ADD ASCII
PABLE:	MOV	DL,AL
	MOV	AH,CONOUT
	INT	21H			;PRINT CHARACTER
	JMP	SHORT PMSG1		;PRINT NEXT CHARACTER

;	READ A LINE FROM THE CONSOLE

RDCON:	MOV	Byte Ptr INBUF,AL	;SET IN COUNT
	MOV	DX,(Offset INBUF)	;POINT TO CONSOLE BUFFER
	MOV	AH,LINPUT
	PUSH	DX			;SAVE ADDRESS
	INT	21H			;READ CONSOLE BUFFER
	POP	DX
	INC	DX
	MOV	SI,DX			;GET COUNT
	MOV	AL,[SI]
	OR	AL,AL			;ANY INPUT
	JNZ	RDCON0	
	RET				;RETURN IF NOT
RDCON0:	INC	DX			;MOVE TO START OF WORD
	PUSH	DX			;SAVE START OF ENTRY
	MOV	AH,0
	ADD	DX,AX			;ADD COUNT TO DX
	MOV	DI,DX			;TERMINATE ENTRY WITH 6 ZEROS
	PUSH	CX
	MOV	CX,6
	MOV	AL,0
	REP	STOSB
	POP	CX
	POP	DX			;RESTORE ENTRY ADDRESS
	RET

;	MOVE CH BYTES FROM DX TO BX 

MOVE:	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CMP	AL,'^'			;CONTROL CHARACTER?
	JNZ	MOVE1			;NO
	INC	DX			;ELSE, SKIP "^"
	MOV	SI,DX			;GET NEXT CHARACTER
	MOV	AL,[SI]
	AND	AL,5FH			;CAPITALIZE
	SUB	AL,'@'			;MAKE IT A CONTROL CHARACTER
MOVE1:	MOV	M,AL			;MOVE IT IN
	INC	DX
	INC	BX			;INCREMENT POINTERS
	DEC	CH			;DECREMENT COUNTER
	JNZ	MOVE			;LOOP UNTIL DONE
	RET

;	DATA AREA

CONMSG	DB	13,10,'Z-DOS KEYMAP Function Key Mapper, '
	DB	'Version 1.0 Configuration Utility',13,10,10
	DB	'Enter the name of the KEYMAP program you want '
	DB	'to configure: $'
BLINEM	DB	13,10,10,'Do you want a status line message?'
	DB	' (Y or N -- RETURN = N) $'
ASKEYM	DB	13,10
	DB	'Press the key you want to use for alternate '
	DB	'response select, then RETURN.',13,10
	DB	'(Or, RETURN only to disable alternate response): $'
KEYM	DB	13,10,10
	DB	'Enter the response for each key when prompted.'
	DB	13,10
	DB	'The current response will be shown in parentheses.'
	DB	13,10,'$'
ALKEYM	DB	13,10,10
	DB	'Enter the alternate response for each key when '
	DB	'prompted.',13,10,'$'
ALRESM	DB	27,'p ALTERNATE RESPONSE KEY ',27,'q$'
KEYS	DB	'F0',0,'F1',0,'F2',0,'F3',0,'F4',0,'F5',0,'F6',0
	DB	'F7',0,'F8',0,'F9',0,'F10',0,'F11',0,'F12',0
	DB	'SHIFT-F0',0,'SHIFT-F1',0,'SHIFT-F2',0,'SHIFT-F3',0
	DB	'SHIFT-F4',0,'SHIFT-F5',0,'SHIFT-F6',0,'SHIFT-F7',0
	DB	'SHIFT-F8',0,'SHIFT-F9',0,'SHIFT-F10',0
	DB	'SHIFT-F11',0,'SHIFT-F12',0
	DB	'I CHR',0,'D CHR',0,'INS LINE',0,'DEL LINE',0
	DB	'HOME',0,'BACK ARROW',0,'FORWARD ARROW',0
	DB	'UP ARROW',0,'DOWN ARROW',0,'HELP KEY',0
KPADM	DB	13,10,10
	DB	'Want keypad shifted? (Y or N -- RETURN = N) $'
TGLKM	DB	13,10,10
	DB	'Enter on/off toggle code. (RETURN = Control-^) $'
LBMSG	DB	13,10,10
	DB	'Do you want to leave the 25th line enabled '
	DB	'when KEYMAP is toggled off?',13,10
	DB	'(Y or N -- RETURN = Y) $'
OFLNKM	DB	13,10,10
	DB	'Enter off line toggle code. (RETURN = Control-\) $'
CRLFM	DB	13,10,'$'
OPPARM	DB	' ($'
CLPARM	DB	'): $'
ESCMSG	DB	'ESC-$'
ERAM	DB	27,'y1$'
PRMSG	DB	13,10,10,'Enter messages for each key from left to '
	DB	'right.',13,10,'$'
ENMSG	DB	13,10,'Enter message for F$'
ENMSG1	DB	': $'
OKM	DB	13,10,10
	DB	'Does this look OK? (Y or N -- RETURN = Y) $'
INTRO	DB	27,'j',27,'x1',27,'Y8 '
ISTR	DB	27,'p'
ISTR1	DB	27,'q'
OUTRO	DB	27,'k',1AH
DONEMSG	DB	13,10,'KEYMAP configuration completed.',13,10,'$'
OPMSG	DB	13,10,'ERROR - Can',27H,'t find your KEYMAP program.',13,10,'$'
BADRD	DB	13,10,'ERROR - Can',27H,'t read your KEYMAP program.',13,10,'$'

OUTPTR	DW	0			;STATUS MSG OUTPUT POINTER
RECSIZ	DW	0			;KEYMAP FILE RECORD SIZE
KEYMPTR	DW	0			;KEY MESSAGE POINTER
RESPTR	DW	0			;RESPONSE POINTER
COUNT	DB	0			;COUNTER
CFCB	DB	0,'KEYMAP  COM'
FCBX	DB	0,0,0,0
	DB	16 DUP (0)
	DB	0,0,0,0
INBUF	DB	28 DUP (0)		;INPUT BUFFER
	DB	256 DUP (0)		;STACK SPACE
STACK	EQU	(Offset $)
CBUF	EQU	(Offset $)		;CONFIG BUFFER

;	CONSTANTS IN THE KEYMAP PROGRAM

MAPTBL	EQU	3
F0	EQU	55H
F0S	EQU	358H
SPADM	EQU	65DH
BLMSG	EQU	663H
ASKEY	EQU	767H
TGLK	EQU	769H
OFFLNK	EQU	76AH
ERABL	EQU	76BH
CONF	ENDS
	END	CONFIG
