	TITLE	KEYMAP FUNCTION KEY MAPPER
	PAGE	,132
;	KEYMAP -- MAP FUNCTION KEYS TO USER DEFINED CHARACTERS
;
;	THIS PROGRAM MAPS THE VARIOUS FUNCTION KEYS TO USER
;	DEFINED CHARACTER SEQUENCES.  THE SEQUENCE FOR ANY
;	ONE KEY CAN BE UP TO 20 CHARACTERS.
;
;	BY P. SWAYNE, HUG  27-JAN-84
;	COPYRIGHT (C) 1984 BY HEATH USERS' GROUP

;	DEFINITIONS

BIOSSEG	SEGMENT AT 40H
	ORG	3
BCONST	LABEL	FAR			;BIOS CONSOLE STATUS
	ORG	6
BCONIN	LABEL	FAR			;BIOS CONSOLE INPUT
	ORG	9
BCONOUT	LABEL	FAR			;BIOS CONSOLE OUTPUT
BIOSSEG	ENDS
M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
TYPEF	EQU	9			;TYPE STRING FUNCTION

KEY	SEGMENT
	ASSUME	CS:KEY,DS:KEY,SS:KEY,ES:KEY
	ORG	100H

START:	JMP	SETUP			;SET UP KEYMAP

;	TABLE OF MAPPED SEQUENCES

MAPTBL	DW	(Offset IC)
	DW	(Offset UP)
	DW	(Offset DN)
	DW	(Offset FWD)
	DW	(Offset BK)
	DW	(Offset SF0)
	DW	(Offset ESCF)
	DW	(Offset ESCG)
	DW	(Offset HOME)
	DW	(Offset ESCI)
	DW	(Offset F0)
	DW	(Offset ESCK)
	DW	(Offset IL)
	DW	(Offset DLX)
	DW	(Offset DC)
	DW	(Offset ESCO)
	DW	(Offset F6)
	DW	(Offset F7)
	DW	(Offset F8)
	DW	(Offset F1)
	DW	(Offset F2)
	DW	(Offset F3)
	DW	(Offset F4)
	DW	(Offset F5)
MAPTBL1	DW	Offset F9
	DW	Offset F10
	DW	Offset F11
	DW	Offset F12
MAPTBL2	DW	Offset SF1
	DW	Offset SF2
	DW	Offset SF3
	DW	Offset SF4
	DW	Offset SF5
	DW	Offset SF6
	DW	Offset SF7
	DW	Offset SF8
	DW	Offset SF9
	DW	Offset SF10
	DW	Offset SF11
	DW	Offset SF12
HELPKEY	DW	HELP

;	MAPPED CHARACTER SEQUENCES

F0	DB	27,'J',0
	DB	18 DUP (0)
F1	DB	27,'S',0
	DB	18 DUP (0)
F2	DB	27,'T',0
	DB	18 DUP (0)
F3	DB	27,'U',0
	DB	18 DUP (0)
F4	DB	27,'V',0
	DB	18 DUP (0)
F5	DB	27,'W',0
	DB	18 DUP (0)
F6	DB	27,'P',0
	DB	18 DUP (0)
F7	DB	27,'Q',0
	DB	18 DUP (0)
F8	DB	27,'R',0
	DB	18 DUP (0)
F9	DB	27,'0I',0
	DB	17 DUP (0)
F10	DB	27,'0J',0
	DB	17 DUP (0)
F11	DB	27,'0K',0
	DB	17 DUP (0)
F12	DB	27,'0L',0
	DB	17 DUP (0)
SF0	DB	27,'E',0
	DB	18 DUP (0)
SF1	DB	27,'1A',0
	DB	17 DUP (0)
SF2	DB	27,'1B',0
	DB	17 DUP (0)
SF3	DB	27,'1C',0
	DB	17 DUP (0)
SF4	DB	27,'1D',0
	DB	17 DUP (0)
SF5	DB	27,'1E',0
	DB	17 DUP (0)
SF6	DB	27,'1F',0
	DB	17 DUP (0)
SF7	DB	27,'1G',0
	DB	17 DUP (0)
SF8	DB	27,'1H',0
	DB	17 DUP (0)
SF9	DB	27,'1I',0
	DB	17 DUP (0)
SF10	DB	27,'1J',0
	DB	17 DUP (0)
SF11	DB	27,'1K',0
	DB	17 DUP (0)
SF12	DB	27,'1L',0
	DB	17 DUP (0)
IC	DB	27,'@',0
	DB	18 DUP (0)
DC	DB	27,'N',0
	DB	18 DUP (0)
IL	DB	27,'L',0
	DB	18 DUP (0)
DLX	DB	27,'M',0
	DB	18 DUP (0)
HOME	DB	27,'H',0
	DB	18 DUP (0)
BK	DB	27,'D',0
	DB	18 DUP (0)
FWD	DB	27,'C',0
	DB	18 DUP (0)
UP	DB	27,'A',0
	DB	18 DUP (0)
DN	DB	27,'B',0
	DB	18 DUP (0)
HELP	DB	27,'~',0
	DB	18 DUP (0)
ESCF	DB	27,'F',0
ESCG	DB	27,'G',0
ESCI	DB	27,'I',0
ESCK	DB	27,'K',0
ESCO	DB	27,'O',0

;	ALTERNATE MAPPED CHARACTER SEQUENCES

F0S	DB	27,'J',0
LTBL	EQU	(Offset F0S)-(Offset F0)
	DB	18 DUP (0)
F1S	DB	27,'S',0
	DB	18 DUP (0)
F2S	DB	27,'T',0
	DB	18 DUP (0)
F3S	DB	27,'U',0
	DB	18 DUP (0)
F4S	DB	27,'V',0
	DB	18 DUP (0)
F5S	DB	27,'W',0
	DB	18 DUP (0)
F6S	DB	27,'P',0
	DB	18 DUP (0)
F7S	DB	27,'Q',0
	DB	18 DUP (0)
F8S	DB	27,'R',0
	DB	18 DUP (0)
F9S	DB	27,'0I',0
	DB	17 DUP (0)
F10S	DB	27,'0J',0
	DB	17 DUP (0)
F11S	DB	27,'0K',0
	DB	17 DUP (0)
F12S	DB	27,'0L',0
	DB	17 DUP (0)
SF0S	DB	27,'E',0
	DB	18 DUP (0)
SF1S	DB	27,'1A',0
	DB	17 DUP (0)
SF2S	DB	27,'1B',0
	DB	17 DUP (0)
SF3S	DB	27,'1C',0
	DB	17 DUP (0)
SF4S	DB	27,'1D',0
	DB	17 DUP (0)
SF5S	DB	27,'1E',0
	DB	17 DUP (0)
SF6S	DB	27,'1F',0
	DB	17 DUP (0)
SF7S	DB	27,'1G',0
	DB	17 DUP (0)
SF8S	DB	27,'1H',0
	DB	17 DUP (0)
SF9S	DB	27,'1I',0
	DB	17 DUP (0)
SF10S	DB	27,'1J',0
	DB	17 DUP (0)
SF11S	DB	27,'1K',0
	DB	17 DUP (0)
SF12S	DB	27,'1L',0
	DB	17 DUP (0)
ICS	DB	27,'@',0
	DB	18 DUP (0)
DCS	DB	27,'N',0
	DB	18 DUP (0)
ILS	DB	27,'L',0
	DB	18 DUP (0)
DLS	DB	27,'M',0
	DB	18 DUP (0)
HOMES	DB	27,'H',0
	DB	18 DUP (0)
BKS	DB	27,'D',0
	DB	18 DUP (0)
FWDS	DB	27,'C',0
	DB	18 DUP (0)
UPS	DB	27,'A',0
	DB	18 DUP (0)
DNS	DB	27,'B',0
	DB	18 DUP (0)
HELPS	DB	27,'~',0
	DB	18 DUP (0)
ESCFS	DB	27,'F',0
ESCGS	DB	27,'G',0
ESCIS	DB	27,'I',0
ESCKS	DB	27,'K',0
ESCOS	DB	27,'O',0
SPCHAR	DB	0,0			;SPECIAL CHAR FOR UNDEF. SEQ.
SPADM	DB	0,0,0			;SHIFT KEYPAD MESSAGE
	DB	27,'x?'			;ENSURE KEYS EXPANDED
BLMSG	DB	1AH
	DB	255 DUP (0)		;BOTTOM LINE MESSAGE

MAPFLG	DB	0			;MAPPING IN PROGRESS FLAG
MAPPTR	DW	0			;MAPPED CHARACTER POINTER
ASFLG	DB	0			;ALTERNATE SELECT FLAG
FSKEY	DB	0			;ALTERNATE FUNCTION SHIFT KEY
TGLFLG	DB	0			;ON/OFF TOGGLE FLAG
TGLK	DB	'^'-'@'			;TOGGLE KEY
OFFLNK	DB	'\'-'@'			;OFF LINE KEY
ERABL	DB	27,'y1'			;ERASE BOTTOM LINE
	DB	27,'x1'
UNSHF	DB	27,'y6',1AH		;UNSHIFT KEYPAD

;	THIS IS THE MAIN CODE THAT INTERCEPTS BIOS CONSOLE
;	STATUS AND INPUT CALLS TO DETECT FUNCTION KEYS AND
;	MAP THE USER-DEFINED CHARACTERS TO THEM

;	MY CONSOLE STATUS ROUTINE

MYCONST:PUSH	BX			;PUSH REGISTERS TO MATCH BIOS
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	CMP	Byte Ptr CS:MAPFLG,0	;ARE WE MAPPING?
	JNZ	MAPST			;YES
XCONST:
	DB	0EAH			;ELSE, CHECK STATUS (EA = FAR JUMP)
CONSTV	DW	0			;(PUT CONST VECTOR HERE)
	DW	40H			;BIOS SEGMENT
MAPST:	MOV	BX,Word Ptr CS:MAPPTR	;GET MAP CHARACTER POINTER
	MOV	AL,Byte Ptr CS:[BX]	;GET NEXT CHARACTER
	OR	AL,AL			;DONE MAPPING?
	JZ	CKRST			;YES, CHECK REGULAR STATUS
;	MOV	AL,0FFH
	JMP	SHORT FARRET		;ELSE, RETURN CHAR READY
CKRST:	MOV	Byte Ptr CS:MAPFLG,AL	;CLEAR MAP FLAG
	JMP	SHORT XCONST		;CHECK STATUS

;	MY CONSOLE INPUT ROUTINE

MYCONIN:PUSH	BX			;PUSH REGISTERS TO MATCH BIOS
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	CMP	Byte Ptr CS:MAPFLG,0	;ARE WE MAPPING?
	JZ	NMAP			;NO
	JMP	MAP			;YES, RETURN MAPPED CHARACTER
NMAP:	CALL	BCONST			;ELSE, GET NEXT REGULAR CHARACTER
	JZ	NMAP			;WAIT FOR CHARACTER

;	THE ABOVE LOOP TAKES CARE OF A POTENTIALLY DISASTEROUS "JUMP ON
;	CARRY" INSTRUCTION IN THE BIOS CONSOLE INPUT ROUTINE.  IT ENSURES
;	THAT A CHARACTER IS READY WHEN THE BIOS ROUTINE IS EXECUTED.
;	(THIS INFORMATION IS PROVIDED FOR THOSE OF YOU WHO ARE TRYING TO
;	FIGURE OUT HOW THIS THING WORKS.)

	CMP	AL,Byte Ptr CS:TGLK	;TOGGLE KEYMAP?
	JNZ	NOTGL	
	JMP	TOGGLE			;GO TOGGLE KEYMAP
NOTGL:	CMP	AL,Byte Ptr CS:OFFLNK	;GO OFF LINE?
	JNZ	NOTOFL
	JMP	OFFLIN			;GO OFF LINE
NOTOFL:	CMP	AL,27			;ESCAPE?
ESCCHR	EQU	(Offset $)-1
	JZ	GOTESC	
	DB	0EAH			;NO, RETURN WITH CHARACTER VIA CONIN
CONINV	DW	0			;(PUT CONIN VECTOR HERE)
	DW	40H			;BIOS SEGMENT
FARRET:	MOV	BL,AL			;NO, PREPARE TO RETURN
	POP	AX
	MOV	AL,BL			;AH UNCHANGED, AL = CHAR
	POP	DX
	POP	SI
	POP	DI
	POP	BX
	DB	0CBH			;FAR RETURN

;	WE HAVE AN ESCAPE CHAR -- SEE IF IT'S PART OF AN ESCAPE SEQUENCE

GOTESC:	MOV	Byte Ptr CS:ESCCHR,0	;DISABLE ESCAPE CHECK
	CALL	BCONIN			;GET THE ESCAPE CHARACTER
	MOV	Byte Ptr CS:ESCCHR,27	;FIX ESCAPE CHECK
	CMP	Byte Ptr CS:TGLFLG,0	;TEST FOR ON/OFF TOGGLE
	JZ	KEYON	
	JMP	SHORT FARRET		;KEYMAP IS OFF
KEYON:	MOV	DL,50			;TRY FOR ESC-CH 50 TIMES
ESCLP:	CALL	BCONST			;CKECK CONSOLE STATUS
	JNZ	GOTCHR			;GOT A CHARACTER
	DEC	DL			;ELSE, DECREMENT COUNTER
	JNZ	ESCLP			;TRY AGAIN
	MOV	Byte Ptr CS:ASFLG,0	;CLEAR ALTERNATE SEL. FLAG
	MOV	AL,27
	JMP	SHORT FARRET		;RETURN WITH ESC

;	IT'S AN ESCAPE SEQUENCE -- SEE IF IT IS A FUNCTION KEY

GOTCHR:	CALL	BCONIN			;GET NEXT CHARACTER
	MOV	BX,Offset HELPKEY	;ASSUME HELP
	CMP	AL,'~'			;IS IT HELP?
	JZ	MHELP
	MOV	BX,Offset MAPTBL1	;ASSUME F9-F12
	CMP	AL,'0'			;IS IT?
	JZ	MAPT1			;YES
	MOV	BX,Offset MAPTBL2	;ASSUME SHIFT-F KEYS
	CMP	AL,'1'			;IS IT?
	JZ	MAPT2			;YES
	MOV	BX,Offset MAPTBL	;ELSE, USE REGULAR TABLE
	CMP	AL,'@'			;"@" OR MORE?
	JNB	GDCHR			;YES
	JMP	SPMAP			;NO
GDCHR:	CMP	AL,'W'+1		;"W" OR LESS?
	JB	GDCHR1			;YES
	JMP	SPMAP			;NO
MHELP:	SUB	AL,'~'-'@'		;FIX AL FOR INDEX INTO TABLE
	JMP	SHORT NOAS
MAPT1:	CALL	BCONIN			;GET NEXT CHARACTER
	SUB	AL,'I'-'@'		;FIX AL
	JMP	SHORT NOAS
MAPT2:	CALL	BCONIN			;GET NEXT CHARACTER
	SUB	AL,1			;FIX AL
MAPT3:	JMP	SHORT NOAS		;AND PROCESS KEY
GDCHR1:	CMP	Byte Ptr CS:ASFLG,0	;WORKING ON ALTERNATE KEY?
	JNZ	NOAS			;IF SO, SKIP SHIFT CHECK
	CMP	AL,Byte Ptr CS:FSKEY	;IS THIS THE ALTERNATE SEL. KEY?
	JNZ	NOAS			;NO
	INC	Byte Ptr CS:ASFLG	;ELSE, SET ALTERNATE SEL. FLAG
	MOV	Byte Ptr CS:ESCCHR,0	;SUPPRESS ESCAPE CHECK
	CALL	BCONIN			;GET SECOND KEY
	MOV	Byte Ptr CS:ESCCHR,27	;FIX ESCAPE CHECK
	CMP	AL,27			;ESCAPE?
	JZ	KEYONJ			;IT'S ESCAPE, GET NEXT CHARACTER
	DEC	Byte Ptr CS:ASFLG	;ELSE, CLEAR ALTERNATE SEL. FLAG
	JMP	FARRET
KEYONJ:	JMP	KEYON

;	IT'S A VALID FUNCTION KEY -- TURN MAPPING ON

NOAS:	INC	Byte Ptr CS:MAPFLG	;SET MAP FLAG
	SUB	AL,'@'			;REMOVE ASCII FROM CHARACTER
	ADD	AL,AL			;DOUBLE IT
	MOV	AH,0
	ADD	BX,AX			;BX POINTS TO TABLE ENTRY
	MOV	BX,CS:[BX]		;BX POINTS TO MAP STRING
	CMP	Byte Ptr CS:ASFLG,0	;ALTERNATE FUNCTION?
	JZ	NOAS1			;NO
	ADD	BX,LTBL			;ELSE, USE SECOND SHIFT TABLE ENTRY
	MOV	Byte Ptr CS:ASFLG,0	;CLEAR ALTERNATE FLAG
NOAS1:	MOV	Word Ptr CS:MAPPTR,BX	;SET UP MAP POINTER

;	MAPPING ROUTINE -- SENDS A CHARACTER FROM THE USER SUPPLIED
;	STRING AS LONG AS THE SYSTEM REQUESTS KEYBOARD INPUT, UNTIL
;	THE END OF THE STRING IS REACHED.  THEN NORMAL INPUT IS
;	RESUMED

MAP:	MOV	BX,Word Ptr CS:MAPPTR	;GET MAP POINTER
	MOV	AL,Byte Ptr CS:[BX]	;GET MAPPED CHARACTER
	MOV	AH,AL			;SAVE CHARACTER
	INC	BX
	MOV	AL,Byte Ptr CS:[BX]	;PREVIEW NEXT CHARACTER
	OR	AL,AL			;END OF STRING?
	JNZ	NOTEND			;NO
	MOV	Byte Ptr CS:MAPFLG,AL	;ELSE, CLEAR MAP FLAG
NOTEND:	MOV	AL,AH			;GET CHARACTER
	MOV	Word Ptr CS:MAPPTR,BX	;UPDATE MAP POINTER
	JMP	FARRET			;RETURN WITH MAPPED CHARACTER

;	TOGGLE KEYMAP OFF AND ON

TOGGLE:	MOV	DL,Byte Ptr CS:TGLK	;GET THE TOGGLE CHARACTER
	MOV	Byte Ptr CS:TGLK,0	;KILL TOGGLE CHECK
	CALL	BCONIN			;ABSORB TOGGLE CHARACTER
	MOV	Byte Ptr CS:TGLK,DL	;RESTORE TOGGLE CHECK
	XOR	Byte Ptr CS:TGLFLG,1	;TOGGLE TOGGLE FLAG
	MOV	BX,(Offset SPADM)	;ASSUME FLAG NOT SET
	JZ	TOGGLE1			;FLAG NOT SET, PRINT BOTTOM MSG
	CMP	Byte Ptr CS:BLMSG,1AH	;ANY BOTTOM LINE MESSAGE?
	MOV	BX,Offset UNSHF		;ASSUME NONE
	JZ	TOGGLE1			;IF NONE, LEAVE BOTTOM LINE ALONE
	MOV	BX,Offset ERABL		;ELSE, ERASE IT
TOGGLE1:PUSH	CX
	MOV	CX,256+6		;SET A COUNTER
PBLMSG:	MOV	AL,Byte Ptr CS:[BX]	;GET A CHARACTER
	CMP	AL,1AH			;END OF FILE?
	JZ	TOGGLE2			;IF SO, EXIT
	CALL	BCONOUT			;PRINT THIS ONE
	INC	BX			;INCREMENT POINTER
	LOOP	PBLMSG			;IF NOT DONE, CONTINUE
TOGGLE2:POP	CX
	JMP	NMAP			;GET ANOTHER INPUT

;	TAKE "TERMINAL" OFF LINE, SO USER CAN ENTER ESCAPE SEQUENCES, ETC.

OFFLIN:	MOV	DL,Byte Ptr CS:TGLK	;SAVE TOGGLE KEY
	MOV	DH,Byte Ptr CS:OFFLNK	;AND OFF LINE KEY
	XOR	AL,AL			;GET A ZERO
	MOV	Byte Ptr CS:TGLK,AL	;CLEAR TOGGLE CHECK
	MOV	Byte Ptr CS:OFFLNK,AL	;AND OFF LINE CHECK
	MOV	Byte Ptr ESCCHR,AL	;AND ESCAPE CHECK
	CALL	BCONIN			;ABSORB THE OFF LINE CHAR.
OFFLP:	CALL	BCONIN			;GET A CHARACTER
	CMP	AL,DH			;GO BACK ON LINE?
	JZ	ONLIN			;YES
	CALL	BCONOUT			;ELSE, ECHO CHARACTER
	JMP	SHORT OFFLP		;GO AROUND AGAIN
ONLIN:	MOV	Byte Ptr CS:TGLK,DL	;RESTORE TOGGLE CHECK
	MOV	Byte Ptr CS:OFFLNK,DH	;RESTORE OFF LINE CHECK
	MOV	Byte Ptr CS:ESCCHR,27	;RESTORE ESCAPE CHECK
	JMP	NMAP			;CONTINUE WHERE WE LEFT OFF

;	MAP NON-DEFINDED ESCAPE SEQUENCES
;	TO PRESERVE THEM INTACT

SPMAP:	MOV	Byte Ptr CS:SPCHAR,AL	;INSERT CHARACTER IN BUFFER
	MOV	Word Ptr CS:MAPPTR,Offset SPCHAR	;SET UP MAP POINTER
	INC	Byte Ptr CS:MAPFLG	;TURN ON MAPPING
	MOV	AL,27			;RETURN WITH ESC. CHARACTER
	JMP	FARRET
LEND:					;END OF RESIDENT CODE

;	SET UP FOR KEY MAPPING BY VECTORING BIOS CONSOLE STATUS
;	AND INPUT ROUTINES TO THIS PROGRAM

SETUP:	MOV	AX,40H
	MOV	DS,AX			;PUT DS IN BIOS SEGMENT
	MOV	BX,4			;POINT TO CONSOLE STATUS ADDRESS
	MOV	DX,[BX]			;GET STATUS ADDRESS
	MOV	CX,3[BX]		;GET CONSOLE INPUT ADDRESS
	ADD	DX,6			;CONVERT ADDRESSES TO ABSOLUTE
	ADD	CX,9
	MOV	BX,DX			;NOW, POINT TO STATUS ROUTINE
	CMP	M,0EAH			;KEYMAP ALREADY IN?
	JZ	ITSIN			;YES
	MOV	M,0EAH			;PUT FAR JUMP IN
	MOV	Word Ptr 1[BX],Offset MYCONST	;PUT MY ADDRESS IN
	MOV	AX,CS			;GET THE CURRENT SEGMENT
	MOV	3[BX],AX		;COMPLETE THE FAR JUMP ADDRESS
	MOV	BX,CX			;GET INPUT ADDRESS
	MOV	M,0EAH			;PUT FAR JUMP IN
	MOV	Word Ptr 1[BX],Offset MYCONIN	;PUT MY ADDRESS IN
	MOV	3[BX],AX		;COMPLETE THE FAR JUMP ADDRESS
	MOV	DS,AX			;RESTORE DS
	ADD	DX,5			;CALCULATE NEW ENTRY TO CONST
	MOV	Word Ptr CONSTV,DX	;SET IT UP
	ADD	CX,5			;CALCULATE NEW ENTRY TO CONIN
	MOV	Word Ptr CONINV,CX	;SET IT UP
	MOV	DX,Offset SIGNON
	MOV	AH,TYPEF
	INT	21H			;PRINT SIGN ON MESSAGE
	MOV	BX,Offset SPADM		;POINT TO BOTTOM MESSAGE
	MOV	CX,256+6
MLOOP:	MOV	AL,M
	CMP	AL,1AH			;END OF MSG?
	JZ	MSEND
	CALL	BCONOUT			;PRINT BOTTOM MSG
	INC	BX
	LOOP	MLOOP
MSEND:	MOV	DX,Offset LEND		;SET DX
	INT	27H			;TERMINATE, BUT STAY RESIDENT
ITSIN:	MOV	AX,CS
	MOV	DS,AX			;RESTORE DX
	MOV	DX,Offset INMSG
	MOV	AH,TYPEF
	INT	21H			;SAY "ALREADY LOADED"
	INT	20H			;AND EXIT

SIGNON	DB	13,10
	DB	'Z-DOS KEYMAP Function Key Mapper, Version 1.0'
	DB	' (by PS:) is now installed.$'
INMSG	DB	13,10
	DB	'ERROR -- KEYMAP is already installed.$'

KEY	ENDS
	END	START
                                      