/* -*- mode: C; c-file-style: "gnu" -*- */
/* dbus-server-unix.h Server implementation for Unix network protocols.
 *
 * Copyright (C) 2002  Red Hat Inc.
 *
 * Licensed under the Academic Free License version 2.0
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef DBUS_SERVER_UNIX_H
#define DBUS_SERVER_UNIX_H

#include <dbus/dbus-internals.h>
#include <dbus/dbus-server-protected.h>

DBUS_BEGIN_DECLS;

DBusServer* _dbus_server_new_for_fd            (int               fd,
                                                const DBusString *address);
DBusServer* _dbus_server_new_for_domain_socket (const char       *path,
                                                dbus_bool_t       abstract,
                                                DBusError        *error);
DBusServer* _dbus_server_new_for_tcp_socket    (const char       *host,
                                                dbus_uint32_t     port,
                                                DBusError        *error);


DBUS_END_DECLS;

#endif /* DBUS_SERVER_UNIX_H */
