/*                                                                      
    This file is part of KAddressBook.                                  
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>                   
                                                                        
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or   
    (at your option) any later version.                                 
                                                                        
    This program is distributed in the hope that it will be useful,     
    but WITHOUT ANY WARRANTY; without even the implied warranty of      
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the        
    GNU General Public License for more details.                        
                                                                        
    You should have received a copy of the GNU General Public License   
    along with this program; if not, write to the Free Software         
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           
                                                                        
    As a special exception, permission is given to link this program    
    with any edition of Qt, and distribute the resulting executable,    
    without including the source code for Qt in the source distribution.
*/                                                                      

#include <qevent.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtl.h>
#include <qapplication.h>

#include <kabc/addressbook.h>
#include <kabc/field.h>
#include <kdebug.h>
#include <klocale.h>

#include "kabcore.h"

#include "jumpbuttonbar.h"

class JumpButton : public QPushButton
{
  public:
    JumpButton( const QString &text, QWidget *parent,
                const QString &character );

    void setCharacter( const QString &character );
    QString character() const;

  private:
    QString mCharacter;
};

JumpButton::JumpButton( const QString &text, QWidget *parent,
                        const QString &character )
  : QPushButton( text, parent )
{
  mCharacter = character;
}

void JumpButton::setCharacter( const QString &character )
{
  mCharacter = character;
  setText(mCharacter.upper() );
}

QString JumpButton::character() const
{
  return mCharacter;
}

JumpButtonBar::JumpButtonBar( KABCore *core, QWidget *parent, const char *name )
  : QWidget( parent, name ), mCore( core )
{
    if ( QApplication::desktop()->width() < 480 )
        
        mButtonLayout = new QGridLayout( this,  2, 14 );
    else
        mButtonLayout = new QGridLayout( this,  1, 28 );
  mButtonLayout->setAlignment( Qt::AlignTop );

  recreateButtons();
}

JumpButtonBar::~JumpButtonBar()
{
}

QSizePolicy JumpButtonBar::sizePolicy() const
{
#ifndef KAB_EMBEDDED  
  return QSizePolicy( QSizePolicy::Maximum, QSizePolicy::Minimum,
                      QSizePolicy::Vertically );
#else //KAB_EMBEDDED  
  return QSizePolicy( QSizePolicy::Maximum, QSizePolicy::Minimum);
#endif //KAB_EMBEDDED  
}
  
void JumpButtonBar::letterClicked()
{
  JumpButton *button = (JumpButton*)sender();
  QString character = button->character();
  if ( !character.isNull() )
    emit jumpToLetter( character );
}

void JumpButtonBar::recreateButtons()
{
  // the easiest way to remove all buttons ;)
  //mButtons.setAutoDelete( true );
  //mButtons.clear();
  //mButtons.setAutoDelete( false );
  mCharacters.clear();

  QString character;
  
  KABC::AddressBook *ab = mCore->addressBook();
  KABC::AddressBook::Iterator it;
  KABC::Field *field = mCore->currentSearchField();
  if ( field ) {
      setEnabled( true );
  } else {
      setEnabled( false );
      return;
  }
  for ( it = ab->begin(); it != ab->end(); ++it ) {
      if ( !field->value( *it ).isEmpty() )
          character = field->value( *it )[ 0 ].lower();
      if ( !character.isEmpty() && !mCharacters.contains( character ) )
          mCharacters.append( character );
  }
  if ( mCharacters.count() == 0 ) {
      setEnabled( false );
      return;
  }
  
  int maxRows = mCharacters.count() / 2; // we use 2 columns
  if ( mCharacters.count() % 2 )
    maxRows++;
  int fixwid = 20;
  sortListLocaleAware( mCharacters );
  bool skip2 = false;
  int skipcount = 0;
  int maxHei = 25;
  if ( QApplication::desktop()->width() < 480 && mCharacters.count() > 13) {
      skipcount = mCharacters.count()-13;
      maxHei = (QApplication::desktop()->height()-65)/13;
  }
  else {
      fixwid = 30;
      if ( mCharacters.count() > 20 )
          skipcount = mCharacters.count()- 20;
      maxHei = (QApplication::desktop()->height()-120)/(mCharacters.count()-skipcount);

  }
     maxRows = 28;
     bool skipcurrent = false;
  bool state = isUpdatesEnabled();
  setUpdatesEnabled( false );
  //qDebug("cc %d ",mCharacters.count() );
  JumpButton *button;
  int row = 0, col = 0;
  JumpButton* cur = mButtons.first();
  for ( uint i = 0; i < mCharacters.count(); ++i ) {
      if ( skipcount > 0 && skipcurrent ) {
          --skipcount;
      } else {
          if ( cur ) {
              button = cur ;
              cur = mButtons.next();
              button->setCharacter(mCharacters[ i ]);
          } else {
              button = new JumpButton( mCharacters[ i ].upper(), this, mCharacters[ i ] );
              button->setFixedWidth( fixwid );
              mButtons.append( button );
              connect( button, SIGNAL( clicked() ), this, SLOT( letterClicked() ) );
              mButtonLayout->addWidget( button, row, col );
          }
          button->setMaximumHeight( maxHei );
          button->show();
          
          if ( col == maxRows ) {
              row = 0;
              col++;
          } else
              row++;
      }
      
      skipcurrent = !skipcurrent;
  }
  while ( cur ) {
      cur->hide();
       cur = mButtons.next();
  }

  mButtonLayout->activate();
  setUpdatesEnabled( state );
  update();
}

void JumpButtonBar::sortListLocaleAware( QStringList &list )
{
  QStringList::Iterator beginIt = list.begin();
  QStringList::Iterator endIt = list.end();

  --endIt;
  if ( beginIt == endIt ) // don't need sorting
    return;

  QStringList::Iterator walkBackIt = endIt;
  while ( beginIt != endIt ) {
    QStringList::Iterator j1 = list.begin();
    QStringList::Iterator j2 = j1;
    ++j2;
    while ( j1 != walkBackIt ) {
#ifndef KAB_EMBEDDED      
      if ( QString::localeAwareCompare( *j2, *j1 ) < 0 )
#else //KAB_EMBEDDED      
      if ( QString::compare( *j2, *j1 ) < 0 )
#endif //KAB_EMBEDDED      
        qSwap( *j1, *j2 );

      ++j1;
      ++j2;
    }
    ++beginIt;
    --walkBackIt;
  }
}

#ifndef KAB_EMBEDDED
#include "jumpbuttonbar.moc"
#endif //KAB_EMBEDDED
