#ifndef DESKTOP_VERSION
#include <qpe/qpeapplication.h>
#include <stdlib.h>
#else
#include <qapplication.h>
#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#include <qmainwindow.h>
#endif

#include <kstandarddirs.h>
#include <kglobal.h>
#include <stdio.h>
#include <qdir.h>
#include "kaddressbookmain.h"
#include "externalapphandler.h"

int main( int argc, char **argv )
{
#ifndef DESKTOP_VERSION
  QPEApplication a( argc, argv );
  a.setKeepRunning ();
#else
  QApplication a( argc, argv );
  QApplication::setStyle( new QPlatinumStyle ());
  QString hdir = QDir::homeDirPath();
  // there is a bug when creating dirs for WIN 98
  // it is difficult to fix, because we have no WIN 98 runnung
  // such that we try it to create the dirs at startup here
  if ( hdir == "C:\\" ) { // win 98 or ME
       QDir app_dir;
       if ( !app_dir.exists("C:\\kdepim") )
           app_dir.mkdir ("C:\\kdepim");
       if ( !app_dir.exists("C:\\kdepim\\apps") )
           app_dir.mkdir ("C:\\kdepim\\apps");
       if ( !app_dir.exists("C:\\kdepim\\config") )
           app_dir.mkdir ("C:\\kdepim\\config");
       if ( !app_dir.exists("C:\\kdepim\\apps\\kaddressbook") )
           app_dir.mkdir ("C:\\kdepim\\apps\\kaddressbook");
  }
#endif

  bool exitHelp = false;
  if ( argc > 1 ) {
      QString command = argv[1];
      if (  command == "-help" ){
          printf("KA/E command line commands:\n");
          printf("  no command: Start KA/E in usual way\n");
          printf("  -help: This output\n");
          printf(" KA/E is exiting now. Bye!\n");
          exitHelp = true;
      }
  }
  if ( ! exitHelp ) {

    KGlobal::setAppName( "kaddressbook" );
#ifndef DESKTOP_VERSION
    if ( QApplication::desktop()->width() > 320 )
        KGlobal::iconLoader()->setIconPath(QString(getenv("QPEDIR"))+"/pics/kdepim/kaddressbook/icons22/");
    else
        KGlobal::iconLoader()->setIconPath(QString(getenv("QPEDIR"))+"/pics/kdepim/kaddressbook/icons16/");
#else
      QString fileName ;
      fileName  = qApp->applicationDirPath () + "/kdepim/kaddressbook/icons22/";
      KGlobal::iconLoader()->setIconPath(QDir::convertSeparators(fileName));
      QApplication::addLibraryPath ( qApp->applicationDirPath () );

#endif
      KStandardDirs::setAppDir( QDir::convertSeparators(locateLocal("data", "kaddressbook")));
       KAddressBookMain m ;
//US      MainWindow m;
      QObject::connect(&a, SIGNAL (appMessage ( const QCString &, const QByteArray & )), ExternalAppHandler::instance(), SLOT (appMessage ( const QCString &, const QByteArray & )));

#ifndef DESKTOP_VERSION
       a.showMainWidget( &m );
#else
      a.setMainWidget( &m );
      m.resize (640, 480 );
      m.show();
#endif
      a.exec();

  }
  qDebug("KA: Bye! ");
}

/*
#include <stdlib.h>

#include <qstring.h>

#include <kabc/stdaddressbook.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kcrash.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstartupinfo.h>
#include <kuniqueapplication.h>
#include <kwin.h>

#include "kaddressbookmain.h"
#include "kabcore.h"

extern "C" {

void crashHandler( int )
{
  KABC::StdAddressBook::handleCrash();
  ::exit( 0 );
}

}

class KAddressBookApp : public KUniqueApplication {
  public:
    KAddressBookApp() : mMainWin( 0 ) {}
    ~KAddressBookApp() {}

    int newInstance();

  private:
    KAddressBookMain *mMainWin;
};

int KAddressBookApp::newInstance()
{
  if ( isRestored() ) {
    // There can only be one main window
    if ( KMainWindow::canBeRestored( 1 ) ) {
      mMainWin = new KAddressBookMain;
      mMainWin->show();
      mMainWin->restore( 1 );
    }
  } else {
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    QCString addrStr = args->getOption( "addr" );
    QCString uidStr = args->getOption( "uid" );
    QString addr;
    QString uid;
    if ( !addrStr.isEmpty() )
      addr = QString::fromLocal8Bit( addrStr );
    if ( !uidStr.isEmpty() )
      uid = QString::fromLocal8Bit( uidStr );


    if ( args->isSet( "editor-only" ) ) {
      if ( !mMainWin )
        mMainWin = new KAddressBookMain;
        KStartupInfo::appStarted();
        mMainWin->hide();
    } else {
      if ( mMainWin ) {
        mMainWin->show();
        KWin::setActiveWindow( mMainWin->winId() );
      } else {
        mMainWin = new KAddressBookMain;
        mMainWin->show();
      }
    }
    // Can not see why anyone would pass both a uid and an email address, so I'll leave it that two contact editors will show if they do
    if ( !addr.isEmpty() )
      mMainWin->addEmail( addr );

    if ( !uid.isEmpty() )
      mMainWin->showContactEditor( uid );
    if ( args->isSet( "new-contact" ) ) {
      mMainWin->newContact();
    }
  }

  KCrash::setEmergencySaveFunction( crashHandler );

  return 0;
}

// the dummy argument is required, because KMail apparently sends an empty
// argument.
static KCmdLineOptions kmoptions[] =
{
  { "a", 0 , 0 },
  { "addr <email>", I18N_NOOP( "Shows contact editor with given email address" ), 0 },
  { "uid <uid>", I18N_NOOP( "Shows contact editor with given uid" ), 0 },
  { "editor-only", I18N_NOOP( "Launches in editor only mode" ), 0 },
  { "new-contact", I18N_NOOP( "Launches editor for the new contact" ), 0 },
  { "+[argument]", I18N_NOOP( "dummy argument" ), 0},
  { 0, 0, 0}
};

int main( int argc, char *argv[] )
{
  KLocale::setMainCatalogue( "kaddressbook" );

  KCmdLineArgs::init( argc, argv, KABCore::createAboutData() );
  KCmdLineArgs::addCmdLineOptions( kmoptions );
  KUniqueApplication::addCmdLineOptions();

  if ( !KAddressBookApp::start() )
    exit( 0 );

  KAddressBookApp app;
  KGlobal::locale()->insertCatalogue( "libkdepim" );

  return app.exec();
}
*/
