
// CHANGED 2004-08-06 Lutz Rogowski
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h>
#include <qlistview.h>
#include <qaction.h>

#include <qtoolbar.h>
#ifdef DESKTOP_VERSION
#include <qmenubar.h>
#else
#include <qpe/qpemenubar.h>
#endif

#include "accountview.h"
#include "statuswidget.h"

#include <libmailwrapper/mailtypes.h>
#include <opie2/osmartpointer.h>

class RecMail;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow( QWidget *parent = 0, const char *name = 0, WFlags flags = 0 );
    virtual ~MainWindow();

public slots:
    virtual void slotAdjustColumns();
    virtual void appMessage(const QCString &msg, const QByteArray &data);
    virtual void slotComposeMail();

protected slots:
    virtual void slotSendQueued();
    virtual void slotEditAccounts();
    virtual void slotShowFolders( bool show );
    virtual void refreshMailView(const QValueList<RecMailP>&);
    virtual void displayMail();
    virtual void slotGetMail() = 0;
    virtual void slotDeleteMail();
    virtual void mailHold(int, QListViewItem *,const QPoint&,int);
    virtual void slotAdjustLayout();
    virtual void slotEditSettings();
    virtual void mailLeftClicked( QListViewItem * );
    void showLicence();
    void showAbout();
    void showEtpanLicence(); 

protected:
    QToolBar *toolBar;
    StatusWidget *statusWidget;
    QPEMenuBar *menuBar;
    QPopupMenu *mailMenu, *settingsMenu;
    QAction *composeMail, *sendQueued, *showFolders, *searchMails, *deleteMails,
            *editSettings, *editAccounts, *syncFolders;
    AccountView *folderView;
    QListView *mailView;
    //QBoxLayout *layout;
};

#endif
