/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <klocale.h>

#include <libkcal/event.h>
#include <qpushbutton.h>

#include "koeventviewer.h"
#include "koprefs.h"
#include <libkcal/todo.h>
#include "qapp.h"

#include "koeventviewerdialog.h"
extern int globalFlagBlockAgenda;

KOEventViewerDialog::KOEventViewerDialog(QWidget *parent,const char *name)
  : KDialogBase(parent,name,
#ifndef DESKTOP_VERSION
                true ,
#else
                false,
#endif
                i18n("Event Viewer"),Ok|User1|Close,Close, false,  i18n("Agenda"))
{

  mEventViewer = new KOEventViewer(this);
  mEventViewer->setFont( KOPrefs::instance()->mEventViewFont );
  setMainWidget(mEventViewer);
  setButtonText(Ok, i18n("Edit") );

 QObject::connect(findButton( Ok ),SIGNAL(clicked()),
                   SLOT(editIncidence())); 
 QObject::connect(this,SIGNAL(user1Clicked()),
                   SLOT(showIncidence())); 
 mIncidence = 0;
  // TODO: Set a sensible size (based on the content?).
  //showMaximized();
  //qDebug("++++++++++++KOEventViewerDialog() ");
 //  if ( KOPrefs::instance()->mCompactDialogs ) {
//     setFixedSize( 240,284 );
//     move( 0, 15 );
//   } else {
//     setMinimumSize(300,200);
//     resize(320,300);
//   }
 mSyncMode = false;
 mSyncResult = 0;

}

KOEventViewerDialog::~KOEventViewerDialog()
{
    //qDebug("-------~KOEventViewerDialog() ");
}
void KOEventViewerDialog::showMe()
{
 
#ifdef DESKTOP_VERSION
    show();
#else
    showMaximized();
#endif
    setFocus();
    setActiveWindow();

}
void KOEventViewerDialog::setSyncMode( bool b )
{
  mSyncMode = b;
  //qDebug("KOEventViewerDialog::setSyncMode %d ",mSyncMode );
  if ( mSyncMode ) {
    findButton( Close )->setText( i18n("Cancel Sync"));
    findButton( Ok )->setText( i18n("Remote"));
    findButton( User1 )->setText( i18n("Local"));
  } else {
    findButton( Close )->setText( i18n("Close"));
    findButton( Ok )->setText( i18n("Edit"));
    findButton( User1 )->setText( i18n("Agenda"));
  }
  mEventViewer->setSyncMode( b );
}
void KOEventViewerDialog::setColorMode( int m )
{
    mEventViewer->setColorMode( m );
}
int KOEventViewerDialog::executeS( bool local )
{
    mSyncResult = 3; 
    if ( local ) 
        findButton( User1 )->setFocus();
    else 
        findButton( Ok )->setFocus();
    exec();
    return mSyncResult;
}

void KOEventViewerDialog::updateConfig()
{
  mEventViewer->setFont( KOPrefs::instance()->mEventViewFont );

}
void KOEventViewerDialog::setEvent(Event *event)
{
  mEventViewer->setEvent(event);
  mIncidence = event;
  findButton( Close )->setFocus();
}
void KOEventViewerDialog::setIncidence(Incidence *in )
{
    if ( in->type() == "Event" )
        setEvent( (Event*) in );
    else if ( in->type() =="Todo" )
        setTodo( (Todo*) in );
    else if ( in->type() =="Journal" )
        setJournal( (Journal*) in );
}
void KOEventViewerDialog::addIncidence(Incidence *in)
{
    if ( in->type() == "Event" )
        addEvent( (Event*) in );
    else if ( in->type() =="Todo" )
         mEventViewer->setTodo( (Todo*) in, false );
    else if ( in->type() =="Journal" )
         mEventViewer->setJournal( (Journal*) in, false );
  if ( mSyncMode ) {
      findButton( User1 )->setFocus();
      setCaption(i18n("Conflict! Please choose entry"));
  }   
}

void KOEventViewerDialog::addEvent(Event *event)
{ 
  mEventViewer->addEvent(event);
  mIncidence = event; 
  findButton( Close )->setFocus();
}

void KOEventViewerDialog::setTodo(Todo *event)
{
  mEventViewer->setTodo(event);
  mIncidence = (Incidence*)event;
  findButton( Close )->setFocus();
}
void KOEventViewerDialog::setJournal(Journal *j)
{
  mEventViewer->setJournal(j);
  mIncidence = (Incidence*)j;
  findButton( Close )->setFocus();
}

void KOEventViewerDialog::addText(QString text)
{
  mEventViewer->addText(text);
  findButton( Close )->setFocus();
}
void KOEventViewerDialog::editIncidence()
{   
    if ( mSyncMode ) {
        mSyncResult = 2;
        accept();
        return;
    }
    if ( mIncidence ){
#ifndef DESKTOP_VERSION
        hide();
#endif
        emit editIncidence( mIncidence );
    }
}
void KOEventViewerDialog::showIncidence()
{

    if ( mSyncMode ) {
        mSyncResult = 1;
        accept();
        return;
    }

    if ( mIncidence ){
#ifndef DESKTOP_VERSION
        hide();
#endif
        QDate date;
        if ( mIncidence->type() == "Todo" ) {
            if ( ((Todo*)mIncidence)->hasDueDate() )
                date = ((Todo*)mIncidence)->dtDue().date();
            else {
                globalFlagBlockAgenda = 2;
                emit showAgendaView( false );
                return;
            }
        } else
            date = mIncidence->dtStart().date();
        globalFlagBlockAgenda = 1;
        emit showAgendaView( false );
        globalFlagBlockAgenda = 2;
        emit jumpToTime( date );
    }
}
void KOEventViewerDialog::keyPressEvent ( QKeyEvent * e ) 
{
    switch ( e->key() ) {
   
    case Qt::Key_A :
    case Qt::Key_L :
        showIncidence();
        break;
    case Qt::Key_E :
    case Qt::Key_R :
        editIncidence();
        break;
    case Qt::Key_C:
    case Qt::Key_Escape:
        close();
        break; 
    case Qt::Key_I:
        accept();
        break; 
    default:
        break; 
    }
    
}
