

#ifndef DESKTOP_VERSION
#include <qpe/qpeapplication.h>
#include <qpe/global.h>
#include <stdlib.h>
#else
#include <qapplication.h>
#include <qstring.h>
#include <qwindowsstyle.h> 
#include <qplatinumstyle.h> 
#include <qsgistyle.h> 
#endif

#include <qdir.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <stdio.h>
#include "mainwindow.h"

int main( int argc, char **argv )
{
#ifndef DESKTOP_VERSION
  QPEApplication a( argc, argv );
  a.setKeepRunning ();
#else
  QApplication a( argc, argv ); 
  QApplication::setStyle( new QPlatinumStyle ());
  QString hdir = QDir::homeDirPath();
  // there is a bug when creating dirs for WIN 98
  // it is difficult to fix, because we have no WIN 98 runnung
  // such that we try it to create the dirs at startup here
  if ( hdir == "C:\\" ) { // win 98 or ME
       QDir app_dir;
       if ( !app_dir.exists("C:\\kdepim") )
           app_dir.mkdir ("C:\\kdepim");
       if ( !app_dir.exists("C:\\kdepim\\apps") )
           app_dir.mkdir ("C:\\kdepim\\apps");
       if ( !app_dir.exists("C:\\kdepim\\config") )
           app_dir.mkdir ("C:\\kdepim\\config");
       if ( !app_dir.exists("C:\\kdepim\\apps\\korganizer") )
           app_dir.mkdir ("C:\\kdepim\\apps\\korganizer");
  }
#endif
  bool exitHelp = false;
  if ( argc > 1 ) {
      QString command = argv[1];
      if (  command == "-help" ){
          printf("KO/Pi command line commands:\n");
          printf("  no command: Start KO/Pi in usual way\n");
          printf("  -help: This output\n");
          printf("Next Option: Open or Show after start:\n");
          printf("  -newTodo: New Todo dialog\n");
          printf("  -newEvent: New Event dialog\n");
          printf("  -showList: List view\n");
          printf("  -showDay: Day view\n");
          printf("  -showWWeek: Work Week view\n");
          printf("  -showWeek: Week view\n");
          printf("  -showTodo: Todo view\n");
          printf("  -showJournal: Journal view\n");
          printf("  -showKO: Next Days view\n");
          printf("  -showWNext: What's Next view\n");  
          printf("  -showNextXView: Next X View\n");
          printf(" -new[Y] and -show[X] may be used togehther\n");
          printf(" KO/Pi is exiting now. Bye!\n");
          exitHelp = true;
      }
  }
  if ( ! exitHelp ) {
      KGlobal::setAppName( "korganizer" );
      QString fileName ;
#ifndef DESKTOP_VERSION
      fileName = getenv("QPEDIR");
      KGlobal::iconLoader()->setIconPath( fileName +"/pics/kdepim/korganizer/");
#else
      fileName  = qApp->applicationDirPath () + "/kdepim/korganizer/";
      KGlobal::iconLoader()->setIconPath(QDir::convertSeparators(fileName));
#endif 
      KStandardDirs::setAppDir( QDir::convertSeparators(locateLocal("data", "korganizer")));
      MainWindow m;
#ifndef DESKTOP_VERSION
      QObject::connect( &a, SIGNAL (appMessage ( const QCString &, const QByteArray & )),&m, SLOT(recieve(  const QCString&, const QByteArray& )));
      a.showMainWidget(&m );
#else
      a.setMainWidget(&m );
      m.show();
      //m.resize( 800, 600 );
      QObject::connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
#endif
      if ( argc > 1 ) {
          QCString command = argv[1];
          if ( argc > 2 )
              command += argv[2];
          qApp->processEvents();
          m.recieve(command,  QByteArray() );
          
      }
      a.exec();

  }
  qDebug("KO: Bye! ");
}
