#include "kincidenceformatter.h"
#include <kstaticdeleter.h>
#include <kglobal.h>
#include <klocale.h>
#ifndef KORG_NOKABC
#include <kabc/stdaddressbook.h>
#define size count
#endif

KIncidenceFormatter* KIncidenceFormatter::mInstance = 0;
static KStaticDeleter<KIncidenceFormatter> insd;

QString KIncidenceFormatter::getFormattedText( Incidence * inc )
{
// #ifndef QT_NO_INPUTDIALOG
//   return QInputDialog::getItem( caption, label, items, current, editable );
// #else
//   return QString::null;
// #endif
    mText = "";
    if ( inc->type() == "Event" )
        setEvent((Event *) inc );
    else if ( inc->type() == "Todo" )
        setTodo((Todo *) inc );
    return mText;
}

KIncidenceFormatter* KIncidenceFormatter::instance()
{
    if (!mInstance) {
      mInstance = insd.setObject(new KIncidenceFormatter());
  }
  return mInstance;
}
KIncidenceFormatter::~KIncidenceFormatter()
{
 if (mInstance == this)
      mInstance = insd.setObject(0); 
 //qDebug("KIncidenceFormatter::~KIncidenceFormatter ");
}
KIncidenceFormatter::KIncidenceFormatter()
{
    mColorMode = 0;
}
void KIncidenceFormatter::setEvent(Event *event)
{
    int mode = 0;
    mCurrentIncidence = event;
    bool shortDate = true;
    if ( mode == 0 ) {
        addTag("h3",event->summary());
    }
    else {
        if ( mColorMode == 1 ) {
            mText +="<font color=\"#00A000\">";
        }
        if ( mColorMode == 2 ) {
            mText +="<font color=\"#C00000\">";
        }
        // mText +="<font color=\"#F00000\">" + i18n("O-due!") + "</font>";
        if ( mode == 1 ) {
            addTag("h2",i18n( "Local: " ) +event->summary());
        } else {
            addTag("h2",i18n( "Remote: " ) +event->summary());
        } 
        addTag("h3",i18n( "Last modified: " ) + KGlobal::locale()->formatDateTime(event->lastModified(),shortDate, true ) );
        if ( mColorMode )
            mText += "</font>";
    } 
    if (event->cancelled ()) {
        mText +="<font color=\"#B00000\">";
        addTag("i",i18n("This event has been cancelled!"));
        mText.append("<br>");
        mText += "</font>";
    }
    if (!event->location().isEmpty()) {
        addTag("b",i18n("Location: "));
        mText.append(event->location()+"<br>");
    }
    if (event->doesFloat()) {
        if (event->isMultiDay()) {
            mText.append(i18n("<p><b>From:</b> %1 </p><p><b>To:</b> %2</p>")
                         .arg(event->dtStartDateStr(shortDate))
                         .arg(event->dtEndDateStr(shortDate)));
        } else {
            mText.append(i18n("<p><b>On:</b> %1</p>").arg(event->dtStartDateStr( shortDate )));
        }
    } else {
        if (event->isMultiDay()) {
            mText.append(i18n("<p><b>From:</b> %1</p> ")
                         .arg(event->dtStartStr( shortDate)));
            mText.append(i18n("<p><b>To:</b> %1</p>")
                         .arg(event->dtEndStr(shortDate)));
        } else {
            mText.append(i18n("<p><b>On:</b> %1</p> ")
                         .arg(event->dtStartDateStr( shortDate )));
            mText.append(i18n("<p><b>From:</b> %1 <b>To:</b> %2</p>")
                         .arg(event->dtStartTimeStr())
                         .arg(event->dtEndTimeStr()));
        }
    }

    if (event->recurrence()->doesRecur()) {

        QString recurText = event->recurrence()->recurrenceText();
        addTag("p","<em>" + i18n("This is a %1 recurring event.").arg(recurText ) + "</em>");
        bool last;
        QDate start = QDate::currentDate();
        QDate next;
        next = event->recurrence()->getPreviousDate( start , &last );
        if ( !last ) {
            next = event->recurrence()->getNextDate( start.addDays( - 1 ) );
            addTag("p",i18n("Next recurrence is on: ")+ KGlobal::locale()->formatDate( next, shortDate ) );
            //addTag("p", KGlobal::locale()->formatDate( next, shortDate ));
        } else {
            addTag("p",i18n("<b>Last recurrence was on:</b>")  );
            addTag("p", KGlobal::locale()->formatDate( next, shortDate ));
        }
    }


    if (event->isAlarmEnabled()) {
        Alarm *alarm =event->alarms().first() ;
        QDateTime t = alarm->time();
        int min = t.secsTo( event->dtStart() )/60;
        QString s =i18n("(%1 min before)").arg( min );
        addTag("p",i18n("<b>Alarm on:  </b>")  + s  + ": "+KGlobal::locale()->formatDateTime( t, shortDate ));
        //addTag("p", KGlobal::locale()->formatDateTime( t, shortDate ));
        //addTag("p",s);
    }

    addTag("p",i18n("<b>Access: </b>") +event->secrecyStr() );
    // mText.append(event->secrecyStr()+"<br>");
    formatCategories(event);
    if (!event->description().isEmpty()) {
        addTag("p",i18n("<b>Details: </b>"));
        addTag("p",event->description());
    }


    formatReadOnly(event);
    formatAttendees(event);

 
}

void KIncidenceFormatter::setTodo(Todo *event )
{
    int mode = 0;
    mCurrentIncidence = event;
    bool shortDate = true;
    if (mode == 0 )
        addTag("h3",event->summary());
    else { 
        if ( mColorMode == 1 ) {
            mText +="<font color=\"#00A000\">";
        }
        if ( mColorMode == 2 ) {
            mText +="<font color=\"#B00000\">";
        }
        if ( mode == 1 ) {
            addTag("h2",i18n( "Local: " ) +event->summary());
        } else {
            addTag("h2",i18n( "Remote: " ) +event->summary());
        }
        addTag("h3",i18n( "Last modified: " ) + KGlobal::locale()->formatDateTime(event->lastModified(),shortDate, true ) );
        if ( mColorMode )
            mText += "</font>";
    } 
    if (event->cancelled ()) {
        mText +="<font color=\"#B00000\">";
        addTag("i",i18n("This todo has been cancelled!"));
        mText.append("<br>");
        mText += "</font>";
    }
   
    if (!event->location().isEmpty()) {
        addTag("b",i18n("Location: "));
        mText.append(event->location()+"<br>");
    }
    if (event->hasDueDate()) {
        mText.append(i18n("<p><b>Due on:</b> %1</p>").arg(event->dtDueStr(shortDate)));
    }
    mText.append(i18n("<p><b>Priority:</b> %2</p>")
                 .arg(QString::number(event->priority())));

    mText.append(i18n("<p><i>%1 % completed</i></p>")
                 .arg(event->percentComplete()));
     addTag("p",i18n("<b>Access: </b>") +event->secrecyStr() );
    formatCategories(event);
    if (!event->description().isEmpty()) {
        addTag("p",i18n("<b>Details: </b>"));
        addTag("p",event->description());
    }



    formatReadOnly(event);
    formatAttendees(event);

}

void KIncidenceFormatter::setJournal(Journal*  )
{

}

void KIncidenceFormatter::formatCategories(Incidence *event)
{
 if (!event->categoriesStr().isEmpty()) {
     addTag("p",i18n("<b>Categories: </b>")+event->categoriesStr() );
     //mText.append(event->categoriesStr());
 }
}
void KIncidenceFormatter::addTag(const QString & tag,const QString & text)
{
  int number=text.contains("\n");
    QString str = "<" + tag + ">";
    QString tmpText=text;
    QString tmpStr=str;
    if(number !=-1) 
        {
            if (number > 0) {
                int pos=0;
                QString tmp;
                for(int i=0;i<=number;i++) {
                    pos=tmpText.find("\n");
                    tmp=tmpText.left(pos);
                    tmpText=tmpText.right(tmpText.length()-pos-1);
                    tmpStr+=tmp+"<br>";
                }
            }
            else tmpStr += tmpText;
            tmpStr+="</" + tag + ">";
            mText.append(tmpStr);
        }
    else
        {
            str += text + "</" + tag + ">";
            mText.append(str);
        }
}

void KIncidenceFormatter::formatAttendees(Incidence *event)
{
 QPtrList<Attendee> attendees = event->attendees();
    if (attendees.count()) {
        QString iconPath = KGlobal::iconLoader()->iconPath("mailappt",KIcon::Small);
        addTag("h3",i18n("Organizer"));
        mText.append("<ul><li>");
#if 0
        //ndef KORG_NOKABC
       
        KABC::AddressBook *add_book = KABC::StdAddressBook::self();
        KABC::Addressee::List addressList;
        addressList = add_book->findByEmail(event->organizer());
        KABC::Addressee o = addressList.first();
        if (!o.isEmpty() && addressList.size()<2) {
            mText += "<a href=\"uid:" + o.uid() + "\">";
            mText += o.formattedName();
            mText += "</a>\n";
        } else {
            mText.append(event->organizer());
        }
#else
        mText.append(event->organizer());
#endif
        if (iconPath) {
            mText += " <a href=\"mailto:" + event->organizer() + "\">";
            mText += "<IMG src=\"" + iconPath + "\">";
            mText += "</a>\n";
        }
        mText.append("</li></ul>");

        addTag("h3",i18n("Attendees"));
        Attendee *a;
        mText.append("<ul>");
        for(a=attendees.first();a;a=attendees.next()) {
#if 0
//ndef KORG_NOKABC
            if (a->name().isEmpty()) {
                addressList = add_book->findByEmail(a->email());
                KABC::Addressee o = addressList.first();
                if (!o.isEmpty() && addressList.size()<2) {
                    mText += "<a href=\"uid:" + o.uid() + "\">";
                    mText += o.formattedName();
                    mText += "</a>\n";
                } else {
                    mText += "<li>";
                    mText.append(a->email());
                    mText += "\n";
                }
            } else {
                mText += "<li><a href=\"uid:" + a->uid() + "\">";
                if (!a->name().isEmpty()) mText += a->name();
                else mText += a->email();
                mText += "</a>\n";
            }
#else
            //qDebug("nokabc ");
            mText += "<li><a href=\"uid:" + a->uid() + "\">";
            if (!a->name().isEmpty()) mText += a->name();
            else mText += a->email();
            mText += "</a>\n";
#endif

            if (!a->email().isEmpty()) {
                if (iconPath) {
                    mText += "<a href=\"mailto:" + a->name() +" "+ "<" + a->email() + ">" + "\">";
                    mText += "<IMG src=\"" + iconPath + "\">";
                    mText += "</a>\n";
                }
            }
            if (a->status() != Attendee::NeedsAction )
                mText +="[" + a->statusStr() + "] ";
            if (a->role() == Attendee::Chair )
                mText +="(" + a->roleStr().left(1) + ".)";
        }
        mText.append("</li></ul>");
    }
}

void KIncidenceFormatter::formatReadOnly(Incidence *event)
{
 if (event->isReadOnly()) {
        addTag("p","<em>(" + i18n("read-only") + ")</em>");
    }
}
