/*
    This file is part of libkresources.

    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KRESOURCES_KCMKRESOURCES_H
#define KRESOURCES_KCMKRESOURCES_H

#include <kdialogbase.h>

namespace KRES {

class ConfigPage;


//US class KCMKResources : public KCModule
class KCMKResources : public KDialogBase
{
  Q_OBJECT

  public:
    KCMKResources( QWidget *parent, const char *name, const QStringList& );

    void load();
    void save();
    void defaults();
        
  protected slots:
    virtual void slotOk();
    void changed( bool );
    
  private:
    KRES::ConfigPage *mConfigPage;
    bool modified;
};

}
#endif
