/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2004,2005 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kglobal_h__
#define __kglobal_h__

#include <qstring.h>

#include <kinstance.h>
#include <kapplication.h>

// ### compat
#include <sys/stat.h>

// ### hack
#include <kfontdatabase.h>

#include <kdeversion.h>

#if KDE_IS_VERSION(3,3,80)
#include "kdelibs_export.h"
#endif

class KStringDict;
class KLocale;
class KStandardDirs;
class KCharsets;
class KConfig;


/**
 * A typesafe function to find the minimum of the two arguments.
 */
#define KMIN(a,b)	kMin(a,b)

/**
 * A typesafe function to find the maximum of the two arguments.
 */
#define KMAX(a,b)	kMax(a,b)

/**
 * \relates KGlobal
 * A typesafe function that returns x if it's between low and high values.
 * low if x is smaller than then low and high if x is bigger than high.
 */
#define KCLAMP(x,low,high) kClamp(x,low,high)

// XXX KDE4: Make kMin, kMax and kClamp return "T" instead of "const T &"!
template<class T>
inline const T& kMin (const T& a, const T& b) { return a < b ? a : b; }

template<class T>
inline const T& kMax (const T& a, const T& b) { return b < a ? a : b; }

template<class T>
inline T kAbs (const T& a) { return a < 0 ? -a : a; }

template<class T>
inline const T& kClamp( const T& x, const T& low, const T& high )
{
    if ( x < low )       return low;
    else if ( high < x ) return high;
    else                 return x;
}

class KGlobal
{
public:

    static const QString &staticQString( const char * );
    static const QString &staticQString( const QString & );

    static KLocale *locale();

    static KStandardDirs *dirs() { return instance()->dirs(); }

    static KConfig *config() { return instance()->config(); }

    static KCharsets *charsets();

    static KInstance *instance() { return kapp; }

    static KIconLoader *iconLoader() { return instance()->iconLoader(); }

    static KInstance *_activeInstance;
    // filled by kapp ctor
    static KInstance *_instance;
private:
    static KStringDict *s_stringDict;
    static KLocale *s_locale;
    static KCharsets *s_charsets;
};

#endif
