/*  This file is part of the KDE project
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __mainwindow_tv_h__
#define __mainwindow_tv_h__

#include <config.h>

#if defined(KONQ_GUI_TV)

#include <qdialog.h>

#include "mainwindowbase.h"

class QHBox;
class QLabel;

class StatusDialog : public QDialog
{
    Q_OBJECT
public:
    StatusDialog(QWidget *parent = 0);
    ~StatusDialog();
    
    void setMessage(const QString &msg);
    void enterEvent(QEvent *);
private:
    QHBox *box;
    QLabel *label;
};

class MainWindowTv : public MainWindowBase
{
    Q_OBJECT
public:
    MainWindowTv();

protected slots:
    virtual void popupMenu( const QString &url, const QPoint & );

    virtual void statusJustText( const QString &msg, bool visible );

    virtual void statusMessage( const QString &msg, bool visible );

protected:
    virtual BrowserView *createNewViewInternal( const KURL &url, 
		    const KParts::URLArgs &args, bool withStatus = true );

    virtual void initGUI();
private:
    StatusDialog *statusDialog;
};

#endif

#endif // __mainwindow_tv_h__
