/*
 *  linux/include/asm-arm/arch-lh79520/uncompress.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define UART_DR	(*(volatile unsigned char *)0xfffc1000)
#define UART_FR	(*(volatile unsigned short *)0xfffc1018)

#define UARTFR_TXFE	0x80

/*
 * This does not append a newline
 */
static void
puts( const char *s)
{
	while( *s) {
		while( (UART_FR & UARTFR_TXFE) == 0)		/* wait for room in the tx FIFO */
			;

		UART_DR = *s;							/* ship a char */

		if (*s == '\n') {						/* it's a new line */
			while( (UART_FR & UARTFR_TXFE) == 0)	/* wait for room in the tx FIFO */
				;

			UART_DR = '\r';						/* ship a carriage return		*/
		}
		s++;
	}
}

/*
 * nothing to do
 */
#define arch_decomp_setup()
#define arch_decomp_wdog()
