require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_BIOSVAR_H_)) {
    eval 'sub _MACHINE_BIOSVAR_H_ () {1;}' unless defined(&_MACHINE_BIOSVAR_H_);
    eval 'sub BOOTARG_OFF () {( &PAGE_SIZE * 2);}' unless defined(&BOOTARG_OFF);
    eval 'sub BOOTARG_LEN () {( &PAGE_SIZE * 1);}' unless defined(&BOOTARG_LEN);
    eval 'sub BOOTBIOS_ADDR () {(0x7c00);}' unless defined(&BOOTBIOS_ADDR);
    eval 'sub BOOTBIOS_MAXSEC () {((1<< 28) - 1);}' unless defined(&BOOTBIOS_MAXSEC);
    eval 'sub BIOSF_BIOS32 () {0x1;}' unless defined(&BIOSF_BIOS32);
    eval 'sub BIOSF_PCIBIOS () {0x2;}' unless defined(&BIOSF_PCIBIOS);
    eval 'sub BIOSF_PROMSCAN () {0x4;}' unless defined(&BIOSF_PROMSCAN);
    eval 'sub BIOSF_SMBIOS () {0x6;}' unless defined(&BIOSF_SMBIOS);
    eval 'sub BIOSM_F320K () {0xff;}' unless defined(&BIOSM_F320K);
    eval 'sub BIOSM_F160K () {0xfe;}' unless defined(&BIOSM_F160K);
    eval 'sub BIOSM_F360K () {0xfd;}' unless defined(&BIOSM_F360K);
    eval 'sub BIOSM_F180K () {0xfc;}' unless defined(&BIOSM_F180K);
    eval 'sub BIOSM_ROMD () {0xfa;}' unless defined(&BIOSM_ROMD);
    eval 'sub BIOSM_F120M () {0xf9;}' unless defined(&BIOSM_F120M);
    eval 'sub BIOSM_F720K () {0xf9;}' unless defined(&BIOSM_F720K);
    eval 'sub BIOSM_HD () {0xf8;}' unless defined(&BIOSM_HD);
    eval 'sub BIOSM_F144K () {0xf0;}' unless defined(&BIOSM_F144K);
    eval 'sub BIOSM_OTHER () {0xf0;}' unless defined(&BIOSM_OTHER);
    eval 'sub BIOS_MAP_END () {0x;}' unless defined(&BIOS_MAP_END);
    eval 'sub BIOS_MAP_FREE () {0x1;}' unless defined(&BIOS_MAP_FREE);
    eval 'sub BIOS_MAP_RES () {0x2;}' unless defined(&BIOS_MAP_RES);
    eval 'sub BIOS_MAP_ACPI () {0x3;}' unless defined(&BIOS_MAP_ACPI);
    eval 'sub BIOS_MAP_NVS () {0x4;}' unless defined(&BIOS_MAP_NVS);
    eval 'sub BIOS32_MAKESIG {
        my($a, $b, $c, $d) = @_;
	    eval q((($a) | (($b) << 8) | (($c) << 16) | (($d) << 24)));
    }' unless defined(&BIOS32_MAKESIG);
    eval 'sub SMBIOS_SIGNATURE () { &BIOS32_MAKESIG(ord(\'_\', \'S\', \'M\', \'_\'));}' unless defined(&SMBIOS_SIGNATURE);
    eval 'sub BIOS_DEV () {1;}' unless defined(&BIOS_DEV);
    eval 'sub BIOS_DISKINFO () {2;}' unless defined(&BIOS_DISKINFO);
    eval 'sub BIOS_CKSUMLEN () {3;}' unless defined(&BIOS_CKSUMLEN);
    eval 'sub BIOS_MAXID () {4;}' unless defined(&BIOS_MAXID);
    eval 'sub CTL_BIOS_NAMES () {{ { 0, 0}, { "biosdev",  &CTLTYPE_INT }, { "diskinfo",  &CTLTYPE_STRUCT }, { "cksumlen",  &CTLTYPE_INT }, };}' unless defined(&CTL_BIOS_NAMES);
    eval 'sub BOOTARG_MEMMAP () {0;}' unless defined(&BOOTARG_MEMMAP);
    eval 'sub BOOTARG_DISKINFO () {1;}' unless defined(&BOOTARG_DISKINFO);
    eval 'sub BDI_INVALID () {0x1;}' unless defined(&BDI_INVALID);
    eval 'sub BDI_GOODLABEL () {0x2;}' unless defined(&BDI_GOODLABEL);
    eval 'sub BDI_BADLABEL () {0x4;}' unless defined(&BDI_BADLABEL);
    eval 'sub BDI_EL_TORITO () {0x8;}' unless defined(&BDI_EL_TORITO);
    eval 'sub BDI_PICKED () {0x80000000;}' unless defined(&BDI_PICKED);
    eval 'sub BOOTARG_APMINFO () {2;}' unless defined(&BOOTARG_APMINFO);
    eval 'sub BOOTARG_CKSUMLEN () {3;}' unless defined(&BOOTARG_CKSUMLEN);
    eval 'sub BOOTARG_PCIINFO () {4;}' unless defined(&BOOTARG_PCIINFO);
    eval 'sub BOOTARG_CONSDEV () {5;}' unless defined(&BOOTARG_CONSDEV);
    eval 'sub BOOTARG_BOOTMAC () {7;}' unless defined(&BOOTARG_BOOTMAC);
    eval 'sub BOOTARG_DDB () {8;}' unless defined(&BOOTARG_DDB);
    eval 'sub BOOTARG_BOOTDUID () {9;}' unless defined(&BOOTARG_BOOTDUID);
    eval 'sub BOOTARG_BOOTSR () {10;}' unless defined(&BOOTARG_BOOTSR);
    eval 'sub BOOTSR_UUID_MAX () {16;}' unless defined(&BOOTSR_UUID_MAX);
    eval 'sub BOOTSR_CRYPTO_MAXKEYBYTES () {32;}' unless defined(&BOOTSR_CRYPTO_MAXKEYBYTES);
    eval 'sub BOOTARG_EFIINFO () {11;}' unless defined(&BOOTARG_EFIINFO);
    if(defined(&_KERNEL) || defined (&_STANDALONE)) {
	if(defined(&_LOCORE)) {
	    eval 'sub DOINT {
	        my($n) = @_;
    		eval q(\'int\' $0x20+($n));
	    }' unless defined(&DOINT);
	} else {
	    eval 'sub DOINT {
	        my($n) = @_;
    		eval q(\\"int $0x20+(\\" $n \\")\\");
	    }' unless defined(&DOINT);
	    if(defined(&_KERNEL)) {
		require 'machine/bus.ph';
		eval 'sub ba_apmp () { ($_->{_ba_apmp});}' unless defined(&ba_apmp);
		eval 'sub ba_acpipbase () { ($_->{_ba_acpipbase});}' unless defined(&ba_acpipbase);
	    }
	}
    }
}
1;
