require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_BIT_TWIDDLE)) {
    eval 'sub _BIT_TWIDDLE () {1;}' unless defined(&_BIT_TWIDDLE);
    eval 'sub LOWEST_SET_BIT {
        my($x) = @_;
	    eval q((((($x) - 1) & ($x)) ^ ($x)));
    }' unless defined(&LOWEST_SET_BIT);
    eval 'sub GTEQ_POWER {
        my($x, $p) = @_;
	    eval q(((($x) >> ($p)) != 0));
    }' unless defined(&GTEQ_POWER);
    eval 'sub MASK_TO_SHIFT2 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 1) ? 1: 0));
    }' unless defined(&MASK_TO_SHIFT2);
    eval 'sub MASK_TO_SHIFT4 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 2) ? 2+  &MASK_TO_SHIFT2(($m) >> 2) :  &MASK_TO_SHIFT2(($m))));
    }' unless defined(&MASK_TO_SHIFT4);
    eval 'sub MASK_TO_SHIFT8 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 4) ? 4+  &MASK_TO_SHIFT4(($m) >> 4) :  &MASK_TO_SHIFT4(($m))));
    }' unless defined(&MASK_TO_SHIFT8);
    eval 'sub MASK_TO_SHIFT16 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 8) ? 8+  &MASK_TO_SHIFT8(($m) >> 8) :  &MASK_TO_SHIFT8(($m))));
    }' unless defined(&MASK_TO_SHIFT16);
    eval 'sub MASK_TO_SHIFT {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 16) ? 16+  &MASK_TO_SHIFT16(($m) >> 16) :  &MASK_TO_SHIFT16(($m))));
    }' unless defined(&MASK_TO_SHIFT);
    eval 'sub MASK_AND_RSHIFT {
        my($x, $mask) = @_;
	    eval q(((($x) & ($mask)) >>  &MASK_TO_SHIFT($mask)));
    }' unless defined(&MASK_AND_RSHIFT);
    eval 'sub LSHIFT {
        my($x, $mask) = @_;
	    eval q((($x) <<  &MASK_TO_SHIFT($mask)));
    }' unless defined(&LSHIFT);
    eval 'sub MASK_AND_REPLACE {
        my($reg, $val, $mask) = @_;
	    eval q((($reg & ~$mask) |  &LSHIFT($val, $mask)));
    }' unless defined(&MASK_AND_REPLACE);
    eval 'sub PRESHIFT {
        my($m) = @_;
	    eval q( &MASK_AND_RSHIFT(($m), ($m)));
    }' unless defined(&PRESHIFT);
}
eval 'sub ATW_PAR () {0x;}' unless defined(&ATW_PAR);
eval 'sub ATW_FRCTL () {0x4;}' unless defined(&ATW_FRCTL);
eval 'sub ATW_TDR () {0x8;}' unless defined(&ATW_TDR);
eval 'sub ATW_WTDP () {0xc;}' unless defined(&ATW_WTDP);
eval 'sub ATW_RDR () {0x10;}' unless defined(&ATW_RDR);
eval 'sub ATW_WRDP () {0x14;}' unless defined(&ATW_WRDP);
eval 'sub ATW_RDB () {0x18;}' unless defined(&ATW_RDB);
eval 'sub ATW_CSR3A () {0x1c;}' unless defined(&ATW_CSR3A);
eval 'sub ATW_C_TDBH () {0x1c;}' unless defined(&ATW_C_TDBH);
eval 'sub ATW_TDBD () {0x20;}' unless defined(&ATW_TDBD);
eval 'sub ATW_TDBP () {0x24;}' unless defined(&ATW_TDBP);
eval 'sub ATW_STSR () {0x28;}' unless defined(&ATW_STSR);
eval 'sub ATW_CSR5A () {0x2c;}' unless defined(&ATW_CSR5A);
eval 'sub ATW_C_TDBB () {0x2c;}' unless defined(&ATW_C_TDBB);
eval 'sub ATW_NAR () {0x30;}' unless defined(&ATW_NAR);
eval 'sub ATW_CSR6A () {0x34;}' unless defined(&ATW_CSR6A);
eval 'sub ATW_IER () {0x38;}' unless defined(&ATW_IER);
eval 'sub ATW_CSR7A () {0x3c;}' unless defined(&ATW_CSR7A);
eval 'sub ATW_LPC () {0x40;}' unless defined(&ATW_LPC);
eval 'sub ATW_TEST1 () {0x44;}' unless defined(&ATW_TEST1);
eval 'sub ATW_SPR () {0x48;}' unless defined(&ATW_SPR);
eval 'sub ATW_TEST0 () {0x4c;}' unless defined(&ATW_TEST0);
eval 'sub ATW_WCSR () {0x50;}' unless defined(&ATW_WCSR);
eval 'sub ATW_WPDR () {0x54;}' unless defined(&ATW_WPDR);
eval 'sub ATW_GPTMR () {0x58;}' unless defined(&ATW_GPTMR);
eval 'sub ATW_GPIO () {0x5c;}' unless defined(&ATW_GPIO);
eval 'sub ATW_BBPCTL () {0x60;}' unless defined(&ATW_BBPCTL);
eval 'sub ATW_SYNCTL () {0x64;}' unless defined(&ATW_SYNCTL);
eval 'sub ATW_PLCPHD () {0x68;}' unless defined(&ATW_PLCPHD);
eval 'sub ATW_MMIWADDR () {0x6c;}' unless defined(&ATW_MMIWADDR);
eval 'sub ATW_MMIRADDR1 () {0x70;}' unless defined(&ATW_MMIRADDR1);
eval 'sub ATW_MMIRADDR2 () {0x74;}' unless defined(&ATW_MMIRADDR2);
eval 'sub ATW_TXBR () {0x78;}' unless defined(&ATW_TXBR);
eval 'sub ATW_CSR15A () {0x7c;}' unless defined(&ATW_CSR15A);
eval 'sub ATW_ALCSTAT () {0x80;}' unless defined(&ATW_ALCSTAT);
eval 'sub ATW_TOFS2 () {0x84;}' unless defined(&ATW_TOFS2);
eval 'sub ATW_CMDR () {0x88;}' unless defined(&ATW_CMDR);
eval 'sub ATW_PCIC () {0x8c;}' unless defined(&ATW_PCIC);
eval 'sub ATW_PMCSR () {0x90;}' unless defined(&ATW_PMCSR);
eval 'sub ATW_PAR0 () {0x94;}' unless defined(&ATW_PAR0);
eval 'sub ATW_PAR1 () {0x98;}' unless defined(&ATW_PAR1);
eval 'sub ATW_MAR0 () {0x9c;}' unless defined(&ATW_MAR0);
eval 'sub ATW_MAR1 () {0xa0;}' unless defined(&ATW_MAR1);
eval 'sub ATW_ATIMDA0 () {0xa4;}' unless defined(&ATW_ATIMDA0);
eval 'sub ATW_ABDA1 () {0xa8;}' unless defined(&ATW_ABDA1);
eval 'sub ATW_BSSID0 () {0xac;}' unless defined(&ATW_BSSID0);
eval 'sub ATW_TXLMT () {0xb0;}' unless defined(&ATW_TXLMT);
eval 'sub ATW_MIBCNT () {0xb4;}' unless defined(&ATW_MIBCNT);
eval 'sub ATW_BCNT () {0xb8;}' unless defined(&ATW_BCNT);
eval 'sub ATW_TSFTH () {0xbc;}' unless defined(&ATW_TSFTH);
eval 'sub ATW_TSC () {0xc0;}' unless defined(&ATW_TSC);
eval 'sub ATW_SYNRF () {0xc4;}' unless defined(&ATW_SYNRF);
eval 'sub ATW_BPLI () {0xc8;}' unless defined(&ATW_BPLI);
eval 'sub ATW_CAP0 () {0xcc;}' unless defined(&ATW_CAP0);
eval 'sub ATW_CAP1 () {0xd0;}' unless defined(&ATW_CAP1);
eval 'sub ATW_RMD () {0xd4;}' unless defined(&ATW_RMD);
eval 'sub ATW_CFPP () {0xd8;}' unless defined(&ATW_CFPP);
eval 'sub ATW_TOFS0 () {0xdc;}' unless defined(&ATW_TOFS0);
eval 'sub ATW_TOFS1 () {0xe0;}' unless defined(&ATW_TOFS1);
eval 'sub ATW_IFST () {0xe4;}' unless defined(&ATW_IFST);
eval 'sub ATW_RSPT () {0xe8;}' unless defined(&ATW_RSPT);
eval 'sub ATW_TSFTL () {0xec;}' unless defined(&ATW_TSFTL);
eval 'sub ATW_WEPCTL () {0xf0;}' unless defined(&ATW_WEPCTL);
eval 'sub ATW_WESK () {0xf4;}' unless defined(&ATW_WESK);
eval 'sub ATW_WEPCNT () {0xf8;}' unless defined(&ATW_WEPCNT);
eval 'sub ATW_MACTEST () {0xfc;}' unless defined(&ATW_MACTEST);
eval 'sub ATW_FER () {0x100;}' unless defined(&ATW_FER);
eval 'sub ATW_FEMR () {0x104;}' unless defined(&ATW_FEMR);
eval 'sub ATW_FPSR () {0x108;}' unless defined(&ATW_FPSR);
eval 'sub ATW_FFER () {0x10c;}' unless defined(&ATW_FFER);
eval 'sub ATW_PAR_MWIE () {(1<<24);}' unless defined(&ATW_PAR_MWIE);
eval 'sub ATW_PAR_MRLE () {(1<<23);}' unless defined(&ATW_PAR_MRLE);
eval 'sub ATW_PAR_MRME () {(1<<21);}' unless defined(&ATW_PAR_MRME);
eval 'sub ATW_PAR_RAP_MASK () {0x60000;}' unless defined(&ATW_PAR_RAP_MASK);
eval 'sub ATW_PAR_CAL_MASK () {0xc000;}' unless defined(&ATW_PAR_CAL_MASK);
eval 'sub ATW_PAR_CAL_PBL () {0x;}' unless defined(&ATW_PAR_CAL_PBL);
eval 'sub ATW_PAR_CAL_8DW () { &LSHIFT(0x1,  &ATW_PAR_CAL_MASK);}' unless defined(&ATW_PAR_CAL_8DW);
eval 'sub ATW_PAR_CAL_16DW () { &LSHIFT(0x2,  &ATW_PAR_CAL_MASK);}' unless defined(&ATW_PAR_CAL_16DW);
eval 'sub ATW_PAR_CAL_32DW () { &LSHIFT(0x3,  &ATW_PAR_CAL_MASK);}' unless defined(&ATW_PAR_CAL_32DW);
eval 'sub ATW_PAR_PBL_MASK () {0x3f00;}' unless defined(&ATW_PAR_PBL_MASK);
eval 'sub ATW_PAR_PBL_UNLIMITED () {0x;}' unless defined(&ATW_PAR_PBL_UNLIMITED);
eval 'sub ATW_PAR_PBL_1DW () { &LSHIFT(0x1,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_1DW);
eval 'sub ATW_PAR_PBL_2DW () { &LSHIFT(0x2,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_2DW);
eval 'sub ATW_PAR_PBL_4DW () { &LSHIFT(0x4,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_4DW);
eval 'sub ATW_PAR_PBL_8DW () { &LSHIFT(0x8,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_8DW);
eval 'sub ATW_PAR_PBL_16DW () { &LSHIFT(0x16,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_16DW);
eval 'sub ATW_PAR_PBL_32DW () { &LSHIFT(0x32,  &ATW_PAR_PBL_MASK);}' unless defined(&ATW_PAR_PBL_32DW);
eval 'sub ATW_PAR_BLE () {(1<<7);}' unless defined(&ATW_PAR_BLE);
eval 'sub ATW_PAR_DSL_MASK () {0x7c;}' unless defined(&ATW_PAR_DSL_MASK);
eval 'sub ATW_PAR_BAR () {(1<<1);}' unless defined(&ATW_PAR_BAR);
eval 'sub ATW_PAR_SWR () {(1<<0);}' unless defined(&ATW_PAR_SWR);
eval 'sub ATW_FRCTL_PWRMGMT () {(1<<31);}' unless defined(&ATW_FRCTL_PWRMGMT);
eval 'sub ATW_FRCTL_VER_MASK () {0x60000000;}' unless defined(&ATW_FRCTL_VER_MASK);
eval 'sub ATW_FRCTL_ORDER () {(1<<28);}' unless defined(&ATW_FRCTL_ORDER);
eval 'sub ATW_FRCTL_MAXPSP () {(1<<27);}' unless defined(&ATW_FRCTL_MAXPSP);
eval 'sub ATW_C_FRCTL_PRSP () {(1<<26);}' unless defined(&ATW_C_FRCTL_PRSP);
eval 'sub ATW_C_FRCTL_DRVBCON () {(1<<25);}' unless defined(&ATW_C_FRCTL_DRVBCON);
eval 'sub ATW_C_FRCTL_DRVLINKCTRL () {(1<<24);}' unless defined(&ATW_C_FRCTL_DRVLINKCTRL);
eval 'sub ATW_C_FRCTL_DRVLINKON () {(1<<23);}' unless defined(&ATW_C_FRCTL_DRVLINKON);
eval 'sub ATW_C_FRCTL_CTX_DATA () {(1<<22);}' unless defined(&ATW_C_FRCTL_CTX_DATA);
eval 'sub ATW_C_FRCTL_RSVFRM () {(1<<21);}' unless defined(&ATW_C_FRCTL_RSVFRM);
eval 'sub ATW_C_FRCTL_CFEND () {(1<<19);}' unless defined(&ATW_C_FRCTL_CFEND);
eval 'sub ATW_FRCTL_DOZEFRM () {(1<<18);}' unless defined(&ATW_FRCTL_DOZEFRM);
eval 'sub ATW_FRCTL_PSAWAKE () {(1<<17);}' unless defined(&ATW_FRCTL_PSAWAKE);
eval 'sub ATW_FRCTL_PSMODE () {(1<<16);}' unless defined(&ATW_FRCTL_PSMODE);
eval 'sub ATW_FRCTL_AID_MASK () {0xffff;}' unless defined(&ATW_FRCTL_AID_MASK);
eval 'sub ATW_INTR_PCF () {(1<<31);}' unless defined(&ATW_INTR_PCF);
eval 'sub ATW_INTR_BCNTC () {(1<<30);}' unless defined(&ATW_INTR_BCNTC);
eval 'sub ATW_INTR_GPINT () {(1<<29);}' unless defined(&ATW_INTR_GPINT);
eval 'sub ATW_INTR_LINKOFF () {(1<<28);}' unless defined(&ATW_INTR_LINKOFF);
eval 'sub ATW_INTR_ATIMTC () {(1<<27);}' unless defined(&ATW_INTR_ATIMTC);
eval 'sub ATW_INTR_TSFTF () {(1<<26);}' unless defined(&ATW_INTR_TSFTF);
eval 'sub ATW_INTR_TSCZ () {(1<<25);}' unless defined(&ATW_INTR_TSCZ);
eval 'sub ATW_INTR_LINKON () {(1<<24);}' unless defined(&ATW_INTR_LINKON);
eval 'sub ATW_INTR_SQL () {(1<<23);}' unless defined(&ATW_INTR_SQL);
eval 'sub ATW_INTR_WEPTD () {(1<<22);}' unless defined(&ATW_INTR_WEPTD);
eval 'sub ATW_INTR_ATIME () {(1<<21);}' unless defined(&ATW_INTR_ATIME);
eval 'sub ATW_INTR_TBTT () {(1<<20);}' unless defined(&ATW_INTR_TBTT);
eval 'sub ATW_INTR_NISS () {(1<<16);}' unless defined(&ATW_INTR_NISS);
eval 'sub ATW_INTR_AISS () {(1<<15);}' unless defined(&ATW_INTR_AISS);
eval 'sub ATW_INTR_TEIS () {(1<<14);}' unless defined(&ATW_INTR_TEIS);
eval 'sub ATW_INTR_FBE () {(1<<13);}' unless defined(&ATW_INTR_FBE);
eval 'sub ATW_INTR_REIS () {(1<<12);}' unless defined(&ATW_INTR_REIS);
eval 'sub ATW_INTR_GPTT () {(1<<11);}' unless defined(&ATW_INTR_GPTT);
eval 'sub ATW_INTR_RPS () {(1<<8);}' unless defined(&ATW_INTR_RPS);
eval 'sub ATW_INTR_RDU () {(1<<7);}' unless defined(&ATW_INTR_RDU);
eval 'sub ATW_INTR_RCI () {(1<<6);}' unless defined(&ATW_INTR_RCI);
eval 'sub ATW_INTR_TUF () {(1<<5);}' unless defined(&ATW_INTR_TUF);
eval 'sub ATW_INTR_TRT () {(1<<4);}' unless defined(&ATW_INTR_TRT);
eval 'sub ATW_INTR_TLT () {(1<<3);}' unless defined(&ATW_INTR_TLT);
eval 'sub ATW_INTR_TDU () {(1<<2);}' unless defined(&ATW_INTR_TDU);
eval 'sub ATW_INTR_TPS () {(1<<1);}' unless defined(&ATW_INTR_TPS);
eval 'sub ATW_INTR_TCI () {(1<<0);}' unless defined(&ATW_INTR_TCI);
eval 'sub ATW_NAR_TXCF () {(1<<31);}' unless defined(&ATW_NAR_TXCF);
eval 'sub ATW_NAR_HF () {(1<<30);}' unless defined(&ATW_NAR_HF);
eval 'sub ATW_NAR_UTR () {(1<<29);}' unless defined(&ATW_NAR_UTR);
eval 'sub ATW_NAR_PCF () {(1<<28);}' unless defined(&ATW_NAR_PCF);
eval 'sub ATW_NAR_CFP () {(1<<27);}' unless defined(&ATW_NAR_CFP);
eval 'sub ATW_C_NAR_APSTA () {(1<<26);}' unless defined(&ATW_C_NAR_APSTA);
eval 'sub ATW_C_NAR_TDBBE () {(1<<25);}' unless defined(&ATW_C_NAR_TDBBE);
eval 'sub ATW_C_NAR_TDBHE () {(1<<24);}' unless defined(&ATW_C_NAR_TDBHE);
eval 'sub ATW_C_NAR_TDBHT () {(1<<23);}' unless defined(&ATW_C_NAR_TDBHT);
eval 'sub ATW_NAR_SF () {(1<<21);}' unless defined(&ATW_NAR_SF);
eval 'sub ATW_NAR_TR_MASK () {0xc000;}' unless defined(&ATW_NAR_TR_MASK);
eval 'sub ATW_NAR_TR_L64 () { &LSHIFT(0x,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_L64);
eval 'sub ATW_NAR_TR_L160 () { &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_L160);
eval 'sub ATW_NAR_TR_L192 () { &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_L192);
eval 'sub ATW_NAR_TR_H96 () { &LSHIFT(0x,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_H96);
eval 'sub ATW_NAR_TR_H288 () { &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_H288);
eval 'sub ATW_NAR_TR_H544 () { &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}' unless defined(&ATW_NAR_TR_H544);
eval 'sub ATW_NAR_ST () {(1<<13);}' unless defined(&ATW_NAR_ST);
eval 'sub ATW_NAR_OM_MASK () {0xc00;}' unless defined(&ATW_NAR_OM_MASK);
eval 'sub ATW_NAR_OM_NORMAL () {0x;}' unless defined(&ATW_NAR_OM_NORMAL);
eval 'sub ATW_NAR_OM_LOOPBACK () { &LSHIFT(0x1,  &ATW_NAR_OM_MASK);}' unless defined(&ATW_NAR_OM_LOOPBACK);
eval 'sub ATW_NAR_MM () {(1<<7);}' unless defined(&ATW_NAR_MM);
eval 'sub ATW_NAR_PR () {(1<<6);}' unless defined(&ATW_NAR_PR);
eval 'sub ATW_NAR_EA () {(1<<5);}' unless defined(&ATW_NAR_EA);
eval 'sub ATW_NAR_DISPCF () {(1<<4);}' unless defined(&ATW_NAR_DISPCF);
eval 'sub ATW_NAR_PB () {(1<<3);}' unless defined(&ATW_NAR_PB);
eval 'sub ATW_NAR_STPDMA () {(1<<2);}' unless defined(&ATW_NAR_STPDMA);
eval 'sub ATW_NAR_SR () {(1<<1);}' unless defined(&ATW_NAR_SR);
eval 'sub ATW_NAR_CTX () {(1<<0);}' unless defined(&ATW_NAR_CTX);
if(0) {
    eval 'sub ATW_IER_NIE () {(1<<16);}' unless defined(&ATW_IER_NIE);
    eval 'sub ATW_IER_AIE () {(1<<15);}' unless defined(&ATW_IER_AIE);
    eval 'sub ATW_IER_PCFIE () {(1<<31);}' unless defined(&ATW_IER_PCFIE);
    eval 'sub ATW_IER_BCNTCIE () {(1<<30);}' unless defined(&ATW_IER_BCNTCIE);
    eval 'sub ATW_IER_ATIMTCIE () {(1<<27);}' unless defined(&ATW_IER_ATIMTCIE);
    eval 'sub ATW_IER_LINKONIE () {(1<<24);}' unless defined(&ATW_IER_LINKONIE);
    eval 'sub ATW_IER_ATIMIE () {(1<<21);}' unless defined(&ATW_IER_ATIMIE);
    eval 'sub ATW_IER_TBTTIE () {(1<<20);}' unless defined(&ATW_IER_TBTTIE);
    eval 'sub ATW_IER_TEIE () {(1<<14);}' unless defined(&ATW_IER_TEIE);
    eval 'sub ATW_IER_REIE () {(1<<12);}' unless defined(&ATW_IER_REIE);
    eval 'sub ATW_IER_RCIE () {(1<<6);}' unless defined(&ATW_IER_RCIE);
    eval 'sub ATW_IER_TDUIE () {(1<<2);}' unless defined(&ATW_IER_TDUIE);
    eval 'sub ATW_IER_TCIE () {(1<<0);}' unless defined(&ATW_IER_TCIE);
    eval 'sub ATW_IER_GPIE () {(1<<29);}' unless defined(&ATW_IER_GPIE);
    eval 'sub ATW_IER_LINKOFFIE () {(1<<28);}' unless defined(&ATW_IER_LINKOFFIE);
    eval 'sub ATW_IER_TSFTFIE () {(1<<26);}' unless defined(&ATW_IER_TSFTFIE);
    eval 'sub ATW_IER_TSCIE () {(1<<25);}' unless defined(&ATW_IER_TSCIE);
    eval 'sub ATW_IER_SQLIE () {(1<<23);}' unless defined(&ATW_IER_SQLIE);
    eval 'sub ATW_IER_WEPIE () {(1<<22);}' unless defined(&ATW_IER_WEPIE);
    eval 'sub ATW_IER_FBEIE () {(1<<13);}' unless defined(&ATW_IER_FBEIE);
    eval 'sub ATW_IER_GPTIE () {(1<<11);}' unless defined(&ATW_IER_GPTIE);
    eval 'sub ATW_IER_RPSIE () {(1<<8);}' unless defined(&ATW_IER_RPSIE);
    eval 'sub ATW_IER_RUIE () {(1<<7);}' unless defined(&ATW_IER_RUIE);
    eval 'sub ATW_IER_TUIE () {(1<<5);}' unless defined(&ATW_IER_TUIE);
    eval 'sub ATW_IER_TRTIE () {(1<<4);}' unless defined(&ATW_IER_TRTIE);
    eval 'sub ATW_IER_TLTTIE () {(1<<3);}' unless defined(&ATW_IER_TLTTIE);
    eval 'sub ATW_IER_TPSIE () {(1<<1);}' unless defined(&ATW_IER_TPSIE);
}
eval 'sub ATW_LPC_LPCO () {(1<<16);}' unless defined(&ATW_LPC_LPCO);
eval 'sub ATW_LPC_LPC_MASK () {0xffff;}' unless defined(&ATW_LPC_LPC_MASK);
eval 'sub ATW_TEST1_CONTROL () {(1<<31);}' unless defined(&ATW_TEST1_CONTROL);
eval 'sub ATW_TEST1_DBGREAD_MASK () {0x70000000;}' unless defined(&ATW_TEST1_DBGREAD_MASK);
eval 'sub ATW_TEST1_TXWP_MASK () {0xe000000;}' unless defined(&ATW_TEST1_TXWP_MASK);
eval 'sub ATW_TEST1_TXWP_TDBD () { &LSHIFT(0x,  &ATW_TEST1_TXWP_MASK);}' unless defined(&ATW_TEST1_TXWP_TDBD);
eval 'sub ATW_TEST1_TXWP_TDBH () { &LSHIFT(0x1,  &ATW_TEST1_TXWP_MASK);}' unless defined(&ATW_TEST1_TXWP_TDBH);
eval 'sub ATW_TEST1_TXWP_TDBB () { &LSHIFT(0x2,  &ATW_TEST1_TXWP_MASK);}' unless defined(&ATW_TEST1_TXWP_TDBB);
eval 'sub ATW_TEST1_TXWP_TDBP () { &LSHIFT(0x3,  &ATW_TEST1_TXWP_MASK);}' unless defined(&ATW_TEST1_TXWP_TDBP);
eval 'sub ATW_TEST1_RSVD0_MASK () {0x1ffffc0;}' unless defined(&ATW_TEST1_RSVD0_MASK);
eval 'sub ATW_TEST1_TESTMODE_MASK () {0x30;}' unless defined(&ATW_TEST1_TESTMODE_MASK);
eval 'sub ATW_TEST1_TESTMODE_NORMAL () { &LSHIFT(0x,  &ATW_TEST1_TESTMODE_MASK);}' unless defined(&ATW_TEST1_TESTMODE_NORMAL);
eval 'sub ATW_TEST1_TESTMODE_MACONLY () { &LSHIFT(0x1,  &ATW_TEST1_TESTMODE_MASK);}' unless defined(&ATW_TEST1_TESTMODE_MACONLY);
eval 'sub ATW_TEST1_TESTMODE_NORMAL2 () { &LSHIFT(0x2,  &ATW_TEST1_TESTMODE_MASK);}' unless defined(&ATW_TEST1_TESTMODE_NORMAL2);
eval 'sub ATW_TEST1_TESTMODE_MONITOR () { &LSHIFT(0x3,  &ATW_TEST1_TESTMODE_MASK);}' unless defined(&ATW_TEST1_TESTMODE_MONITOR);
eval 'sub ATW_TEST1_DUMP_MASK () {0xf;}' unless defined(&ATW_TEST1_DUMP_MASK);
eval 'sub ATW_SPR_SRS () {(1<<11);}' unless defined(&ATW_SPR_SRS);
eval 'sub ATW_SPR_SDO () {(1<<3);}' unless defined(&ATW_SPR_SDO);
eval 'sub ATW_SPR_SDI () {(1<<2);}' unless defined(&ATW_SPR_SDI);
eval 'sub ATW_SPR_SCLK () {(1<<1);}' unless defined(&ATW_SPR_SCLK);
eval 'sub ATW_SPR_SCS () {(1<<0);}' unless defined(&ATW_SPR_SCS);
eval 'sub ATW_TEST0_BE_MASK () {0xe0000000;}' unless defined(&ATW_TEST0_BE_MASK);
eval 'sub ATW_TEST0_TS_MASK () {0x1c000000;}' unless defined(&ATW_TEST0_TS_MASK);
eval 'sub ATW_TEST0_TS_STOPPED () { &LSHIFT(0,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_STOPPED);
eval 'sub ATW_TEST0_TS_FETCH () { &LSHIFT(1,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_FETCH);
eval 'sub ATW_TEST0_TS_WAIT () { &LSHIFT(2,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_WAIT);
eval 'sub ATW_TEST0_TS_READING () { &LSHIFT(3,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_READING);
eval 'sub ATW_TEST0_TS_RESERVED1 () { &LSHIFT(4,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_RESERVED1);
eval 'sub ATW_TEST0_TS_RESERVED2 () { &LSHIFT(5,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_RESERVED2);
eval 'sub ATW_TEST0_TS_SUSPENDED () { &LSHIFT(6,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_SUSPENDED);
eval 'sub ATW_TEST0_TS_CLOSE () { &LSHIFT(7,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_TEST0_TS_CLOSE);
eval 'sub ATW_C_TEST0_TS_SUSPENDED () { &LSHIFT(4,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_C_TEST0_TS_SUSPENDED);
eval 'sub ATW_C_TEST0_TS_CLOSE () { &LSHIFT(5,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_C_TEST0_TS_CLOSE);
eval 'sub ATW_C_TEST0_TS_CLOSELAST () { &LSHIFT(6,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_C_TEST0_TS_CLOSELAST);
eval 'sub ATW_C_TEST0_TS_FIFOFULL () { &LSHIFT(7,  &ATW_TEST0_TS_MASK);}' unless defined(&ATW_C_TEST0_TS_FIFOFULL);
eval 'sub ATW_TEST0_RS_MASK () {0x3800000;}' unless defined(&ATW_TEST0_RS_MASK);
eval 'sub ATW_TEST0_RS_STOPPED () { &LSHIFT(0,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_STOPPED);
eval 'sub ATW_TEST0_RS_FETCH () { &LSHIFT(1,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_FETCH);
eval 'sub ATW_TEST0_RS_CHECK () { &LSHIFT(2,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_CHECK);
eval 'sub ATW_TEST0_RS_WAIT () { &LSHIFT(3,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_WAIT);
eval 'sub ATW_TEST0_RS_SUSPENDED () { &LSHIFT(4,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_SUSPENDED);
eval 'sub ATW_TEST0_RS_CLOSE () { &LSHIFT(5,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_CLOSE);
eval 'sub ATW_TEST0_RS_FLUSH () { &LSHIFT(6,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_FLUSH);
eval 'sub ATW_TEST0_RS_QUEUE () { &LSHIFT(7,  &ATW_TEST0_RS_MASK);}' unless defined(&ATW_TEST0_RS_QUEUE);
eval 'sub ATW_TEST0_EPNE () {(1<<18);}' unless defined(&ATW_TEST0_EPNE);
eval 'sub ATW_TEST0_EPSNM () {(1<<17);}' unless defined(&ATW_TEST0_EPSNM);
eval 'sub ATW_TEST0_EPTYP_MASK () {(1<<16);}' unless defined(&ATW_TEST0_EPTYP_MASK);
eval 'sub ATW_TEST0_EPTYP_93c66 () { &ATW_TEST0_EPTYP_MASK;}' unless defined(&ATW_TEST0_EPTYP_93c66);
eval 'sub ATW_TEST0_EPTYP_93c46 () {0;}' unless defined(&ATW_TEST0_EPTYP_93c46);
eval 'sub ATW_TEST0_EPRLD () {(1<<15);}' unless defined(&ATW_TEST0_EPRLD);
eval 'sub ATW_WCSR_CRCT () {(1<<30);}' unless defined(&ATW_WCSR_CRCT);
eval 'sub ATW_WCSR_WP1E () {(1<<29);}' unless defined(&ATW_WCSR_WP1E);
eval 'sub ATW_WCSR_WP2E () {(1<<28);}' unless defined(&ATW_WCSR_WP2E);
eval 'sub ATW_WCSR_WP3E () {(1<<27);}' unless defined(&ATW_WCSR_WP3E);
eval 'sub ATW_WCSR_WP4E () {(1<<26);}' unless defined(&ATW_WCSR_WP4E);
eval 'sub ATW_WCSR_WP5E () {(1<<25);}' unless defined(&ATW_WCSR_WP5E);
eval 'sub ATW_WCSR_BLN_MASK () {0xe00000;}' unless defined(&ATW_WCSR_BLN_MASK);
eval 'sub ATW_WCSR_TSFTWE () {(1<<20);}' unless defined(&ATW_WCSR_TSFTWE);
eval 'sub ATW_WCSR_TIMWE () {(1<<19);}' unless defined(&ATW_WCSR_TIMWE);
eval 'sub ATW_WCSR_ATIMWE () {(1<<18);}' unless defined(&ATW_WCSR_ATIMWE);
eval 'sub ATW_WCSR_KEYWE () {(1<<17);}' unless defined(&ATW_WCSR_KEYWE);
eval 'sub ATW_WCSR_WFRE () {(1<<10);}' unless defined(&ATW_WCSR_WFRE);
eval 'sub ATW_WCSR_MPRE () {(1<<9);}' unless defined(&ATW_WCSR_MPRE);
eval 'sub ATW_WCSR_LSOE () {(1<<8);}' unless defined(&ATW_WCSR_LSOE);
eval 'sub ATW_WCSR_KEYUP () {(1<<6);}' unless defined(&ATW_WCSR_KEYUP);
eval 'sub ATW_WCSR_TSFTW () {(1<<5);}' unless defined(&ATW_WCSR_TSFTW);
eval 'sub ATW_WCSR_TIMW () {(1<<4);}' unless defined(&ATW_WCSR_TIMW);
eval 'sub ATW_WCSR_ATIMW () {(1<<3);}' unless defined(&ATW_WCSR_ATIMW);
eval 'sub ATW_WCSR_WFR () {(1<<2);}' unless defined(&ATW_WCSR_WFR);
eval 'sub ATW_WCSR_MPR () {(1<<1);}' unless defined(&ATW_WCSR_MPR);
eval 'sub ATW_WCSR_LSO () {(1<<0);}' unless defined(&ATW_WCSR_LSO);
eval 'sub ATW_GPTMR_COM_MASK () {(1<<16);}' unless defined(&ATW_GPTMR_COM_MASK);
eval 'sub ATW_GPTMR_GTV_MASK () {0xffff;}' unless defined(&ATW_GPTMR_GTV_MASK);
eval 'sub ATW_GPIO_EC1_MASK () {0x3000000;}' unless defined(&ATW_GPIO_EC1_MASK);
eval 'sub ATW_GPIO_LAT_MASK () {0x300000;}' unless defined(&ATW_GPIO_LAT_MASK);
eval 'sub ATW_GPIO_INTEN_MASK () {0xc0000;}' unless defined(&ATW_GPIO_INTEN_MASK);
eval 'sub ATW_GPIO_EN_MASK () {0x3f000;}' unless defined(&ATW_GPIO_EN_MASK);
eval 'sub ATW_GPIO_O_MASK () {0xfc0;}' unless defined(&ATW_GPIO_O_MASK);
eval 'sub ATW_GPIO_I_MASK () {0x3f;}' unless defined(&ATW_GPIO_I_MASK);
eval 'sub ATW_BBPCTL_TWI () {(1<<31);}' unless defined(&ATW_BBPCTL_TWI);
eval 'sub ATW_BBPCTL_RF3KADDR_MASK () {0x7f000000;}' unless defined(&ATW_BBPCTL_RF3KADDR_MASK);
eval 'sub ATW_BBPCTL_RF3KADDR_ADDR () { &LSHIFT(0x20,  &ATW_BBPCTL_RF3KADDR_MASK);}' unless defined(&ATW_BBPCTL_RF3KADDR_ADDR);
eval 'sub ATW_BBPCTL_NEGEDGE_DO () {(1<<23);}' unless defined(&ATW_BBPCTL_NEGEDGE_DO);
eval 'sub ATW_BBPCTL_NEGEDGE_DI () {(1<<22);}' unless defined(&ATW_BBPCTL_NEGEDGE_DI);
eval 'sub ATW_BBPCTL_CCA_ACTLO () {(1<<21);}' unless defined(&ATW_BBPCTL_CCA_ACTLO);
eval 'sub ATW_BBPCTL_TYPE_MASK () {0x1c0000;}' unless defined(&ATW_BBPCTL_TYPE_MASK);
eval 'sub ATW_BBPCTL_WR () {(1<<17);}' unless defined(&ATW_BBPCTL_WR);
eval 'sub ATW_BBPCTL_RD () {(1<<16);}' unless defined(&ATW_BBPCTL_RD);
eval 'sub ATW_BBPCTL_ADDR_MASK () {0xff00;}' unless defined(&ATW_BBPCTL_ADDR_MASK);
eval 'sub ATW_BBPCTL_DATA_MASK () {0xff;}' unless defined(&ATW_BBPCTL_DATA_MASK);
eval 'sub ATW_SYNCTL_WR () {(1<<31);}' unless defined(&ATW_SYNCTL_WR);
eval 'sub ATW_SYNCTL_RD () {(1<<30);}' unless defined(&ATW_SYNCTL_RD);
eval 'sub ATW_SYNCTL_CS0 () {(1<<29);}' unless defined(&ATW_SYNCTL_CS0);
eval 'sub ATW_SYNCTL_CS1 () {(1<<28);}' unless defined(&ATW_SYNCTL_CS1);
eval 'sub ATW_SYNCTL_CAL () {(1<<27);}' unless defined(&ATW_SYNCTL_CAL);
eval 'sub ATW_SYNCTL_SELCAL () {(1<<26);}' unless defined(&ATW_SYNCTL_SELCAL);
eval 'sub ATW_C_SYNCTL_MMICE () {(1<<25);}' unless defined(&ATW_C_SYNCTL_MMICE);
eval 'sub ATW_SYNCTL_RFTYPE_MASK () {0x1c00000;}' unless defined(&ATW_SYNCTL_RFTYPE_MASK);
eval 'sub ATW_SYNCTL_DATA_MASK () {0x3fffff;}' unless defined(&ATW_SYNCTL_DATA_MASK);
eval 'sub ATW_PLCPHD_SIGNAL_MASK () {0xff000000;}' unless defined(&ATW_PLCPHD_SIGNAL_MASK);
eval 'sub ATW_PLCPHD_SERVICE_MASK () {0xff0000;}' unless defined(&ATW_PLCPHD_SERVICE_MASK);
eval 'sub ATW_PLCPHD_PMBL () {(1<<15);}' unless defined(&ATW_PLCPHD_PMBL);
eval 'sub ATW_MMIWADDR_LENLO_MASK () {0xff000000;}' unless defined(&ATW_MMIWADDR_LENLO_MASK);
eval 'sub ATW_MMIWADDR_LENHI_MASK () {0xff0000;}' unless defined(&ATW_MMIWADDR_LENHI_MASK);
eval 'sub ATW_MMIWADDR_GAIN_MASK () {0xff00;}' unless defined(&ATW_MMIWADDR_GAIN_MASK);
eval 'sub ATW_MMIWADDR_RATE_MASK () {0xff;}' unless defined(&ATW_MMIWADDR_RATE_MASK);
eval 'sub ATW_MMIWADDR_INTERSIL () {( &LSHIFT(0xc,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT(0xa,  &ATW_MMIWADDR_RATE_MASK) |  &LSHIFT(0xe,  &ATW_MMIWADDR_LENHI_MASK) |  &LSHIFT(0x10,  &ATW_MMIWADDR_LENLO_MASK));}' unless defined(&ATW_MMIWADDR_INTERSIL);
eval 'sub ATW_MMIWADDR_RFMD () {( &LSHIFT( &RF3000_TWI_AI| &RF3000_GAINCTL,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT( &RF3000_CTL,  &ATW_MMIWADDR_RATE_MASK));}' unless defined(&ATW_MMIWADDR_RFMD);
eval 'sub ATW_MMIRADDR1_RSVD_MASK () {0xff000000;}' unless defined(&ATW_MMIRADDR1_RSVD_MASK);
eval 'sub ATW_MMIRADDR1_PWRLVL_MASK () {0xff0000;}' unless defined(&ATW_MMIRADDR1_PWRLVL_MASK);
eval 'sub ATW_MMIRADDR1_RSSI_MASK () {0xff00;}' unless defined(&ATW_MMIRADDR1_RSSI_MASK);
eval 'sub ATW_MMIRADDR1_RXSTAT_MASK () {0xff;}' unless defined(&ATW_MMIRADDR1_RXSTAT_MASK);
eval 'sub ATW_MMIRADDR1_INTERSIL () {( &LSHIFT(0x7c,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT(0x7e,  &ATW_MMIRADDR1_RXSTAT_MASK));}' unless defined(&ATW_MMIRADDR1_INTERSIL);
eval 'sub ATW_MMIRADDR1_RFMD () {( &LSHIFT( &RF3000_RSSI,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT( &RF3000_RXSTAT,  &ATW_MMIRADDR1_RXSTAT_MASK));}' unless defined(&ATW_MMIRADDR1_RFMD);
eval 'sub ATW_MMIRADDR2_INTERSIL () {( &LSHIFT(0x,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}' unless defined(&ATW_MMIRADDR2_INTERSIL);
eval 'sub ATW_MMIRADDR2_RFMD () {( &LSHIFT(0x7e,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}' unless defined(&ATW_MMIRADDR2_RFMD);
eval 'sub ATW_MMIRADDR2_ID_MASK () {0xff000000;}' unless defined(&ATW_MMIRADDR2_ID_MASK);
eval 'sub ATW_MMIRADDR2_RXPECNT_MASK () {0xff0000;}' unless defined(&ATW_MMIRADDR2_RXPECNT_MASK);
eval 'sub ATW_MMIRADDR2_PROREXT () {(1<<15);}' unless defined(&ATW_MMIRADDR2_PROREXT);
eval 'sub ATW_MMIRADDR2_PRORLEN_MASK () {0x7fff;}' unless defined(&ATW_MMIRADDR2_PRORLEN_MASK);
eval 'sub ATW_TXBR_ALCUPDATE_MASK () {(1<<31);}' unless defined(&ATW_TXBR_ALCUPDATE_MASK);
eval 'sub ATW_TXBR_TBCNT_MASK () {0x1f0000;}' unless defined(&ATW_TXBR_TBCNT_MASK);
eval 'sub ATW_TXBR_ALCSET_MASK () {0xff00;}' unless defined(&ATW_TXBR_ALCSET_MASK);
eval 'sub ATW_TXBR_ALCREF_MASK () {0xff;}' unless defined(&ATW_TXBR_ALCREF_MASK);
eval 'sub ATW_ALCSTAT_MCOV_MASK () {(1<<27);}' unless defined(&ATW_ALCSTAT_MCOV_MASK);
eval 'sub ATW_ALCSTAT_ESOV_MASK () {(1<<26);}' unless defined(&ATW_ALCSTAT_ESOV_MASK);
eval 'sub ATW_ALCSTAT_MCNT_MASK () {0x3ff0000;}' unless defined(&ATW_ALCSTAT_MCNT_MASK);
eval 'sub ATW_ALCSTAT_ERSUM_MASK () {0xffff;}' unless defined(&ATW_ALCSTAT_ERSUM_MASK);
eval 'sub ATW_TOFS2_PWR1UP_MASK () {0xf0000000;}' unless defined(&ATW_TOFS2_PWR1UP_MASK);
eval 'sub ATW_TOFS2_PWR0PAPE_MASK () {0xf000000;}' unless defined(&ATW_TOFS2_PWR0PAPE_MASK);
eval 'sub ATW_TOFS2_PWR1PAPE_MASK () {0xf00000;}' unless defined(&ATW_TOFS2_PWR1PAPE_MASK);
eval 'sub ATW_TOFS2_PWR0TRSW_MASK () {0xf0000;}' unless defined(&ATW_TOFS2_PWR0TRSW_MASK);
eval 'sub ATW_TOFS2_PWR1TRSW_MASK () {0xf000;}' unless defined(&ATW_TOFS2_PWR1TRSW_MASK);
eval 'sub ATW_TOFS2_PWR0PE2_MASK () {0xf00;}' unless defined(&ATW_TOFS2_PWR0PE2_MASK);
eval 'sub ATW_TOFS2_PWR1PE2_MASK () {0xf0;}' unless defined(&ATW_TOFS2_PWR1PE2_MASK);
eval 'sub ATW_TOFS2_PWR0TXPE_MASK () {0xf;}' unless defined(&ATW_TOFS2_PWR0TXPE_MASK);
eval 'sub ATW_CMDR_PM () {(1<<19);}' unless defined(&ATW_CMDR_PM);
eval 'sub ATW_CMDR_APM () {(1<<18);}' unless defined(&ATW_CMDR_APM);
eval 'sub ATW_CMDR_RTE () {(1<<4);}' unless defined(&ATW_CMDR_RTE);
eval 'sub ATW_CMDR_DRT_MASK () {0xc;}' unless defined(&ATW_CMDR_DRT_MASK);
eval 'sub ATW_CMDR_DRT_8DW () { &LSHIFT(0x,  &ATW_CMDR_DRT_MASK);}' unless defined(&ATW_CMDR_DRT_8DW);
eval 'sub ATW_CMDR_DRT_16DW () { &LSHIFT(0x1,  &ATW_CMDR_DRT_MASK);}' unless defined(&ATW_CMDR_DRT_16DW);
eval 'sub ATW_CMDR_DRT_SF () { &LSHIFT(0x2,  &ATW_CMDR_DRT_MASK);}' unless defined(&ATW_CMDR_DRT_SF);
eval 'sub ATW_CMDR_DRT_RSVD () { &LSHIFT(0x3,  &ATW_CMDR_DRT_MASK);}' unless defined(&ATW_CMDR_DRT_RSVD);
eval 'sub ATW_CMDR_SINT_MASK () {(1<<1);}' unless defined(&ATW_CMDR_SINT_MASK);
eval 'sub ATW_PAR0_PAB0_MASK () {0xff;}' unless defined(&ATW_PAR0_PAB0_MASK);
eval 'sub ATW_PAR0_PAB1_MASK () {0xff00;}' unless defined(&ATW_PAR0_PAB1_MASK);
eval 'sub ATW_PAR0_PAB2_MASK () {0xff0000;}' unless defined(&ATW_PAR0_PAB2_MASK);
eval 'sub ATW_PAR0_PAB3_MASK () {0xff000000;}' unless defined(&ATW_PAR0_PAB3_MASK);
eval 'sub ATW_C_PAR1_CTD () {0xffff0000;}' unless defined(&ATW_C_PAR1_CTD);
eval 'sub ATW_PAR1_PAB5_MASK () {0xff00;}' unless defined(&ATW_PAR1_PAB5_MASK);
eval 'sub ATW_PAR1_PAB4_MASK () {0xff;}' unless defined(&ATW_PAR1_PAB4_MASK);
eval 'sub ATW_MAR0_MAB3_MASK () {0xff000000;}' unless defined(&ATW_MAR0_MAB3_MASK);
eval 'sub ATW_MAR0_MAB2_MASK () {0xff0000;}' unless defined(&ATW_MAR0_MAB2_MASK);
eval 'sub ATW_MAR0_MAB1_MASK () {0xff00;}' unless defined(&ATW_MAR0_MAB1_MASK);
eval 'sub ATW_MAR0_MAB0_MASK () {0xff;}' unless defined(&ATW_MAR0_MAB0_MASK);
eval 'sub ATW_MAR1_MAB7_MASK () {0xff000000;}' unless defined(&ATW_MAR1_MAB7_MASK);
eval 'sub ATW_MAR1_MAB6_MASK () {0xff0000;}' unless defined(&ATW_MAR1_MAB6_MASK);
eval 'sub ATW_MAR1_MAB5_MASK () {0xff00;}' unless defined(&ATW_MAR1_MAB5_MASK);
eval 'sub ATW_MAR1_MAB4_MASK () {0xff;}' unless defined(&ATW_MAR1_MAB4_MASK);
eval 'sub ATW_ATIMDA0_ATIMB3_MASK () {0xff000000;}' unless defined(&ATW_ATIMDA0_ATIMB3_MASK);
eval 'sub ATW_ATIMDA0_ATIMB2_MASK () {0xff0000;}' unless defined(&ATW_ATIMDA0_ATIMB2_MASK);
eval 'sub ATW_ATIMDA0_ATIMB1_MASK () {0xff00;}' unless defined(&ATW_ATIMDA0_ATIMB1_MASK);
eval 'sub ATW_ATIMDA0_ATIMB0_MASK () {0xff;}' unless defined(&ATW_ATIMDA0_ATIMB0_MASK);
eval 'sub ATW_ABDA1_BSSIDB5_MASK () {0xff000000;}' unless defined(&ATW_ABDA1_BSSIDB5_MASK);
eval 'sub ATW_ABDA1_BSSIDB4_MASK () {0xff0000;}' unless defined(&ATW_ABDA1_BSSIDB4_MASK);
eval 'sub ATW_ABDA1_ATIMB5_MASK () {0xff00;}' unless defined(&ATW_ABDA1_ATIMB5_MASK);
eval 'sub ATW_ABDA1_ATIMB4_MASK () {0xff;}' unless defined(&ATW_ABDA1_ATIMB4_MASK);
eval 'sub ATW_BSSID0_BSSIDB3_MASK () {0xff000000;}' unless defined(&ATW_BSSID0_BSSIDB3_MASK);
eval 'sub ATW_BSSID0_BSSIDB2_MASK () {0xff0000;}' unless defined(&ATW_BSSID0_BSSIDB2_MASK);
eval 'sub ATW_BSSID0_BSSIDB1_MASK () {0xff00;}' unless defined(&ATW_BSSID0_BSSIDB1_MASK);
eval 'sub ATW_BSSID0_BSSIDB0_MASK () {0xff;}' unless defined(&ATW_BSSID0_BSSIDB0_MASK);
eval 'sub ATW_TXLMT_MTMLT_MASK () {0xffff0000;}' unless defined(&ATW_TXLMT_MTMLT_MASK);
eval 'sub ATW_TXLMT_SRTYLIM_MASK () {0xff;}' unless defined(&ATW_TXLMT_SRTYLIM_MASK);
eval 'sub ATW_MIBCNT_FFCNT_MASK () {0xff000000;}' unless defined(&ATW_MIBCNT_FFCNT_MASK);
eval 'sub ATW_MIBCNT_AFCNT_MASK () {0xff0000;}' unless defined(&ATW_MIBCNT_AFCNT_MASK);
eval 'sub ATW_MIBCNT_RSCNT_MASK () {0xff00;}' unless defined(&ATW_MIBCNT_RSCNT_MASK);
eval 'sub ATW_MIBCNT_RFCNT_MASK () {0xff;}' unless defined(&ATW_MIBCNT_RFCNT_MASK);
eval 'sub ATW_BCNT_PLCPH_MASK () {0xff0000;}' unless defined(&ATW_BCNT_PLCPH_MASK);
eval 'sub ATW_BCNT_PLCPL_MASK () {0xff00;}' unless defined(&ATW_BCNT_PLCPL_MASK);
eval 'sub ATW_BCNT_BCNT_MASK () {0xff;}' unless defined(&ATW_BCNT_BCNT_MASK);
eval 'sub ATW_C_BCNT_EXTEN1 () {(1<<31);}' unless defined(&ATW_C_BCNT_EXTEN1);
eval 'sub ATW_C_BCNT_BEANLEN1 () {0x7fff0000;}' unless defined(&ATW_C_BCNT_BEANLEN1);
eval 'sub ATW_C_BCNT_EXTEN0 () {(1<<15);}' unless defined(&ATW_C_BCNT_EXTEN0);
eval 'sub ATW_C_BCNT_BEANLEN0 () { &BIT(14,0);}' unless defined(&ATW_C_BCNT_BEANLEN0);
eval 'sub ATW_C_TSC_TIMOFS () {0xff000000;}' unless defined(&ATW_C_TSC_TIMOFS);
eval 'sub ATW_C_TSC_TIMLEN () {0x3ff000;}' unless defined(&ATW_C_TSC_TIMLEN);
eval 'sub ATW_C_TSC_TIMTABSEL () {(1<<4);}' unless defined(&ATW_C_TSC_TIMTABSEL);
eval 'sub ATW_TSC_TSC_MASK () {0xf;}' unless defined(&ATW_TSC_TSC_MASK);
eval 'sub ATW_SYNRF_SELSYN () {(1<<31);}' unless defined(&ATW_SYNRF_SELSYN);
eval 'sub ATW_SYNRF_SELRF () {(1<<30);}' unless defined(&ATW_SYNRF_SELRF);
eval 'sub ATW_SYNRF_LERF () {(1<<29);}' unless defined(&ATW_SYNRF_LERF);
eval 'sub ATW_SYNRF_LEIF () {(1<<28);}' unless defined(&ATW_SYNRF_LEIF);
eval 'sub ATW_SYNRF_SYNCLK () {(1<<27);}' unless defined(&ATW_SYNRF_SYNCLK);
eval 'sub ATW_SYNRF_SYNDATA () {(1<<26);}' unless defined(&ATW_SYNRF_SYNDATA);
eval 'sub ATW_SYNRF_PE1 () {(1<<25);}' unless defined(&ATW_SYNRF_PE1);
eval 'sub ATW_SYNRF_PE2 () {(1<<24);}' unless defined(&ATW_SYNRF_PE2);
eval 'sub ATW_SYNRF_PAPE () {(1<<23);}' unless defined(&ATW_SYNRF_PAPE);
eval 'sub ATW_C_SYNRF_TRSW () {(1<<22);}' unless defined(&ATW_C_SYNRF_TRSW);
eval 'sub ATW_C_SYNRF_TRSWN () {(1<<21);}' unless defined(&ATW_C_SYNRF_TRSWN);
eval 'sub ATW_SYNRF_INTERSIL_EN () {(1<<20);}' unless defined(&ATW_SYNRF_INTERSIL_EN);
eval 'sub ATW_SYNRF_PHYRST () {(1<<18);}' unless defined(&ATW_SYNRF_PHYRST);
eval 'sub ATW_C_SYNRF_RF2958PD () { &ATW_SYNRF_PHYRST;}' unless defined(&ATW_C_SYNRF_RF2958PD);
eval 'sub ATW_BPLI_BP_MASK () {0xffff0000;}' unless defined(&ATW_BPLI_BP_MASK);
eval 'sub ATW_BPLI_LI_MASK () {0xffff;}' unless defined(&ATW_BPLI_LI_MASK);
eval 'sub ATW_C_CAP0_TIMLEN1 () {0xff000000;}' unless defined(&ATW_C_CAP0_TIMLEN1);
eval 'sub ATW_C_CAP0_TIMLEN0 () {0xff0000;}' unless defined(&ATW_C_CAP0_TIMLEN0);
eval 'sub ATW_C_CAP0_CWMAX () {0xf00;}' unless defined(&ATW_C_CAP0_CWMAX);
eval 'sub ATW_CAP0_RCVDTIM () {(1<<4);}' unless defined(&ATW_CAP0_RCVDTIM);
eval 'sub ATW_CAP0_CHN_MASK () {0xf;}' unless defined(&ATW_CAP0_CHN_MASK);
eval 'sub ATW_CAP1_CAPI_MASK () {0xffff0000;}' unless defined(&ATW_CAP1_CAPI_MASK);
eval 'sub ATW_CAP1_ATIMW_MASK () {0xffff;}' unless defined(&ATW_CAP1_ATIMW_MASK);
eval 'sub ATW_RMD_ATIMST () {(1<<31);}' unless defined(&ATW_RMD_ATIMST);
eval 'sub ATW_RMD_CFP () {(1<<30);}' unless defined(&ATW_RMD_CFP);
eval 'sub ATW_RMD_PCNT () {0xfff0000;}' unless defined(&ATW_RMD_PCNT);
eval 'sub ATW_RMD_RMRD_MASK () {0xffff;}' unless defined(&ATW_RMD_RMRD_MASK);
eval 'sub ATW_CFPP_CFPP () {0xff000000;}' unless defined(&ATW_CFPP_CFPP);
eval 'sub ATW_CFPP_CFPMD () {0xffff00;}' unless defined(&ATW_CFPP_CFPMD);
eval 'sub ATW_CFPP_DTIMP () {0xff;}' unless defined(&ATW_CFPP_DTIMP);
eval 'sub ATW_TOFS0_USCNT_MASK () {0x3f000000;}' unless defined(&ATW_TOFS0_USCNT_MASK);
eval 'sub ATW_C_TOFS0_TUCNT_MASK () {0x7c00;}' unless defined(&ATW_C_TOFS0_TUCNT_MASK);
eval 'sub ATW_TOFS0_TUCNT_MASK () {0x3ff;}' unless defined(&ATW_TOFS0_TUCNT_MASK);
eval 'sub ATW_TOFS1_TSFTOFSR_MASK () {0xff000000;}' unless defined(&ATW_TOFS1_TSFTOFSR_MASK);
eval 'sub ATW_TOFS1_TBTTPRE_MASK () {0xffff00;}' unless defined(&ATW_TOFS1_TBTTPRE_MASK);
eval 'sub ATW_TBTTPRE_MASK () {0x3fffc00;}' unless defined(&ATW_TBTTPRE_MASK);
eval 'sub ATW_TOFS1_TBTTOFS_MASK () {0xff;}' unless defined(&ATW_TOFS1_TBTTOFS_MASK);
eval 'sub ATW_IFST_SLOT_MASK () {0xf800000;}' unless defined(&ATW_IFST_SLOT_MASK);
eval 'sub ATW_IFST_SIFS_MASK () {0x7f8000;}' unless defined(&ATW_IFST_SIFS_MASK);
eval 'sub ATW_IFST_DIFS_MASK () {0x7e00;}' unless defined(&ATW_IFST_DIFS_MASK);
eval 'sub ATW_IFST_EIFS_MASK () {0x1ff;}' unless defined(&ATW_IFST_EIFS_MASK);
eval 'sub ATW_RSPT_MART_MASK () {0xffff0000;}' unless defined(&ATW_RSPT_MART_MASK);
eval 'sub ATW_RSPT_MIRT_MASK () {0xff00;}' unless defined(&ATW_RSPT_MIRT_MASK);
eval 'sub ATW_RSPT_TSFTOFST_MASK () {0xff;}' unless defined(&ATW_RSPT_TSFTOFST_MASK);
eval 'sub ATW_WEPCTL_WEPENABLE () {(1<<31);}' unless defined(&ATW_WEPCTL_WEPENABLE);
eval 'sub ATW_WEPCTL_AUTOSWITCH () {(1<<30);}' unless defined(&ATW_WEPCTL_AUTOSWITCH);
eval 'sub ATW_WEPCTL_CURTBL () {(1<<29);}' unless defined(&ATW_WEPCTL_CURTBL);
eval 'sub ATW_WEPCTL_WR () {(1<<28);}' unless defined(&ATW_WEPCTL_WR);
eval 'sub ATW_WEPCTL_RD () {(1<<27);}' unless defined(&ATW_WEPCTL_RD);
eval 'sub ATW_WEPCTL_WEPRXBYP () {(1<<25);}' unless defined(&ATW_WEPCTL_WEPRXBYP);
eval 'sub ATW_WEPCTL_SHKEY () {(1<<24);}' unless defined(&ATW_WEPCTL_SHKEY);
eval 'sub ATW_WEPCTL_UNKNOWN0 () {(1<<23);}' unless defined(&ATW_WEPCTL_UNKNOWN0);
eval 'sub ATW_WEPCTL_TBLADD_MASK () {0x1ff;}' unless defined(&ATW_WEPCTL_TBLADD_MASK);
eval 'sub ATW_WEP_ENABLED () {(1<<7);}' unless defined(&ATW_WEP_ENABLED);
eval 'sub ATW_WEP_104BIT () {(1<<6);}' unless defined(&ATW_WEP_104BIT);
eval 'sub ATW_WESK_DATA_MASK () {0xffff;}' unless defined(&ATW_WESK_DATA_MASK);
eval 'sub ATW_WEPCNT_WIEC_MASK () {0xffff;}' unless defined(&ATW_WEPCNT_WIEC_MASK);
eval 'sub ATW_MACTEST_FORCE_IV () {(1<<23);}' unless defined(&ATW_MACTEST_FORCE_IV);
eval 'sub ATW_MACTEST_FORCE_KEYID () {(1<<22);}' unless defined(&ATW_MACTEST_FORCE_KEYID);
eval 'sub ATW_MACTEST_KEYID_MASK () {0x300000;}' unless defined(&ATW_MACTEST_KEYID_MASK);
eval 'sub ATW_MACTEST_MMI_USETXCLK () {(1<<11);}' unless defined(&ATW_MACTEST_MMI_USETXCLK);
eval 'sub ATW_FER_INTR () {(1<<15);}' unless defined(&ATW_FER_INTR);
eval 'sub ATW_FER_GWAKE () {(1<<4);}' unless defined(&ATW_FER_GWAKE);
eval 'sub ATW_FEMR_INTR_EN () {(1<<15);}' unless defined(&ATW_FEMR_INTR_EN);
eval 'sub ATW_FEMR_WAKEUP_EN () {(1<<14);}' unless defined(&ATW_FEMR_WAKEUP_EN);
eval 'sub ATW_FEMR_GWAKE_EN () {(1<<4);}' unless defined(&ATW_FEMR_GWAKE_EN);
eval 'sub ATW_FPSR_INTR_STATUS () {(1<<15);}' unless defined(&ATW_FPSR_INTR_STATUS);
eval 'sub ATW_FPSR_WAKEUP_STATUS () {(1<<4);}' unless defined(&ATW_FPSR_WAKEUP_STATUS);
eval 'sub ATW_FFER_INTA_FORCE () {(1<<15);}' unless defined(&ATW_FFER_INTA_FORCE);
eval 'sub ATW_FFER_GWAKE_FORCE () {(1<<4);}' unless defined(&ATW_FFER_GWAKE_FORCE);
eval 'sub ATW_SR_CLASS_CODE () {(0x/2);}' unless defined(&ATW_SR_CLASS_CODE);
eval 'sub ATW_SR_FORMAT_VERSION () {(0x2/2);}' unless defined(&ATW_SR_FORMAT_VERSION);
eval 'sub ATW_SR_MAJOR_MASK () {0xff;}' unless defined(&ATW_SR_MAJOR_MASK);
eval 'sub ATW_SR_MINOR_MASK () {0xff00;}' unless defined(&ATW_SR_MINOR_MASK);
eval 'sub ATW_SR_MAC00 () {(0x8/2);}' unless defined(&ATW_SR_MAC00);
eval 'sub ATW_SR_MAC01 () {(0xa/2);}' unless defined(&ATW_SR_MAC01);
eval 'sub ATW_SR_MAC10 () {(0xc/2);}' unless defined(&ATW_SR_MAC10);
eval 'sub ATW_SR_CSR20 () {(0x16/2);}' unless defined(&ATW_SR_CSR20);
eval 'sub ATW_SR_ANT_MASK () {0x1c00;}' unless defined(&ATW_SR_ANT_MASK);
eval 'sub ATW_SR_PWRSCALE_MASK () {0x300;}' unless defined(&ATW_SR_PWRSCALE_MASK);
eval 'sub ATW_SR_CLKSAVE_MASK () {0xc0;}' unless defined(&ATW_SR_CLKSAVE_MASK);
eval 'sub ATW_SR_RFTYPE_MASK () {0x38;}' unless defined(&ATW_SR_RFTYPE_MASK);
eval 'sub ATW_SR_BBPTYPE_MASK () {0x7;}' unless defined(&ATW_SR_BBPTYPE_MASK);
eval 'sub ATW_SR_CR28_CR03 () {(0x18/2);}' unless defined(&ATW_SR_CR28_CR03);
eval 'sub ATW_SR_CR28_MASK () {0xff00;}' unless defined(&ATW_SR_CR28_MASK);
eval 'sub ATW_SR_CR03_MASK () {0xff;}' unless defined(&ATW_SR_CR03_MASK);
eval 'sub ATW_SR_CTRY_CR29 () {(0x1a/2);}' unless defined(&ATW_SR_CTRY_CR29);
eval 'sub ATW_SR_CTRY_MASK () {0xff00;}' unless defined(&ATW_SR_CTRY_MASK);
eval 'sub COUNTRY_FCC () {0;}' unless defined(&COUNTRY_FCC);
eval 'sub COUNTRY_IC () {1;}' unless defined(&COUNTRY_IC);
eval 'sub COUNTRY_ETSI () {2;}' unless defined(&COUNTRY_ETSI);
eval 'sub COUNTRY_SPAIN () {3;}' unless defined(&COUNTRY_SPAIN);
eval 'sub COUNTRY_FRANCE () {4;}' unless defined(&COUNTRY_FRANCE);
eval 'sub COUNTRY_MMK () {5;}' unless defined(&COUNTRY_MMK);
eval 'sub COUNTRY_MMK2 () {6;}' unless defined(&COUNTRY_MMK2);
eval 'sub ATW_SR_CR29_MASK () {0xff;}' unless defined(&ATW_SR_CR29_MASK);
eval 'sub ATW_SR_PCI_DEVICE () {(0x20/2);}' unless defined(&ATW_SR_PCI_DEVICE);
eval 'sub ATW_SR_PCI_VENDOR () {(0x22/2);}' unless defined(&ATW_SR_PCI_VENDOR);
eval 'sub ATW_SR_SUB_DEVICE () {(0x24/2);}' unless defined(&ATW_SR_SUB_DEVICE);
eval 'sub ATW_SR_SUB_VENDOR () {(0x26/2);}' unless defined(&ATW_SR_SUB_VENDOR);
eval 'sub ATW_SR_CR15 () {(0x28/2);}' unless defined(&ATW_SR_CR15);
eval 'sub ATW_SR_LOCISPTR () {(0x2a/2);}' unless defined(&ATW_SR_LOCISPTR);
eval 'sub ATW_SR_HICISPTR () {(0x2c/2);}' unless defined(&ATW_SR_HICISPTR);
eval 'sub ATW_SR_CSR18 () {(0x2e/2);}' unless defined(&ATW_SR_CSR18);
eval 'sub ATW_SR_D0_D1_PWR () {(0x40/2);}' unless defined(&ATW_SR_D0_D1_PWR);
eval 'sub ATW_SR_D2_D3_PWR () {(0x42/2);}' unless defined(&ATW_SR_D2_D3_PWR);
eval 'sub ATW_SR_CIS_WORDS () {(0x52/2);}' unless defined(&ATW_SR_CIS_WORDS);
unless(defined(&ATW_SR_TXPOWER)) {
    sub ATW_SR_TXPOWER {
	my($chnl) = @_;
	eval q((0x54/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LPF_CUTOFF)) {
    sub ATW_SR_LPF_CUTOFF {
	my($chnl) = @_;
	eval q((0x62/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LNA_GS_THRESH)) {
    sub ATW_SR_LNA_GS_THRESH {
	my($chnl) = @_;
	eval q((0x70/2+ (($chnl) - 1)/2));
    }
}
eval 'sub ATW_SR_CHECKSUM () {(0x7e/2);}' unless defined(&ATW_SR_CHECKSUM);
eval 'sub ATW_SR_CIS () {(0x80/2);}' unless defined(&ATW_SR_CIS);
eval 'sub at_stat () { &at_ctl;}' unless defined(&at_stat);
eval 'sub ATW_TXCTL_OWN () {(1<<31);}' unless defined(&ATW_TXCTL_OWN);
eval 'sub ATW_TXCTL_DONE () {(1<<30);}' unless defined(&ATW_TXCTL_DONE);
eval 'sub ATW_TXCTL_TXDR_MASK () {0xff00000;}' unless defined(&ATW_TXCTL_TXDR_MASK);
eval 'sub ATW_TXCTL_TL_MASK () {0xfffff;}' unless defined(&ATW_TXCTL_TL_MASK);
eval 'sub ATW_TXSTAT_OWN () { &ATW_TXCTL_OWN;}' unless defined(&ATW_TXSTAT_OWN);
eval 'sub ATW_TXSTAT_DONE () { &ATW_TXCTL_DONE;}' unless defined(&ATW_TXSTAT_DONE);
eval 'sub ATW_TXSTAT_ES () {(1<<29);}' unless defined(&ATW_TXSTAT_ES);
eval 'sub ATW_TXSTAT_TLT () {(1<<28);}' unless defined(&ATW_TXSTAT_TLT);
eval 'sub ATW_TXSTAT_TRT () {(1<<27);}' unless defined(&ATW_TXSTAT_TRT);
eval 'sub ATW_TXSTAT_TUF () {(1<<26);}' unless defined(&ATW_TXSTAT_TUF);
eval 'sub ATW_TXSTAT_TRO () {(1<<25);}' unless defined(&ATW_TXSTAT_TRO);
eval 'sub ATW_TXSTAT_SOFBR () {(1<<24);}' unless defined(&ATW_TXSTAT_SOFBR);
eval 'sub ATW_TXSTAT_ARC_MASK () {0xfff;}' unless defined(&ATW_TXSTAT_ARC_MASK);
eval 'sub ATW_TXFLAG_IC () {(1<<31);}' unless defined(&ATW_TXFLAG_IC);
eval 'sub ATW_TXFLAG_LS () {(1<<30);}' unless defined(&ATW_TXFLAG_LS);
eval 'sub ATW_TXFLAG_FS () {(1<<29);}' unless defined(&ATW_TXFLAG_FS);
eval 'sub ATW_TXFLAG_TER () {(1<<25);}' unless defined(&ATW_TXFLAG_TER);
eval 'sub ATW_TXFLAG_TCH () {(1<<24);}' unless defined(&ATW_TXFLAG_TCH);
eval 'sub ATW_TXFLAG_TBS2_MASK () {0xfff000;}' unless defined(&ATW_TXFLAG_TBS2_MASK);
eval 'sub ATW_TXFLAG_TBS1_MASK () {0xfff;}' unless defined(&ATW_TXFLAG_TBS1_MASK);
eval 'sub ar_rssi () { &ar_ctl;}' unless defined(&ar_rssi);
eval 'sub ATW_RXCTL_RER () {(1<<25);}' unless defined(&ATW_RXCTL_RER);
eval 'sub ATW_RXCTL_RCH () {(1<<24);}' unless defined(&ATW_RXCTL_RCH);
eval 'sub ATW_RXCTL_RBS2_MASK () {0xfff000;}' unless defined(&ATW_RXCTL_RBS2_MASK);
eval 'sub ATW_RXCTL_RBS1_MASK () {0xfff;}' unless defined(&ATW_RXCTL_RBS1_MASK);
eval 'sub ATW_RXSTAT_OWN () {(1<<31);}' unless defined(&ATW_RXSTAT_OWN);
eval 'sub ATW_RXSTAT_ES () {(1<<30);}' unless defined(&ATW_RXSTAT_ES);
eval 'sub ATW_RXSTAT_SQL () {(1<<29);}' unless defined(&ATW_RXSTAT_SQL);
eval 'sub ATW_RXSTAT_DE () {(1<<28);}' unless defined(&ATW_RXSTAT_DE);
eval 'sub ATW_RXSTAT_FS () {(1<<27);}' unless defined(&ATW_RXSTAT_FS);
eval 'sub ATW_RXSTAT_LS () {(1<<26);}' unless defined(&ATW_RXSTAT_LS);
eval 'sub ATW_RXSTAT_PCF () {(1<<25);}' unless defined(&ATW_RXSTAT_PCF);
eval 'sub ATW_RXSTAT_SFDE () {(1<<24);}' unless defined(&ATW_RXSTAT_SFDE);
eval 'sub ATW_RXSTAT_SIGE () {(1<<23);}' unless defined(&ATW_RXSTAT_SIGE);
eval 'sub ATW_RXSTAT_CRC16E () {(1<<22);}' unless defined(&ATW_RXSTAT_CRC16E);
eval 'sub ATW_RXSTAT_RXTOE () {(1<<21);}' unless defined(&ATW_RXSTAT_RXTOE);
eval 'sub ATW_RXSTAT_CRC32E () {(1<<20);}' unless defined(&ATW_RXSTAT_CRC32E);
eval 'sub ATW_RXSTAT_ICVE () {(1<<19);}' unless defined(&ATW_RXSTAT_ICVE);
eval 'sub ATW_RXSTAT_DA1 () {(1<<17);}' unless defined(&ATW_RXSTAT_DA1);
eval 'sub ATW_RXSTAT_DA0 () {(1<<16);}' unless defined(&ATW_RXSTAT_DA0);
eval 'sub ATW_RXSTAT_RXDR_MASK () {0xf000;}' unless defined(&ATW_RXSTAT_RXDR_MASK);
eval 'sub ATW_RXSTAT_FL_MASK () {0xfff;}' unless defined(&ATW_RXSTAT_FL_MASK);
eval 'sub ATW_SRAM_ADDR_INDIVL_KEY () {0x;}' unless defined(&ATW_SRAM_ADDR_INDIVL_KEY);
eval 'sub ATW_SRAM_ADDR_SHARED_KEY () {(0x160 * 2);}' unless defined(&ATW_SRAM_ADDR_SHARED_KEY);
eval 'sub ATW_SRAM_ADDR_SSID () {(0x180 * 2);}' unless defined(&ATW_SRAM_ADDR_SSID);
eval 'sub ATW_SRAM_ADDR_SUPRATES () {(0x191 * 2);}' unless defined(&ATW_SRAM_ADDR_SUPRATES);
eval 'sub ATW_SRAM_MAXSIZE () {(0x200 * 2);}' unless defined(&ATW_SRAM_MAXSIZE);
eval 'sub ATW_SRAM_A_SIZE () { &ATW_SRAM_MAXSIZE;}' unless defined(&ATW_SRAM_A_SIZE);
eval 'sub ATW_SRAM_B_SIZE () {(0x1c0 * 2);}' unless defined(&ATW_SRAM_B_SIZE);
1;
