/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class NewRuntimeComposite
extends Composite {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected IRuntimeWorkingCopy runtime;
    protected Map runtimeMap = new HashMap();
    protected TaskModel taskModel;
    protected IWizardHandle wizard;
    protected String type;
    protected String version;
    protected String runtimeTypeId;

    public NewRuntimeComposite(Composite parent, IWizardHandle wizard, TaskModel tm, String type, String version, String runtimeTypeId) {
        super(parent, 0);
        this.wizard = wizard;
        this.taskModel = tm;
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.createControl();
        wizard.setTitle(Messages.wizNewRuntimeTitle);
        wizard.setDescription(Messages.wizNewRuntimeDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("newServerWiz"));
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        RuntimeTypeComposite comp = new RuntimeTypeComposite(this, 0, true, new RuntimeTypeComposite.RuntimeTypeSelectionListener(){

            public void runtimeTypeSelected(IRuntimeType runtimeType) {
                NewRuntimeComposite.this.handleSelection(runtimeType);
            }
        }, this.type, this.version, this.runtimeTypeId);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        comp.setLayoutData(data);
    }

    protected void handleSelection(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            this.runtime = null;
        } else {
            try {
                this.runtime = null;
                this.runtime = (IRuntimeWorkingCopy)this.runtimeMap.get(runtimeType);
            }
            catch (Exception exception) {}
            if (this.runtime == null) {
                try {
                    this.runtime = runtimeType.createRuntime(null, null);
                    ServerUtil.setRuntimeDefaultName((IRuntimeWorkingCopy)this.runtime);
                    if (this.runtime != null) {
                        this.runtimeMap.put(runtimeType, this.runtime);
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.taskModel.putObject("runtime", (Object)this.runtime);
        this.wizard.update();
    }

    public IRuntimeWorkingCopy getRuntime() {
        return this.runtime;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Control[] c = this.getChildren();
        if (c != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
    }
}

