/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.util.ErrorMessage;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XSDValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.AbstractXMLConformanceFactory;
import org.eclipse.wst.wsdl.validation.internal.xml.DefaultXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportHolder
implements Comparable {
    private MessageGenerator messagegenerator;
    private WSDLDocument importingWSDLDoc = null;
    private WSDLDocument wsdlDocument = null;
    private Definition importingDef = null;
    private Element importingDocImportElement = null;
    private String namespace = null;
    private String location = null;
    private String classpathURI = null;
    private String contextURI = null;
    private int depth;
    private Element element = null;
    private List schemas = new ArrayList();
    private boolean isWSDLFileImport = true;
    private boolean importInvalid = false;
    private Import importDef = null;
    private IWSDL11ValidationInfo valinfo;
    static /* synthetic */ Class class$0;

    public ImportHolder(String namespace, String location, String contextURI, WSDLDocument importingWSDLDoc, int depth, Element importingDocImportElement, MessageGenerator messagegenerator, IWSDL11ValidationInfo valinfo) {
        this.messagegenerator = messagegenerator;
        this.valinfo = valinfo;
        this.importingWSDLDoc = importingWSDLDoc;
        if (importingWSDLDoc != null) {
            this.importingDef = importingWSDLDoc.getDefinition();
        }
        this.importingDocImportElement = importingDocImportElement;
        this.depth = depth;
        this.namespace = namespace;
        this.location = location;
        if (this.location == null) {
            this.location = namespace;
        }
        this.contextURI = contextURI;
        this.location = this.location.replace('\\', '/');
        IURIResolutionResult classpathURI = valinfo.getURIResolver().resolve(this.contextURI, this.namespace, this.location);
        if (classpathURI.getLogicalLocation() != null) {
            this.location = classpathURI.getLogicalLocation();
        }
        if (classpathURI.getPhysicalLocation() != null) {
            this.classpathURI = classpathURI.getPhysicalLocation();
            this.contextURI = null;
        }
    }

    public void initialize() {
        Element documentElement = null;
        try {
            documentElement = this.getElement();
        }
        catch (WSDLException wSDLException) {}
        if (documentElement != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)documentElement)) {
                if (this.isXMLValid(this.classpathURI)) {
                    try {
                        this.wsdlDocument = new WSDLDocument(this.location, documentElement, this.depth, this.messagegenerator, this.valinfo);
                        this.createWSDLImport(this.wsdlDocument);
                    }
                    catch (WSDLException wSDLException) {
                        this.valinfo.addError(this.messagegenerator.getString("_UNABLE_TO_IMPORT_BAD_LOCATION", "'" + this.importDef.getLocationURI() + "'"), this.importingDocImportElement);
                    }
                }
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_XSD_2001, (Node)documentElement)) {
                this.createXSDImport();
            }
        }
    }

    protected boolean isXMLValid(String uri) {
        XMLGrammarPool grammarPool;
        IXMLValidator xmlValidator = AbstractXMLConformanceFactory.getInstance().getXMLValidator();
        xmlValidator.setFile(uri);
        xmlValidator.setURIResolver(this.valinfo.getURIResolver());
        if (xmlValidator instanceof DefaultXMLValidator && (grammarPool = this.valinfo.getXMLCache()) != null) {
            ((DefaultXMLValidator)xmlValidator).setGrammarPool(grammarPool);
        }
        xmlValidator.run();
        if (xmlValidator.hasErrors()) {
            List errors = xmlValidator.getErrors();
            Iterator errorsIter = errors.iterator();
            while (errorsIter.hasNext()) {
                IValidationMessage valMes = (IValidationMessage)errorsIter.next();
                this.valinfo.addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI());
            }
            this.importInvalid = true;
            return false;
        }
        return true;
    }

    public WSDLDocument getImportingDocument() {
        return this.importingWSDLDoc;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContextURI() {
        return this.contextURI;
    }

    public int getDepth() {
        return this.depth;
    }

    public Definition getImportingDefinition() {
        return this.importingDef;
    }

    /*
     * Exception decompiling
     */
    public Element getElement() throws WSDLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 682->685)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Import createWSDLImport(WSDLDocument wsdlDocument) {
        if (this.importDef != null) {
            return this.importDef;
        }
        this.importDef = this.getNewImport();
        if (this.importDef != null) {
            this.importDef.setDefinition(wsdlDocument.getDefinition());
            this.schemas.addAll(wsdlDocument.getSchemas());
            this.importingWSDLDoc.addSchemas(this.schemas);
        }
        return this.importDef;
    }

    public Import createXSDImport() {
        if (this.importDef != null) {
            return this.importDef;
        }
        this.importDef = this.getNewImport();
        XSDValidator xsdvalidator = new XSDValidator();
        xsdvalidator.validate(this.location, XMLCatalogResolver.getInstance(), this.valinfo.getSchemaCache());
        if (xsdvalidator.isValid()) {
            XSModel schema = xsdvalidator.getXSModel();
            if (schema != null) {
                this.schemas.add(schema);
            }
        } else {
            Iterator errors = xsdvalidator.getErrors().iterator();
            while (errors.hasNext()) {
                ErrorMessage err = (ErrorMessage)errors.next();
                String uri = err.getURI();
                int line = err.getErrorLine();
                String errmess = err.getErrorMessage();
                this.valinfo.addError(errmess, line, err.getErrorColumn(), uri);
            }
        }
        this.importingWSDLDoc.addSchemas(this.schemas);
        return this.importDef;
    }

    public Import getImport() {
        return this.importDef;
    }

    private Import getNewImport() {
        if (this.importInvalid) {
            return null;
        }
        Import importDef = this.importingDef.createImport();
        if (this.namespace != null) {
            importDef.setNamespaceURI(this.namespace);
        }
        if (this.location != null) {
            importDef.setLocationURI(this.location);
        }
        if (this.element != null) {
            Element tempEl = DOMUtils.getFirstChildElement((Element)this.element);
            while (tempEl != null) {
                if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                    importDef.setDocumentationElement(tempEl);
                }
                tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
            }
        }
        return importDef;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public boolean isWSDLFileImport() {
        return this.isWSDLFileImport;
    }

    public boolean equals(Object obj) {
        Class<?> clazz = obj.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.ImportHolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            ImportHolder otherImport = (ImportHolder)obj;
            if (this.getNamespace().equals(otherImport.getNamespace()) && this.getLocation().equals(otherImport.getLocation())) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        ImportHolder otherImport = (ImportHolder)obj;
        return (String.valueOf(this.getNamespace()) + this.getLocation()).compareTo(String.valueOf(otherImport.getNamespace()) + otherImport.getLocation());
    }

    public void setMessageGenerator(MessageGenerator mg) {
        this.messagegenerator = mg;
    }

    public boolean isImportInvalid() {
        return this.importInvalid;
    }
}

