"""Generated message classes for apikeys version v1.

Manages the API keys associated with developer projects.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'apikeys'


class AndroidApplication(_messages.Message):
  """Identifier of an Android application for API key use.

  Fields:
    packageName: The package name of the application.
    sha1Fingerprint: The 20 byte SHA1 fingerprint of the application.
  """

  packageName = _messages.StringField(1)
  sha1Fingerprint = _messages.BytesField(2)


class AndroidKeyDetails(_messages.Message):
  """Key details that are specific to android keys.

  Fields:
    allowedApplications: A list of Android applications that are allowed to
      make API calls with this key.
  """

  allowedApplications = _messages.MessageField('AndroidApplication', 1, repeated=True)


class ApiKey(_messages.Message):
  """The representation of an API key managed by the `ApiKeys` API. An API key
  is used for programmatic access to a project by a service account.

  Fields:
    androidKeyDetails: Key details that are specific to android keys.
    browserKeyDetails: Key details that are specific to browser keys.
    createTime: A timestamp identifying the time this API key was originally
      created.
    createdBy: Email address of the user who originally created this API key.
    currentKey: An encrypted and signed value held by this API key.
    displayName: Human-readable display name of this API key. Modifiable by
      user.
    iosKeyDetails: Key details that are specific to iOS keys.
    keyId: Unique identifier for this ApiKey assigned by the server.
    previousKey: The value of `current_key` before this API key was
      regenerated.
    previousKeyExpireTime: The expiration time for the validity of a
      `previous_key` value after an API key regeneration.
    serverKeyDetails: Key details that are specific to server keys.
  """

  androidKeyDetails = _messages.MessageField('AndroidKeyDetails', 1)
  browserKeyDetails = _messages.MessageField('BrowserKeyDetails', 2)
  createTime = _messages.StringField(3)
  createdBy = _messages.StringField(4)
  currentKey = _messages.StringField(5)
  displayName = _messages.StringField(6)
  iosKeyDetails = _messages.MessageField('IosKeyDetails', 7)
  keyId = _messages.StringField(8)
  previousKey = _messages.StringField(9)
  previousKeyExpireTime = _messages.StringField(10)
  serverKeyDetails = _messages.MessageField('ServerKeyDetails', 11)


class ApikeysProjectsApiKeysBatchDeleteRequest(_messages.Message):
  """A ApikeysProjectsApiKeysBatchDeleteRequest object.

  Fields:
    keyIds: The identifiers for the keys to be deleted.
    projectId: The project that owns the API keys.
  """

  keyIds = _messages.StringField(1, repeated=True)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsApiKeysCreateRequest(_messages.Message):
  """A ApikeysProjectsApiKeysCreateRequest object.

  Fields:
    apiKey: A ApiKey resource to be passed as the request body.
    projectId: The project for which this API key will be created.
  """

  apiKey = _messages.MessageField('ApiKey', 1)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsApiKeysDeleteRequest(_messages.Message):
  """A ApikeysProjectsApiKeysDeleteRequest object.

  Fields:
    keyId: The identifier for the key to be deleted.
    projectId: The project that owns the API key.
  """

  keyId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsApiKeysGetRequest(_messages.Message):
  """A ApikeysProjectsApiKeysGetRequest object.

  Fields:
    keyId: The identifier for the key to be retrieved.
    projectId: The project that owns the API key.
  """

  keyId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsApiKeysListRequest(_messages.Message):
  """A ApikeysProjectsApiKeysListRequest object.

  Fields:
    pageSize: Specifies the maximum number of results to be returned at a
      time.
    pageToken: Requests a specific page of results.
    projectId: Lists all API keys associated with this project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class ApikeysProjectsApiKeysPatchRequest(_messages.Message):
  """A ApikeysProjectsApiKeysPatchRequest object.

  Fields:
    apiKey: A ApiKey resource to be passed as the request body.
    keyId: The identifier for the key to be modified.
    projectId: The project that owns the API key.
    updateMask: Field mask for updates.
  """

  apiKey = _messages.MessageField('ApiKey', 1)
  keyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ApikeysProjectsApiKeysRegenerateRequest(_messages.Message):
  """A ApikeysProjectsApiKeysRegenerateRequest object.

  Fields:
    keyId: The identifier for the key to be regenerated.
    projectId: The project that owns the API key.
  """

  keyId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsApiKeysRevertRequest(_messages.Message):
  """A ApikeysProjectsApiKeysRevertRequest object.

  Fields:
    keyId: The identifier for the key to be reverted.
    projectId: The project that owns the API key.
  """

  keyId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class ApikeysProjectsDeletedApiKeysListRequest(_messages.Message):
  """A ApikeysProjectsDeletedApiKeysListRequest object.

  Fields:
    pageSize: Specifies the maximum number of results to be returned at a
      time.
    pageToken: Requests a specific page of results.
    projectId: Lists all deleted API keys associated with this project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class ApikeysProjectsGetProjectForApiKeyRequest(_messages.Message):
  """A ApikeysProjectsGetProjectForApiKeyRequest object.

  Fields:
    apiKey: Finds the project that owns the key with this `current_key` value.
  """

  apiKey = _messages.StringField(1)


class BrowserKeyDetails(_messages.Message):
  """Key details that are specific to browser keys.

  Fields:
    allowedReferrers: A list of regular expressions for the referrer URLs that
      are allowed when making an API call with this key.
  """

  allowedReferrers = _messages.StringField(1, repeated=True)


class DeletedApiKey(_messages.Message):
  """Information about a deleted API key.

  Enums:
    SourceValueValuesEnum: What caused the key to be deleted

  Fields:
    apiKey: The API key that was deleted
    deletionTime: The time at which the key was deleted
    source: What caused the key to be deleted
  """

  class SourceValueValuesEnum(_messages.Enum):
    """What caused the key to be deleted

    Values:
      DELETION: This API Key was deleted via a DeleteApiKey API call.
      REGENERATION: This API Key was deleted by a RegenerateApiKey API call.
    """
    DELETION = 0
    REGENERATION = 1

  apiKey = _messages.MessageField('ApiKey', 1)
  deletionTime = _messages.StringField(2)
  source = _messages.EnumField('SourceValueValuesEnum', 3)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GetProjectForApiKeyResponse(_messages.Message):
  """Response message for `GetProjectForApiKey` method.

  Fields:
    projectNumber: The project number corresponding to the project key in the
      requests. The project number that owns the API key specified in the
      request.
  """

  projectNumber = _messages.IntegerField(1)


class IosKeyDetails(_messages.Message):
  """Key details that are specific to iOS keys.

  Fields:
    allowedBundleIds: A list of bundle IDs that are allowed when making API
      calls with this key.
  """

  allowedBundleIds = _messages.StringField(1, repeated=True)


class ListApiKeysResponse(_messages.Message):
  """Response message for `ListApiKeys` method.

  Fields:
    keys: A list of API keys.
    nextPageToken: The pagination token for the next page of results.
  """

  keys = _messages.MessageField('ApiKey', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeletedApiKeysResponse(_messages.Message):
  """Response message for `ListDeletedApiKeys` method.

  Fields:
    keys: A list of deleted API keys.
    nextPageToken: The pagination token for the next page of results.
  """

  keys = _messages.MessageField('DeletedApiKey', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ServerKeyDetails(_messages.Message):
  """Key details that are specific to server keys.

  Fields:
    allowedIps: A list of the caller IP addresses that are allowed when making
      an API call with this key.
  """

  allowedIps = _messages.StringField(1, repeated=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'apikeys')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'apikeys')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'apikeys')
