'''OpenGL extension ARB.shading_language_packing

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.shading_language_packing to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides the GLSL built-in functions to convert a 32-bit
	unsigned integer holding a pair of 16-bit floating-point values to or from
	a two-component floating-point vector (vec2).  
	
	This mechanism allows GLSL shaders to read and write 16-bit floating-point
	encodings (via 32-bit unsigned integers) without introducing a full set of
	16-bit floating-point data types.
	
	This extension also adds the GLSL built-in packing functions included in
	GLSL version 4.00 and the ARB_gpu_shader5 extension which pack and unpack
	vectors of small fixed-point data types into a larger scalar. By putting
	these packing functions in this separate extension it allows
	implementations to provide these functions in hardware that supports them
	independent of the other ARB_gpu_shader5 features.
	
	In addition to the packing functions from ARB_gpu_shader5 this extension
	also adds the missing [un]packSnorm2x16 for completeness.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/shading_language_packing.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.shading_language_packing import *
### END AUTOGENERATED SECTION